/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                       Copyright (c) 1996,1997                         */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                                                                       */
/*                 Author: Paul Taylor                                   */
/*                   Date: 6 Jan 1998                                    */
/* --------------------------------------------------------------------- */
/*            LPC residual synthesis alternative version                 */
/*                                                                       */
/*************************************************************************/

#include "UniSyn.h"
#include "EST_error.h"

void make_mapping(EST_Relation &source_lab, EST_Track &source_pm, 
		  EST_Relation &target_lab,
		  EST_Track &target_pm, EST_IVector &map) 
{
    int i = 0;
    int s_i_start, s_i_end, t_i_start, t_i_end;
    EST_Item *s, *t;
    float s_end, s_start, t_end, t_start, f, m;
    map.resize(target_pm.num_frames());
    
    s_start = t_start = 0.0;

    if (target_pm.t(target_pm.num_frames() - 1) < 
	target_lab.tail()->fF("end"))
	EST_warning("Target pitchmarks end before end of target segment "
		    "timings. Expect a truncated utterance.\n");

    for (s = source_lab.head(), t = target_lab.head(); s && t; 
	 s = next(s), t = next(t))
    {
	s_end = s->fF("end");
	t_end = t->fF("end");
	
	s_i_start = source_pm.index_below(s_start);
	s_i_end = source_pm.index_below(s->fF("end"));
	t_i_start = target_pm.index_below(t_start);
	t_i_end = target_pm.index_below(t->fF("end"));

	// fudge to make sure that at least one frame is available
	if (s_i_end <= s_i_start)
	    s_i_end += 1;
	
	// printf("%d %d %d %d\n", s_i_start, s_i_end, t_i_start, t_i_end);
	// printf("%f %f %f %f\n", s_start, s_end, t_start, t_end);
	
	m = float (s_i_end - s_i_start)/ float(t_i_end - t_i_start);
	for (i = t_i_start, f = 0.0; i < t_i_end; ++i, ++f)
            map[i] = EST_NINT(f * m) + s_i_start;

	s_start = s->fF("end");
	t_start = t->fF("end");
    }
    if (i == 0)
	map.resize(0);  // nothing to synthesize
    else
	map.resize(i - 1);
}

void add_wave_to_utterance(EST_Utterance &u, EST_Wave &sig, 
			const EST_String &name)
{
    u.create_relation(name);
    EST_Item *item = u.relation(name)->append();
//    item->fset("name", "[waveform]");
    item->fset("wave", (void *)(&sig), gc_wave);
}

void gc_framevector(void *f)
{
    delete (EST_FrameVector *)f;
}



/*
int verify_spn(EST_Stream &source, EST_Stream &target)
{
    EST_Stream_Item *s, *t;
    
    for (s = source.head(), t = target.head(); s && t; s = next(s),t = next(t))
	if (s->name() != t->name())
	{
	    cerr << "Differing labels in source and target files" 
		<< s->name() << " vs " << t->name() << endl;
	    return -1;
	}
    if (s == 0 && t == 0)
	return 1;
    if (s != 0)
	cerr << "Error: More source labels than target labels\n";
    if (t != 0)
	cerr << "Error: More source labels than target labels\n";
    return -1;
}
*/

/*


int read_spn(EST_String &filename, EST_Utterance &u)
{
    EST_Item *p, target;
    u.load(filename);
    cout << "loaded\n" << u;
    EST_String tmp, tmp1, tmp2;
    
    u.create_relation("Target");
    
    for (p = u.relation("Segment")->head(); p; p = next(p))
    {
	    // has to be redone for new Stream_Item class
	for (s = p->fields.head(); s; s = next(s))
	{
	    tmp = p->fields(s);
	    if (tmp.contains(RXwhite, 0))
		tmp = tmp.after(RXwhite);
	    cout << ":" << tmp << ":\n";
	    tmp1 = tmp.before(RXwhite);
	    tmp2 = tmp.after(RXwhite);
	    cout << "time " << tmp1 << " F0:" << tmp2 << endl;
	    
	    if (tmp1.contains("%"))
	    {
		tmp1 = tmp1.before("%");
		percent = true;
	    }
	    if (!tmp1.matches(RXdouble))
	    {
		cerr << "Wrong format in timing info in Target:" 
		    << tmp1 << endl;
		return -1;
	    }
	    position = percent ? atof(tmp1) * p->dur() : atof(tmp1);
	    
	    time = position + p->start();
	    //	    f0 = aotf(tmp2);
	    target.set_end(time);
	    target.set_addr(0);
	    target.set_name(tmp2);
	    cout << "t add1 " << target.addr() << endl;
	    t = u.stream("Target").append(target);
	    cout << "t add2 " << t->addr() << endl;
	    p->make_link(*t);
	    t->make_link(*p);
	}

    }
    //    check_targs(*u);
    
    *cdebug << "Parsed\n" << u;
    return 0;
}
*/
