 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /************************************************************************/
 /*                 Author: Richard Caley (rjc@cstr.ed.ac.uk)            */
 /*                   Date: Fri Apr 11 1997                              */
 /************************************************************************/
 /*                                                                      */
 /* The most simple frame synthesis -- just glue together raw          */
 /* waveforms. This is just a trivial test of the API.                   */
 /*                                                                      */
 /************************************************************************/

#include "festival.h"
#include "UnitDatabase.h"
#include "FramesUnit.h"
#include "module_support.h"

static ModuleDescription description =
{
  "simple_signal_concatenation", 1.0,
  "CSTR",
  "Richard Caley <rjc@cstr.ed.ac.uk>",
  {
    "Trivial synthesis by concatenating waveforms.",
    NULL
  },
  {
    { "Unit",	"Units to be synthesised." },
    {NULL,NULL}
  },
  { {NULL,NULL}
  },
  {
    { "Wave",		"Synthesised waveform." },
    {NULL,NULL}
  },
  { {NULL,NULL,NULL,NULL}
  }
};

LISP simple_signal_concatenation(LISP args)
{
  EST_Utterance *utt;

  EST_String unit_stream_name("Unit");	
  EST_String wave_stream_name("Wave");

  EST_Relation *unit_stream=NULL, *wave_stream=NULL;

  unpack_module_args(args, 
		     utt, 
		     unit_stream_name, unit_stream, sat_existing,
		     wave_stream_name, wave_stream, sat_replace);
	
  EST_Wave *result;

  EST_Item *un;

  unsigned int length=0;

  for(un=unit_stream->head(); un; un=next(un))
    {

      Unit *unit = (Unit *)(un->f("Unit").ptr());
      
      if (!unit)
	{
	  cerr << "missing unit " << un->name() << "\n";
	  continue;
	}
      if (!unit->database())
	{
	  cerr << "orphan unit " << un->name() << "\n";
	  continue;
	}
      if (!unit->property("frames_subtype"))
	{
	  cwarn << "bad unit type " << unit->subtype_name() <<"\n";
	  continue;
	}

      FramesUnit *frames = (FramesUnit *)unit;

      EST_Wave *wave = frames->signal();

      cwarn << "    wave " << (int)wave << "\n";

      if (!wave)
	  return NULL;

      length += wave->num_samples();
      
    }

  cout << " length = " << length << "\n";

  unsigned int pos=0;
  short *result_data = new short[length];
  EST_Wave *wave = NULL;


  for(un=unit_stream->head(); un; un=next(un))
    {
      Unit *unit = (Unit *)(un->f("Unit").ptr());
      FramesUnit *frames = (FramesUnit *)unit;

      wave = frames->signal();
      for (int i=0; i<wave->num_samples(); i++)
	   result_data[pos+i] = wave->a(i);
      pos += wave->num_samples();
    }

  result = new EST_Wave;

  if (wave)
  {
      result->resize(length,0);
      for (int i=0; i<result->length(); i++)
	  result->a_no_check(i) = result_data[i];
      result->set_sample_rate(wave->sample_rate());
  }

  EST_Item *item = wave_stream->append();

  item->set_name("[waveform]");
  item->f.set("Wave", result, gc_wave);

  return NIL;
}

void simple_signal_concatenation_init(void)
{
  proclaim_module("simple_signal_concatenation", &description);
  init_module_subr("simple_signal_concatenation", simple_signal_concatenation, &description);
}
