/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                     Copyright (c) 1994,1995,1996                      */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                    Author :  Paul Taylor                              */
/*                    Date   :  February 1997                            */
/*-----------------------------------------------------------------------*/
/*                 Utility IO Function header file                       */
/*                                                                       */
/*=======================================================================*/

#ifndef __EST_IO_AUX_H__
#define __EST_IO_AUX_H__

#include "EST_unix.h"
#include "EST_common.h"
#include "EST_String.h"
#include "EST_types.h"

EST_String make_tmp_filename();
EST_String stdin_to_file();
int writable_file(char *filename);
int readable_file(char *filename);

inline int
delete_file(const EST_String &filename)
{
    // a little unnecessary to wrap this up like this -- except
    // if you want to be portable to weird OSs
    return (unlink(filename) == 0);

    // could do more with return codes from unlink ...
}

EST_String uncompress_file_to_temporary(const EST_String &filename,const EST_String &prog_name);

int compress_file_in_place(const EST_String &filename, const EST_String &prog_name);

int compress_file(const EST_String &filename,
		  const EST_String &new_filename, 
		  const EST_String &prog_name);
		  
#define numeric_char(in) (((in < '9' ) && (in > '0')) ? TRUE : FALSE)

int socket_receive_file(int fd, const EST_String &filename);
int socket_send_file(int fd, const EST_String &filename);


#endif /*__EST_IO_AUX_H__ */
