package cstr.awt;

import java.util.*;
import java.lang.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;

public class ImageCanvas extends Canvas
{
  Image image;
  int pwidth, pheight;

  private void init(Image im, double xscale, double yscale)
    {
      pwidth = (int)(im.getWidth(this)*xscale);
      pheight = (int)(im.getHeight(this)*yscale);

      if (xscale != 1.0 || yscale != 1.0)
	{
	  ImageFilter filter =  new ReplicateScaleFilter(pwidth, pheight);

	  image = createImage(new FilteredImageSource(im.getSource(), filter));
	}
      else
	image = im;
    }
  
  public ImageCanvas(Image touse, double xscale, double yscale)
    {
      super();
      
      init(touse, xscale, yscale);
    }

  public ImageCanvas(ImageProducer prod, double xscale, double yscale)
    {
      super();

      init(createImage(prod), xscale, yscale);
    }

  public ImageCanvas(Image touse, double scale)
    {
      super();
      
      init(touse, scale, scale);
    }

  public ImageCanvas(ImageProducer prod, double scale)
    {
      super();

      init(createImage(prod), scale, scale);
    }

  public ImageCanvas(Image touse)
    {
      super();
      
      init(touse, 1.0, 1.0);
    }

  public ImageCanvas(ImageProducer prod)
    {
      super();

      init(createImage(prod), 1.0, 1.0);
    }

  public boolean imageUpdate(Image img,
			     int flags,
			     int x,
			     int y,
			     int w,
			     int h)
    {
      int oh =pheight;
      int ow = pwidth;

      if ((flags & ImageObserver.WIDTH) != 0)
	pwidth = w;
      if ((flags & ImageObserver.HEIGHT) != 0 )
	pheight = h;

      if (pwidth!= ow || pheight != oh)
	  setSize(pwidth, pheight);

      repaint();
      return !((flags & ImageObserver.ALLBITS) != 0);
    }

  public Dimension getPreferredSize()
    {
      return new Dimension(pwidth, pheight);
    }

  public Dimension getMinimumSize()
    {
      return new Dimension(pwidth, pheight);
    }

  public void update(Graphics g)
    {
      paint(g);
    }
  public void paint(Graphics g)
    {
      g.drawImage(image, 0, 0, pwidth, pheight, this);
    }
}
