open Safestd
open Safetk
open Safeapplets
open Safemmm

module Provide = struct
  let capabilities = Capabilities.get()
  end

module Mmm = Safemmm.Get(Provide)

open Html
open Hyper
open Viewers

let open_meta goto fo t =
 try
  let equiv = get_attribute t "http-equiv" in
    match Mstring.lowercase equiv with
      "refresh" ->
         let content = get_attribute t "content" in
         let pos = Mstring.first_char_pos ';' content
         and pos2 = Mstring.first_char_pos '=' content in
         let delay = int_of_string (String.sub content 0 pos)
         and url = String.sub content (pos2+1) 
                            (String.length content - pos2 - 1) in
             Timer.add (delay * 1000) (fun () -> goto url);
	     ()
      | _ -> ()
  with
    _ -> ()

let _ =
   Mmm.add_html_display_hook (fun mach ->
     let goto = (List.assoc "goto" mach#ctx.viewer_hyper).hyper_func in
     let follow uri =
       let link = {h_uri = uri; h_context = Some mach#base; h_method = GET} in
         goto link
     in
       mach#add_tag "meta" (open_meta follow) (fun _ ->()))
