/*
 * Decompiled with CFR 0.152.
 */
package netscape.softupdate;

import java.util.Enumeration;
import java.util.Vector;
import netscape.javascript.JSObject;
import netscape.security.AppletSecurity;
import netscape.security.ForbiddenTargetException;
import netscape.security.Principal;
import netscape.security.PrivilegeManager;
import netscape.security.Target;
import netscape.security.UserDialogHelper;
import netscape.security.UserTarget;
import netscape.softupdate.FolderSpec;
import netscape.softupdate.InstallExecute;
import netscape.softupdate.InstallFile;
import netscape.softupdate.InstallObject;
import netscape.softupdate.ProgressMediator;
import netscape.softupdate.SoftUpdateException;
import netscape.softupdate.Strings;
import netscape.softupdate.VersionInfo;
import netscape.softupdate.VersionRegistry;
import netscape.softupdate.WinProfile;
import netscape.softupdate.WinReg;

public final class SoftwareUpdate {
    static final int nTargets = 3;
    static String[] targetNames = new String[]{"LimitedInstall", "FullInstall", "SilentInstall"};
    public static final int LIMITED_INSTALL = 0;
    public static final int FULL_INSTALL = 1;
    public static final int SILENT_INSTALL = 2;
    protected static final String IMPERSONATOR = "Impersonator";
    public static final int BAD_PACKAGE_NAME = -200;
    public static final int UNEXPECTED_ERROR = -201;
    public static final int ACCESS_DENIED = -202;
    public static final int TOO_MANY_CERTIFICATES = -203;
    public static final int NO_INSTALLER_CERTIFICATE = -204;
    public static final int NO_CERTIFICATE = -205;
    public static final int NO_MATCHING_CERTIFICATE = -206;
    public static final int UNKNOWN_JAR_FILE = -207;
    public static final int INVALID_ARGUMENTS = -208;
    public static final int ILLEGAL_RELATIVE_PATH = -209;
    public static final int USER_CANCELLED = -210;
    public static final int INSTALL_NOT_STARTED = -211;
    public static final int SILENT_MODE_DENIED = -212;
    public static final int SUCCESS = 0;
    public static final int REBOOT_NEEDED = 999;
    protected String packageName;
    protected Vector installedFiles;
    protected VersionInfo versionInfo;
    protected String userPackageName;
    private ProgressMediator progress;
    private int userChoice;
    private boolean silent;
    private int lastError;
    private String installerJarName;
    private String jarName;
    private int zigPtr;
    private Principal installPrincipal;

    public SoftwareUpdate(JSObject jSObject, String string) {
        this.userPackageName = string;
        this.installPrincipal = null;
        this.packageName = null;
        this.progress = null;
        this.zigPtr = 0;
        this.userChoice = -1;
        this.lastError = 0;
        this.VerifyJSObject(jSObject);
        this.jarName = (String)jSObject.getMember("src");
        this.silent = false;
        try {
            jSObject.getMember("silent");
            this.silent = (Boolean)jSObject.getMember("silent");
            return;
        }
        catch (Throwable throwable) {
            System.out.println("Unexpected throw on silent");
            this.silent = false;
            return;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.CleanUp();
    }

    private native void VerifyJSObject(JSObject var1);

    private void InitializeInstallerCertificate() throws SoftUpdateException {
        Object[] objectArray = null;
        objectArray = this.getCertificates(this.zigPtr, this.installerJarName);
        if (objectArray == null || objectArray.length == 0) {
            throw new SoftUpdateException(Strings.error_NoCertificate(), -204);
        }
        if (objectArray.length > 1) {
            throw new SoftUpdateException(Strings.error_TooManyCertificates(), -203);
        }
        this.installPrincipal = new Principal(14, (byte[])objectArray[0]);
    }

    private void CheckSilentPrivileges() {
        if (!this.silent) {
            return;
        }
        try {
            PrivilegeManager privilegeManager = AppletSecurity.getPrivilegeManager();
            Target target = Target.findTarget(IMPERSONATOR);
            privilegeManager.enablePrivilege(target);
            Target target2 = Target.findTarget(targetNames[2]);
            privilegeManager.enablePrivilege(target2, this.GetPrincipal());
            return;
        }
        catch (Throwable throwable) {
            System.out.println(Strings.error_SilentModeDenied());
            this.silent = false;
            return;
        }
    }

    private void RequestSecurityPrivileges(int n) {
        if (n != 0 && n != 1) {
            n = 1;
        }
        PrivilegeManager privilegeManager = AppletSecurity.getPrivilegeManager();
        Target target = Target.findTarget(IMPERSONATOR);
        privilegeManager.enablePrivilege(target);
        Target target2 = Target.findTarget(targetNames[n]);
        privilegeManager.enablePrivilege(target2, this.GetPrincipal());
    }

    protected final Principal GetPrincipal() {
        return this.installPrincipal;
    }

    protected final String GetUserPackageName() {
        return this.userPackageName;
    }

    protected final boolean GetSilent() {
        return this.silent;
    }

    protected final Enumeration GetInstallQueue() {
        if (this.installedFiles != null) {
            return this.installedFiles.elements();
        }
        return null;
    }

    public int GetLastError() {
        return this.lastError;
    }

    public void ResetError() {
        this.lastError = 0;
    }

    private int saveError(int n) {
        if (n != 0) {
            this.lastError = n;
        }
        return n;
    }

    public Object GetFolder(String string) {
        FolderSpec folderSpec = null;
        try {
            if (string.compareTo("Installed") != 0) {
                folderSpec = new FolderSpec(string, this.packageName, this.userPackageName);
                if (string == "User Pick") {
                    folderSpec.GetDirectoryPath();
                }
            }
        }
        catch (Throwable throwable) {
            return null;
        }
        return folderSpec;
    }

    public Object GetComponentFolder(String string) {
        int n;
        FolderSpec folderSpec = null;
        String string2 = VersionRegistry.getDefaultDirectory(string);
        if (string2 == null && (string2 = VersionRegistry.componentPath(string)) != null && (n = string2.lastIndexOf(System.getProperty("file.separator"))) > 0) {
            char[] cArray = new char[n];
            string2.getChars(0, n, cArray, 0);
            string2 = new String(cArray);
        }
        if (string2 != null) {
            folderSpec = new FolderSpec("Installed", string2, this.userPackageName);
        }
        return folderSpec;
    }

    public Object GetWinProfile(Object object, String string) {
        WinProfile winProfile = null;
        String string2 = System.getProperty("os.name");
        try {
            if (this.packageName == null) {
                throw new SoftUpdateException(Strings.error_WinProfileMustCallStart(), -211);
            }
            if (string2.indexOf("Windows") >= 0 || string2.equals("Win32s")) {
                winProfile = new WinProfile(this, (FolderSpec)object, string);
            }
        }
        catch (SoftUpdateException softUpdateException) {
            winProfile = null;
        }
        return winProfile;
    }

    public Object GetWinRegistry() {
        WinReg winReg = null;
        String string = System.getProperty("os.name");
        try {
            if (this.packageName == null) {
                throw new SoftUpdateException(Strings.error_WinProfileMustCallStart(), -211);
            }
            if (string.indexOf("Windows") >= 0 || string.equals("Win32s")) {
                winReg = new WinReg(this);
            }
        }
        catch (Throwable throwable) {
            winReg = null;
        }
        return winReg;
    }

    private native void OpenJARFile() throws SoftUpdateException;

    private native void CloseJARFile();

    private native Object[] getCertificates(int var1, String var2);

    protected String ExtractJARFile(String string, String string2) throws SoftUpdateException {
        Object object;
        if (this.zigPtr == 0) {
            throw new SoftUpdateException("JAR file\thas\tnot\tbeen opened", -207);
        }
        PrivilegeManager privilegeManager = AppletSecurity.getPrivilegeManager();
        Target target = Target.findTarget(targetNames[0]);
        privilegeManager.checkPrivilegeEnabled(target);
        boolean bl = false;
        Object[] objectArray = null;
        objectArray = this.getCertificates(this.zigPtr, string);
        if (objectArray == null || objectArray.length == 0) {
            throw new SoftUpdateException("Missing certificate for " + string, -205);
        }
        int n = 0;
        while (n < objectArray.length) {
            object = new Principal(14, (byte[])objectArray[n]);
            if (this.installPrincipal.equals(object)) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            throw new SoftUpdateException(String.valueOf(Strings.error_MismatchedCertificate()) + string, -206);
        }
        object = this.NativeExtractJARFile(string, string2);
        return object;
    }

    private native String NativeExtractJARFile(String var1, String var2) throws SoftUpdateException;

    public int StartInstall(String string, VersionInfo versionInfo, int n) {
        int n2 = 0;
        this.ResetError();
        try {
            if (string == null) {
                throw new SoftUpdateException(Strings.error_BadPackageName(), -208);
            }
            this.packageName = string;
            while (this.packageName.endsWith("/")) {
                char[] cArray = new char[this.packageName.length() - 1];
                this.packageName.getChars(0, this.packageName.length() - 1, cArray, 0);
                this.packageName = new String(cArray);
            }
            this.versionInfo = versionInfo;
            this.installedFiles = new Vector();
            this.OpenJARFile();
            this.InitializeInstallerCertificate();
            this.CheckSilentPrivileges();
            this.RequestSecurityPrivileges(n);
            this.progress = new ProgressMediator(this);
            this.progress.StartInstall();
        }
        catch (SoftUpdateException softUpdateException) {
            n2 = softUpdateException.GetError();
        }
        catch (ForbiddenTargetException forbiddenTargetException) {
            n2 = -202;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            n2 = -201;
        }
        this.saveError(n2);
        return n2;
    }

    protected void UserCancelled() {
        this.userChoice = 0;
        this.AbortInstall();
    }

    protected void UserApproved() {
        this.userChoice = 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int FinalizeInstall() {
        int n;
        boolean bl;
        block27: {
            bl = false;
            n = 0;
            try {
                int n2;
                block23: {
                    block24: {
                        try {
                            block25: {
                                Throwable throwable2;
                                InstallObject installObject;
                                Enumeration enumeration;
                                block26: {
                                    if (this.packageName == null) {
                                        throw new SoftUpdateException(Strings.error_WinProfileMustCallStart(), -211);
                                    }
                                    this.progress.ConfirmWithUser();
                                    while (true) {
                                        if (this.userChoice != -1) {
                                            if (this.userChoice == 1) break;
                                            this.AbortInstall();
                                            this.lastError = -210;
                                            n2 = -210;
                                            Object var5_4 = null;
                                            if (this.installedFiles == null) break block23;
                                            break block24;
                                        }
                                        Thread.sleep(10L);
                                    }
                                    enumeration = this.GetInstallQueue();
                                    installObject = null;
                                    try {
                                        while (enumeration.hasMoreElements()) {
                                            installObject = (InstallObject)enumeration.nextElement();
                                            try {
                                                installObject.Complete();
                                            }
                                            catch (SoftUpdateException softUpdateException) {
                                                if ((short)softUpdateException.GetError() != 999) {
                                                    throw softUpdateException;
                                                }
                                                bl = true;
                                            }
                                        }
                                        break block25;
                                    }
                                    catch (Throwable throwable2) {
                                        if (installObject == null) break block26;
                                        installObject.Abort();
                                    }
                                }
                                while (true) {
                                    if (!enumeration.hasMoreElements()) {
                                        throw throwable2;
                                    }
                                    try {
                                        installObject = (InstallObject)enumeration.nextElement();
                                        installObject.Abort();
                                    }
                                    catch (Throwable throwable3) {}
                                }
                            }
                            if (this.versionInfo != null) {
                                n = VersionRegistry.installComponent(this.packageName, null, this.versionInfo);
                            }
                            break block27;
                        }
                        catch (SoftUpdateException softUpdateException) {
                            n = softUpdateException.GetError();
                        }
                        catch (ForbiddenTargetException forbiddenTargetException) {
                            n = -202;
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                            System.out.println(String.valueOf(Strings.error_Unexpected()) + " FinalizeInstall");
                            n = -201;
                        }
                        break block27;
                    }
                    this.installedFiles.removeAllElements();
                }
                this.CleanUp();
                return n2;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (this.installedFiles != null) {
                    this.installedFiles.removeAllElements();
                }
                this.CleanUp();
                throw throwable;
            }
        }
        Object var5_5 = null;
        if (this.installedFiles != null) {
            this.installedFiles.removeAllElements();
        }
        this.CleanUp();
        if (n == 0 && bl) {
            n = 999;
        }
        this.saveError(n);
        return n;
    }

    public synchronized void AbortInstall() {
        Object object2;
        try {
            try {
                if (this.installedFiles != null) {
                    object2 = this.GetInstallQueue();
                    while (object2.hasMoreElements()) {
                        InstallObject installObject = (InstallObject)object2.nextElement();
                        try {
                            installObject.Abort();
                        }
                        catch (Throwable throwable) {}
                    }
                    this.installedFiles.removeAllElements();
                    this.installedFiles = null;
                }
                this.CloseJARFile();
            }
            catch (Throwable throwable) {
                System.out.println(String.valueOf(Strings.error_Unexpected()) + " AbortInstall");
                throwable.printStackTrace();
            }
            Object var2_5 = null;
        }
        catch (Throwable throwable) {
            Object var2_6 = null;
            try {
                this.CleanUp();
            }
            catch (Throwable throwable2) {
                throwable2.printStackTrace();
            }
            throw throwable;
        }
        try {
            this.CleanUp();
        }
        catch (Throwable object2) {
            ((Throwable)object2).printStackTrace();
        }
    }

    private synchronized void CleanUp() {
        if (this.progress != null) {
            this.progress.Complete();
        }
        this.CloseJARFile();
        this.progress = null;
        this.zigPtr = 0;
        if (this.installedFiles != null) {
            Enumeration enumeration = this.GetInstallQueue();
            while (enumeration.hasMoreElements()) {
                InstallObject installObject = (InstallObject)enumeration.nextElement();
                installObject.Abort();
            }
            this.installedFiles.removeAllElements();
        }
        this.installedFiles = null;
        this.packageName = null;
    }

    protected void ScheduleForInstall(InstallObject installObject) {
        if (this.progress != null) {
            this.progress.ScheduleForInstall(installObject);
        }
        this.installedFiles.addElement(installObject);
    }

    private String GetQualifiedRegName(String string) {
        String string2;
        String string3 = string2 = this.packageName.length() == 0 ? "" : String.valueOf(this.packageName) + "/";
        if (string.toUpperCase().startsWith("=COMM=/")) {
            string = (String.valueOf(string.substring(7)) + "===").substring(0, string.length() - 7);
        } else if (string.charAt(0) != '/') {
            string = String.valueOf(string2) + string;
        }
        return string;
    }

    public int AddSubcomponent(String string, VersionInfo versionInfo, String string2, Object object, String string3, boolean bl) {
        int n = 0;
        try {
            if (string2 == null || string2.length() == 0 || object == null) {
                throw new SoftUpdateException("", -208);
            }
            if (this.packageName == null) {
                throw new SoftUpdateException(Strings.error_BadPackageNameAS(), -200);
            }
            this.packageName.length();
            string = string == null || string.length() == 0 ? this.GetQualifiedRegName(string2) : this.GetQualifiedRegName(string);
            if (string3 == null || string3.length() == 0) {
                string3 = string2;
            }
            boolean bl2 = false;
            if (!bl && versionInfo != null && VersionRegistry.validateComponent(string) == 0) {
                VersionInfo versionInfo2 = VersionRegistry.componentVersion(string);
                if (versionInfo.compareTo(versionInfo2) > 0) {
                    bl2 = true;
                }
            } else {
                bl2 = true;
            }
            if (bl2) {
                InstallFile installFile = new InstallFile(this, string, versionInfo, string2, (FolderSpec)object, string3, bl);
                installFile.ExtractFile();
                this.ScheduleForInstall(installFile);
            }
        }
        catch (SoftUpdateException softUpdateException) {
            n = softUpdateException.GetError();
        }
        catch (ForbiddenTargetException forbiddenTargetException) {
            n = -202;
        }
        catch (Throwable throwable) {
            System.out.println(String.valueOf(Strings.error_Unexpected()) + "AddSubcomponent");
            n = -201;
        }
        this.saveError(n);
        return n;
    }

    public int Execute(String string) {
        int n = 0;
        try {
            InstallExecute installExecute = new InstallExecute(this, string);
            installExecute.ExtractFile();
            this.ScheduleForInstall(installExecute);
        }
        catch (SoftUpdateException softUpdateException) {
            n = softUpdateException.GetError();
        }
        catch (ForbiddenTargetException forbiddenTargetException) {
            n = -202;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.out.println(String.valueOf(Strings.error_Unexpected()) + "Execute");
            n = -201;
        }
        this.saveError(n);
        return n;
    }

    public int[] Gestalt(String string) {
        int[] nArray = new int[]{0, 0};
        try {
            nArray[1] = this.NativeGestalt(string);
        }
        catch (SoftUpdateException softUpdateException) {
            nArray[0] = softUpdateException.GetError();
        }
        catch (Throwable throwable) {
            nArray[0] = -1;
            System.out.println(String.valueOf(Strings.error_Unexpected()) + "Gestalt");
        }
        return nArray;
    }

    private native int NativeGestalt(String var1) throws SoftUpdateException;

    private native String[] ExtractDirEntries(String var1);

    public int AddDirectory(String string, VersionInfo versionInfo, String string2, FolderSpec folderSpec, String string3, boolean bl) {
        int n = 0;
        try {
            if (string2 == null || string2.length() == 0 || folderSpec == null) {
                throw new SoftUpdateException("", -208);
            }
            if (this.packageName == null) {
                throw new SoftUpdateException(Strings.error_BadPackageNameAS(), -200);
            }
            string = string == null || string.length() == 0 ? this.GetQualifiedRegName(string2) : this.GetQualifiedRegName(string);
            if (string3 == null) {
                string3 = "";
            } else if (string3.length() != 0) {
                string3 = String.valueOf(string3) + "/";
            }
            System.out.println("AddDirectory " + string + " from " + string2 + " into " + folderSpec.MakeFullPath(string3));
            String[] stringArray = this.ExtractDirEntries(string2);
            int n2 = 0;
            while (n2 < stringArray.length) {
                VersionInfo versionInfo2;
                String string4 = String.valueOf(string) + "/" + stringArray[n2];
                boolean bl2 = !bl && versionInfo != null && VersionRegistry.validateComponent(string4) == 0 ? versionInfo.compareTo(versionInfo2 = VersionRegistry.componentVersion(string4)) > 0 : true;
                if (bl2) {
                    InstallFile installFile = new InstallFile(this, string4, versionInfo, String.valueOf(string2) + "/" + stringArray[n2], folderSpec, String.valueOf(string3) + stringArray[n2], bl);
                    installFile.ExtractFile();
                    this.ScheduleForInstall(installFile);
                }
                ++n2;
            }
        }
        catch (SoftUpdateException softUpdateException) {
            n = softUpdateException.GetError();
        }
        catch (ForbiddenTargetException forbiddenTargetException) {
            n = -202;
        }
        catch (Throwable throwable) {
            System.out.println(String.valueOf(Strings.error_Unexpected()) + "AddDirectory");
            n = -201;
        }
        this.saveError(n);
        return n;
    }

    static {
        Principal principal = PrivilegeManager.getSystemPrincipal();
        UserTarget userTarget = new UserTarget(targetNames[0], principal, UserDialogHelper.targetRiskMedium(), UserDialogHelper.targetRiskColorMedium(), Strings.targetDesc_LimitedInstall(), Strings.getString("s37"), Strings.targetUrl_LimitedInstall());
        userTarget = (UserTarget)userTarget.registerTarget();
        Target[] targetArray = new Target[]{userTarget};
        UserTarget userTarget2 = new UserTarget(targetNames[1], principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), Strings.targetDesc_FullInstall(), Strings.getString("s38"), Strings.targetUrl_FullInstall(), targetArray);
        userTarget2 = (UserTarget)userTarget2.registerTarget();
        targetArray[0] = userTarget2;
        UserTarget userTarget3 = new UserTarget(targetNames[2], principal, UserDialogHelper.targetRiskHigh(), UserDialogHelper.targetRiskColorHigh(), Strings.targetDesc_SilentInstall(), Strings.getString("s39"), Strings.targetUrl_SilentInstall(), targetArray);
        userTarget3 = (UserTarget)userTarget3.registerTarget();
    }
}

