/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.avalon.excalibur.pool;

import org.apache.avalon.framework.component.Component;

/**
 * This is the interface for factory that is used to create objects for Pool.
 *
 * @author <a href="mailto:bloritsch@apache.org">Berin Loritsch</a>
 * @author <a href="mailto:stefano@apache.org">Stefano Mazzocchi</a>
 * @author <a href="mailto:peter@apache.org">Peter Donald</a>
 * @version CVS $Revision: 1.4 $ $Date: 2001/12/11 09:53:32 $
 * @since 4.0
 */
public interface ObjectFactory
    extends Component
{
    Object newInstance() throws Exception;
    Class getCreatedClass();
    void decommission(Object object) throws Exception;
}
