/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.avalon.excalibur.pool;

/**
 * Poolable marker interface.
 *
 * Components implement this interface if it is reasonable to
 * Pool the object. Components that don't implement this interface
 * will be created anew via a factory.
 *
 * NB: It was a deliberat e choice not to extend Component. This will have to
 * be reassed once we see it in action.
 *
 * @author <a href="mailto:peter@apache.org">Peter Donald</a>
 * @version CVS $Revision: 1.4 $ $Date: 2001/12/11 09:53:32 $
 * @since 4.0
 */
public interface Poolable
{
}
