/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.avalon.excalibur.i18n;

/**
 * @author <a href="mailto:neeme@apache.org">Neeme Praks</a>
 * @version $Id: FlatXmlBundle.java,v 1.2 2001/12/11 09:53:35 jefft Exp $
 */
public class FlatXmlBundle extends XmlBundle {

    public static final String PREFIX = "/catalogue/message[@key='";
    public static final String SUFFIX = "']";

    /**
     * Convert the &quot;user view&quot; of the lookup key to the
     * &quot;system view&quot;. Used to hide the implemented storage
     * mechanism and/or XML file schema.
     *
     * @param key           user key
     * @return              system key
     */
    public String convertKey(String userKey) {
        return new StringBuffer(PREFIX).append(userKey).append(SUFFIX).toString();
    }

}
