/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.avalon.excalibur.i18n.test;

import java.util.Map;
import java.util.HashMap;
import java.util.Locale;

import org.apache.avalon.excalibur.testcase.ExcaliburTestCase;
import org.apache.avalon.excalibur.i18n.BundleInfo;
import org.apache.avalon.excalibur.i18n.XmlBundle;
import org.apache.avalon.excalibur.i18n.BundleInfoMapper;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.xml.sax.InputSource;

/**
 * @author <a href="mailto:neeme@apache.org">Neeme Praks</a>
 * @version $Id: XmlBundleTestCase.java,v 1.8 2002/01/02 19:48:51 neeme Exp $
 */
public class XmlBundleTestCase extends ExcaliburTestCase {

    private Map variables = new HashMap(5);
    private XmlBundle bundle = new XmlBundle();
    private XmlBundle bundleWithRoot = new XmlBundle();

    public XmlBundleTestCase( String name ) {
        super(name);
    }

    public void setUp() throws Exception {
        this.variables.put("value", "a cat");

        final String bundleFileName = this.getClass().getPackage().getName().replace( '.', '/' ) + "/XmlBundle.xml";
        getLogger().debug("Test-bundle file = " + bundleFileName);

        this.bundle.setBundleInfo(new BundleInfo("test", null));
        this.bundle.setMapper((BundleInfoMapper) this.manager.lookup(BundleInfoMapper.ROLE));
        this.bundle.enableLogging(getLogEnabledLogger());
        this.bundle.compose(this.manager);
        DefaultConfiguration conf = new DefaultConfiguration("bundle-conf", "conf");
        conf.setAttribute(XmlBundle.ConfigurationKeys.LOAD_ON_INIT, "true");
        conf.setAttribute(XmlBundle.ConfigurationKeys.USE_ROOT, "false");
        this.bundle.configure(conf);
        this.bundle.initialize(new InputSource(this.getClass().getClassLoader().getResource(bundleFileName).openStream()));

        this.bundleWithRoot.setBundleInfo(new BundleInfo("test-with-root", null));
        this.bundleWithRoot.setMapper((BundleInfoMapper) this.manager.lookup(BundleInfoMapper.ROLE));
        this.bundleWithRoot.enableLogging(getLogEnabledLogger());
        this.bundleWithRoot.compose(super.manager);
        conf = new DefaultConfiguration("bundle-conf", "conf");
        conf.setAttribute(XmlBundle.ConfigurationKeys.LOAD_ON_INIT, "true");
        conf.setAttribute(XmlBundle.ConfigurationKeys.USE_ROOT, "true");
        this.bundleWithRoot.configure(conf);
        this.bundleWithRoot.initialize(new InputSource(this.getClass().getClassLoader().getResource(bundleFileName).openStream()));
    }

    public void testGetString() {
        assertEquals("Text on level3", this.bundle.getString("level1.level2.level3"));
        assertEquals("Flat level 2", this.bundle.getString("levels/level[@number='2']"));

        assertEquals("Text on level3", this.bundleWithRoot.getString("resources.level1.level2.level3"));
        assertEquals("Flat level 2", this.bundleWithRoot.getString("resources.levels/level[@number='2']"));
    }

    public void testGetStringWithVariable() {
        assertEquals("Here is an example of a cat.", this.bundle.getString("key-with-variable", this.variables));
        assertEquals("Here is an example of a cat.", this.bundleWithRoot.getString("resources.key-with-variable", this.variables));
    }

}
