/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.avalon.excalibur.lang;

import java.util.HashMap;
import java.util.Map;
import java.util.Iterator;

/**
 * The <code>ThreadContextPolicy</code> determines the policy with 
 * which items can be added to context. It determines what to do with 
 * values when <code>ThreadContext</code> is activated and deactivated. 
 * It also determines if a variable can be set.
 *
 * <p>This interface is expected to be used as a Flyweight object.</p>
 *
 * @author <a href="mailto:peter@apache.org">Peter Donald</a>
 */
public interface ThreadContextPolicy
{
    /**
     * Key used to store <code>ContextClassLoader</code> in ThreadContextAccessor.
     */
    String  CLASSLOADER     = "ContextClassLoader";
    
    /**
     * The activate method is called when the ThreadContext 
     * is associated with a thread.
     *
     * @param accessor the accessor to retrieve values from ThreadContext
     */
    void activate( ThreadContextAccessor accessor );

    /**
     * The deactivate method is called when the ThreadContext is 
     * dis-associated with a thread.
     *
     * @param accessor the accessor to retrieve values from ThreadContext
     */
    void deactivate( ThreadContextAccessor accessor );

    /**
     * Verify that the key/value pair is valid.
     *
     * @param key The key
     * @param value the value
     * @exception IllegalArgumentException if pair is not valid
     */
    void verifyKeyValue( String key, Object value )
        throws IllegalArgumentException;
}
