/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.avalon.excalibur.util;

import java.util.List;
import org.apache.avalon.framework.CascadingException;

/**
 *
 * @author <a href="mailto:peter@apache.org">Peter Donald</a>
 */
public final class CircularDependencyException
    extends CascadingException
{
    protected final List   m_stack;

    public CircularDependencyException( final String dependee,
                                        final String dependent,
                                        final List stack )
    {
        super( new StringBuffer(dependee).append(" depends upon ")
               .append(dependent).append(" which depends upong ")
               .append(dependee).toString() );
        m_stack = stack;
    }

    public final List getStack()
    {
        return m_stack;
    }
}
