/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.avalon.excalibur.naming.rmi.test;

import java.util.Hashtable;
import javax.naming.Context;
import java.lang.reflect.Method;
import org.apache.avalon.excalibur.naming.test.AbstractContextTestCase;
import org.apache.avalon.excalibur.naming.rmi.server.Main;
import org.apache.avalon.excalibur.naming.rmi.RMIInitialContextFactory;

/**
 * Unit testing for JNDI system
 *
 * @author <a href="mailto:peter@apache.org">Peter Donald</a>
 * @version $Revision: 1.5 $
 */
public class RMIContextTestCase
    extends AbstractContextTestCase
{
    private static int                m_numTests = 0;
    private static int                m_id = 0;
    private static Main               m_server = new Main();
    private static Thread             m_serverThread;
    private Context                   m_rootContext;
    private static boolean            m_setUp = false;

    static
    {
        Class testCase = AbstractContextTestCase.class;

        Method[] methods = testCase.getMethods();

        for (int i = 0; i < methods.length; i++)
        {
            if (methods[i].getName().startsWith("test"))
            {
                RMIContextTestCase.m_numTests++;
            }
        }
    }

    public RMIContextTestCase( String name )
    {
        super( name );
    }

    public void setUp()
    {
        try
        {
            if ( ! RMIContextTestCase.m_setUp )
            {
                RMIContextTestCase.m_server.start();

                RMIContextTestCase.m_serverThread = new Thread( m_server );
                RMIContextTestCase.m_serverThread.start();
                RMIContextTestCase.m_setUp = true;
            }

            final RMIInitialContextFactory factory = new RMIInitialContextFactory();
            m_rootContext = factory.getInitialContext( new Hashtable() );

            m_context = m_rootContext.createSubcontext( "test" + RMIContextTestCase.m_id++ );
        }
        catch( final Exception e )
        {
            System.out.println( "Failed test initialisation " + e );
            e.printStackTrace();
        }
    }

    public void tearDown()
    {
        try
        {
            m_context.close();
            m_context = null;
            m_rootContext.close();

            if ( RMIContextTestCase.m_id >= RMIContextTestCase.m_numTests )
            {
                RMIContextTestCase.m_server.stop();
                RMIContextTestCase.m_serverThread.interrupt();
           }
        }
        catch( final Exception e )
        {
            System.out.println( "Failed test destruction" + e );
            e.printStackTrace();
        }
    }
}
