/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager;

import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.peermanager.messages.ProtocolMessage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;

public class OutgoingMessageQueue {
    private final LinkedList queue = new LinkedList();
    private final AEMonitor queue_mon = new AEMonitor("OutgoingMessageQueue:queue");
    private final ArrayList delayed_notifications = new ArrayList();
    private final AEMonitor delayed_notifications_mon = new AEMonitor("OutgoingMessageQueue:DN");
    private volatile ArrayList listeners = new ArrayList();
    private final AEMonitor listeners_mon = new AEMonitor("OutgoingMessageQueue:L");
    private int total_size = 0;
    private ProtocolMessage urgent_message = null;
    private boolean destroyed = false;

    protected OutgoingMessageQueue() {
    }

    protected void destroy() {
        this.destroyed = true;
        try {
            this.queue_mon.enter();
            while (!this.queue.isEmpty()) {
                ((ProtocolMessage)this.queue.remove(0)).destroy();
            }
        }
        finally {
            this.queue_mon.exit();
        }
        this.total_size = 0;
    }

    public int getTotalSize() {
        return this.total_size;
    }

    public boolean hasUrgentMessage() {
        return this.urgent_message != null;
    }

    public void addMessage(ProtocolMessage message, boolean manual_listener_notify) {
        if (this.destroyed) {
            message.destroy();
            return;
        }
        this.removeMessagesOfType(message.typesToRemove(), manual_listener_notify);
        try {
            this.queue_mon.enter();
            int pos = 0;
            Iterator i = this.queue.iterator();
            while (i.hasNext()) {
                ProtocolMessage msg = (ProtocolMessage)i.next();
                if (message.getPriority() > msg.getPriority() && msg.getPayload().position((byte)5) == 0) break;
                ++pos;
            }
            if (message.isNoDelay()) {
                this.urgent_message = message;
            }
            this.queue.add(pos, message);
            this.total_size += message.getPayload().remaining((byte)5);
        }
        finally {
            this.queue_mon.exit();
        }
        if (manual_listener_notify) {
            NotificationItem item = new NotificationItem(0);
            item.message = message;
            try {
                this.delayed_notifications_mon.enter();
                this.delayed_notifications.add(item);
            }
            finally {
                this.delayed_notifications_mon.exit();
            }
        } else {
            ArrayList listeners_ref = this.listeners;
            int i = 0;
            while (i < listeners_ref.size()) {
                MessageQueueListener listener = (MessageQueueListener)listeners_ref.get(i);
                listener.messageAdded(message);
                ++i;
            }
        }
    }

    public void removeMessagesOfType(int[] message_types, boolean manual_listener_notify) {
        if (message_types == null) {
            return;
        }
        ArrayList<ProtocolMessage> messages_removed = null;
        try {
            this.queue_mon.enter();
            Iterator i = this.queue.iterator();
            block6: while (i.hasNext()) {
                ProtocolMessage msg = (ProtocolMessage)i.next();
                int t = 0;
                while (t < message_types.length) {
                    if (msg.getType() == message_types[t] && msg.getPayload().position((byte)5) == 0) {
                        if (msg == this.urgent_message) {
                            this.urgent_message = null;
                        }
                        this.total_size -= msg.getPayload().remaining((byte)5);
                        if (manual_listener_notify) {
                            NotificationItem item = new NotificationItem(1);
                            item.message = msg;
                            try {
                                this.delayed_notifications_mon.enter();
                                this.delayed_notifications.add(item);
                            }
                            finally {
                                this.delayed_notifications_mon.exit();
                            }
                        } else {
                            if (messages_removed == null) {
                                messages_removed = new ArrayList<ProtocolMessage>();
                            }
                            messages_removed.add(msg);
                        }
                        i.remove();
                        continue block6;
                    }
                    ++t;
                }
            }
        }
        finally {
            this.queue_mon.exit();
        }
        if (!manual_listener_notify && messages_removed != null) {
            ArrayList listeners_ref = this.listeners;
            int x = 0;
            while (x < messages_removed.size()) {
                ProtocolMessage msg = (ProtocolMessage)messages_removed.get(x);
                int i = 0;
                while (i < listeners_ref.size()) {
                    MessageQueueListener listener = (MessageQueueListener)listeners_ref.get(i);
                    listener.messageRemoved(msg);
                    ++i;
                }
                msg.destroy();
                ++x;
            }
        }
    }

    public boolean removeMessage(ProtocolMessage message, boolean manual_listener_notify) {
        ProtocolMessage msg_removed = null;
        try {
            ProtocolMessage msg;
            this.queue_mon.enter();
            int index = this.queue.indexOf(message);
            if (index != -1 && (msg = (ProtocolMessage)this.queue.get(index)).getPayload().position((byte)5) == 0) {
                if (msg == this.urgent_message) {
                    this.urgent_message = null;
                }
                this.total_size -= msg.getPayload().remaining((byte)5);
                this.queue.remove(index);
                msg_removed = msg;
            }
        }
        finally {
            this.queue_mon.exit();
        }
        if (msg_removed != null) {
            if (manual_listener_notify) {
                NotificationItem item = new NotificationItem(1);
                item.message = msg_removed;
                try {
                    this.delayed_notifications_mon.enter();
                    this.delayed_notifications.add(item);
                }
                finally {
                    this.delayed_notifications_mon.exit();
                }
            } else {
                ArrayList listeners_ref = this.listeners;
                int i = 0;
                while (i < listeners_ref.size()) {
                    MessageQueueListener listener = (MessageQueueListener)listeners_ref.get(i);
                    listener.messageRemoved(msg_removed);
                    ++i;
                }
                msg_removed.destroy();
            }
            return true;
        }
        return false;
    }

    protected int deliverToTransport(Transport transport, int max_bytes, boolean manual_listener_notify) throws IOException {
        ProtocolMessage msg;
        ArrayList<ProtocolMessage> messages_sent;
        int protocol_written;
        int data_written;
        block36: {
            if (max_bytes < 1) {
                Debug.out("max_bytes < 1: " + max_bytes);
                return 0;
            }
            data_written = 0;
            protocol_written = 0;
            messages_sent = null;
            try {
                this.queue_mon.enter();
                if (this.queue.isEmpty()) break block36;
                ByteBuffer[] buffers = new ByteBuffer[this.queue.size()];
                int[] starting_pos = new int[this.queue.size()];
                int pos = 0;
                int total_sofar = 0;
                while (total_sofar < max_bytes && pos < buffers.length) {
                    buffers[pos] = ((ProtocolMessage)this.queue.get(pos)).getPayload().getBuffer((byte)5);
                    total_sofar += buffers[pos].remaining();
                    starting_pos[pos] = buffers[pos].position();
                    ++pos;
                }
                int orig_limit = buffers[--pos].limit();
                if (total_sofar > max_bytes) {
                    buffers[pos].limit(orig_limit - (total_sofar - max_bytes));
                }
                transport.write(buffers, 0, pos + 1);
                buffers[pos].limit(orig_limit);
                pos = 0;
                while (!this.queue.isEmpty()) {
                    int bytes_written;
                    msg = (ProtocolMessage)this.queue.get(0);
                    ByteBuffer bb = msg.getPayload().getBuffer((byte)5);
                    if (bb.hasRemaining()) {
                        bytes_written = bb.limit() - bb.remaining() - starting_pos[pos];
                        this.total_size -= bytes_written;
                        if (msg.isDataMessage()) {
                            data_written += bytes_written;
                        } else {
                            protocol_written += bytes_written;
                        }
                        break;
                    }
                    if (msg == this.urgent_message) {
                        this.urgent_message = null;
                    }
                    bytes_written = bb.limit() - starting_pos[pos];
                    this.total_size -= bytes_written;
                    if (msg.isDataMessage()) {
                        data_written += bytes_written;
                    } else {
                        protocol_written += bytes_written;
                    }
                    this.queue.remove(0);
                    if (manual_listener_notify) {
                        NotificationItem item = new NotificationItem(2);
                        item.message = msg;
                        item.transport = transport;
                        try {
                            this.delayed_notifications_mon.enter();
                            this.delayed_notifications.add(item);
                        }
                        finally {
                            this.delayed_notifications_mon.exit();
                        }
                    } else {
                        if (messages_sent == null) {
                            messages_sent = new ArrayList<ProtocolMessage>();
                        }
                        messages_sent.add(msg);
                    }
                    ++pos;
                }
            }
            finally {
                this.queue_mon.exit();
            }
        }
        if (data_written + protocol_written > 0) {
            if (manual_listener_notify) {
                NotificationItem item;
                if (data_written > 0) {
                    item = new NotificationItem(3);
                    item.byte_count = data_written;
                    try {
                        this.delayed_notifications_mon.enter();
                        this.delayed_notifications.add(item);
                    }
                    finally {
                        this.delayed_notifications_mon.exit();
                    }
                }
                if (protocol_written > 0) {
                    item = new NotificationItem(4);
                    item.byte_count = protocol_written;
                    try {
                        this.delayed_notifications_mon.enter();
                        this.delayed_notifications.add(item);
                    }
                    finally {
                        this.delayed_notifications_mon.exit();
                    }
                }
            } else {
                ArrayList listeners_ref = this.listeners;
                int num_listeners = listeners_ref.size();
                int i = 0;
                while (i < num_listeners) {
                    MessageQueueListener listener = (MessageQueueListener)listeners_ref.get(i);
                    if (data_written > 0) {
                        listener.dataBytesSent(data_written);
                    }
                    if (protocol_written > 0) {
                        listener.protocolBytesSent(protocol_written);
                    }
                    if (messages_sent != null) {
                        int x = 0;
                        while (x < messages_sent.size()) {
                            msg = (ProtocolMessage)messages_sent.get(x);
                            listener.messageSent(msg);
                            if (i == num_listeners - 1) {
                                LGLogger.log(11, "Sent " + msg.getDescription() + " message to " + transport.getDescription());
                                msg.destroy();
                            }
                            ++x;
                        }
                    }
                    ++i;
                }
            }
        }
        return data_written + protocol_written;
    }

    public void doListenerNotifications() {
        ArrayList notifications_copy;
        try {
            this.delayed_notifications_mon.enter();
            if (this.delayed_notifications.size() == 0) {
                this.delayed_notifications_mon.exit();
                return;
            }
            notifications_copy = new ArrayList(this.delayed_notifications);
            this.delayed_notifications.clear();
        }
        finally {
            this.delayed_notifications_mon.exit();
        }
        ArrayList listeners_ref = this.listeners;
        int j = 0;
        while (j < notifications_copy.size()) {
            NotificationItem item = (NotificationItem)notifications_copy.get(j);
            switch (item.type) {
                case 0: {
                    MessageQueueListener listener;
                    int i = 0;
                    while (i < listeners_ref.size()) {
                        listener = (MessageQueueListener)listeners_ref.get(i);
                        listener.messageAdded(item.message);
                        ++i;
                    }
                    break;
                }
                case 1: {
                    MessageQueueListener listener;
                    int i = 0;
                    while (i < listeners_ref.size()) {
                        listener = (MessageQueueListener)listeners_ref.get(i);
                        listener.messageRemoved(item.message);
                        ++i;
                    }
                    item.message.destroy();
                    break;
                }
                case 2: {
                    MessageQueueListener listener;
                    int i = 0;
                    while (i < listeners_ref.size()) {
                        listener = (MessageQueueListener)listeners_ref.get(i);
                        listener.messageSent(item.message);
                        ++i;
                    }
                    LGLogger.log(11, "Sent " + item.message.getDescription() + " message to " + item.transport.getDescription());
                    item.message.destroy();
                    break;
                }
                case 4: {
                    MessageQueueListener listener;
                    int i = 0;
                    while (i < listeners_ref.size()) {
                        listener = (MessageQueueListener)listeners_ref.get(i);
                        listener.protocolBytesSent(item.byte_count);
                        ++i;
                    }
                    break;
                }
                case 3: {
                    MessageQueueListener listener;
                    int i = 0;
                    while (i < listeners_ref.size()) {
                        listener = (MessageQueueListener)listeners_ref.get(i);
                        listener.dataBytesSent(item.byte_count);
                        ++i;
                    }
                    break;
                }
                default: {
                    Debug.out("NotificationItem.type unknown :" + item.type);
                }
            }
            ++j;
        }
    }

    public void registerQueueListener(MessageQueueListener listener) {
        try {
            this.listeners_mon.enter();
            ArrayList<MessageQueueListener> new_list = new ArrayList<MessageQueueListener>(this.listeners.size() + 1);
            new_list.addAll(this.listeners);
            new_list.add(listener);
            this.listeners = new_list;
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    public void cancelQueueListener(MessageQueueListener listener) {
        try {
            this.listeners_mon.enter();
            ArrayList new_list = new ArrayList(this.listeners);
            new_list.remove(listener);
            this.listeners = new_list;
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    public interface MessageQueueListener {
        public void messageAdded(ProtocolMessage var1);

        public void messageRemoved(ProtocolMessage var1);

        public void messageSent(ProtocolMessage var1);

        public void protocolBytesSent(int var1);

        public void dataBytesSent(int var1);
    }

    private static class NotificationItem {
        private static final int MESSAGE_ADDED = 0;
        private static final int MESSAGE_REMOVED = 1;
        private static final int MESSAGE_SENT = 2;
        private static final int DATA_BYTES_SENT = 3;
        private static final int PROTOCOL_BYTES_SENT = 4;
        private final int type;
        private ProtocolMessage message;
        private Transport transport;
        private int byte_count = 0;

        NotificationItem(int notification_type) {
            this.type = notification_type;
        }
    }
}

