/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.startstoprules.defaultplugin;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResult;
import org.gudy.azureus2.plugins.download.DownloadListener;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;
import org.gudy.azureus2.plugins.download.DownloadStats;
import org.gudy.azureus2.plugins.download.DownloadTrackerListener;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.plugins.ui.tables.TableManager;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.ui.swt.TextViewerWindow;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionQueue;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionSeeding;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionSeedingAutoStarting;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionSeedingFirstPriority;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionSeedingIgnore;
import org.gudy.azureus2.ui.swt.views.table.TableColumnCore;

public class StartStopRulesDefaultPlugin
implements Plugin,
COConfigurationListener {
    private static final String sStates = " WPRDS.XEQ";
    public static final int RANK_NONE = 0;
    public static final int RANK_SPRATIO = 1;
    public static final int RANK_SEEDCOUNT = 2;
    public static final int RANK_TIMED = 3;
    public static final int FIRSTPRIORITY_ALL = 0;
    public static final int FIRSTPRIORITY_ANY = 1;
    private static final int SR_INCOMPLETE_ENDS_AT = 1000000000;
    private static final int SR_TIMED_QUEUED_ENDS_AT = 10000000;
    private static final int SR_FIRST_PRIORITY_STARTS_AT = 50000000;
    private static final int SR_NOTQUEUED = -2;
    private static final int SR_RATIOMET = -3;
    private static final int SR_NUMSEEDSMET = -4;
    private static final int SR_0PEERS = -5;
    private static final int SR_SHARERATIOMET = -6;
    private static final int FORCE_ACTIVE_FOR = 30000;
    private static final int FORCE_CHECK_PERIOD = 30000;
    private static final int CHECK_FOR_GROSS_CHANGE_PERIOD = 30000;
    private static final int PROCESS_CHECK_PERIOD = 500;
    private PluginInterface plugin_interface;
    private PluginConfig plugin_config;
    private DownloadManager download_manager;
    private Timer changeCheckerTimer;
    private TimerTask recalcSeedingRanksTask;
    private Map downloadDataMap = AEMonitor.getSynchronisedMap(new HashMap());
    private volatile boolean closingDown;
    private volatile boolean somethingChanged;
    private LoggerChannel log;
    private long startedOn;
    int minPeersToBoostNoSeeds;
    int minSpeedForActiveDL;
    int minSpeedForActiveSeeding;
    int numPeersAsFullCopy;
    int iFakeFullCopySeedStart;
    int maxActive;
    int maxDownloads;
    int iIgnoreSeedCount;
    boolean bIgnore0Peers;
    int iIgnoreShareRatio;
    int iIgnoreShareRatio_SeedStart;
    int iIgnoreRatioPeers;
    int iIgnoreRatioPeers_SeedStart;
    int iRankType = -1;
    int iRankTypeSeedFallback;
    boolean bAutoReposition;
    long minTimeAlive;
    boolean bPreferLargerSwarms;
    boolean bDebugLog;
    TableContextMenuItem debugMenuItem = null;
    int minQueueingShareRatio;
    int iFirstPriorityType;
    int iFirstPrioritySeedingMinutes;
    int iFirstPriorityDLMinutes;
    boolean bAutoStart0Peers;
    int iMaxUploadSpeed;
    TableColumn seedingRankColumn;
    private AEMonitor this_mon = new AEMonitor("StartStopRules");

    public void initialize(PluginInterface _plugin_interface) {
        this.startedOn = SystemTime.getCurrentTime();
        this.changeCheckerTimer = new Timer(true);
        this.plugin_interface = _plugin_interface;
        this.plugin_interface.getPluginProperties().setProperty("plugin.name", "Start/Stop Rules");
        this.plugin_interface.addListener(new PluginListener(){

            public void initializationComplete() {
            }

            public void closedownInitiated() {
                StartStopRulesDefaultPlugin.this.closingDown = true;
                COConfigurationManager.removeListener(StartStopRulesDefaultPlugin.this);
            }

            public void closedownComplete() {
            }
        });
        this.log = this.plugin_interface.getLogger().getChannel("StartStopRules");
        this.log.log(1, "Default StartStopRules Plugin Initialisation");
        COConfigurationManager.addListener(this);
        this.plugin_config = this.plugin_interface.getPluginconfig();
        try {
            TableManager tm = this.plugin_interface.getUIManager().getTableManager();
            this.seedingRankColumn = tm.createColumn("MySeeders", "SeedingRank");
            this.seedingRankColumn.initialize(2, -2, 80, -2);
            SeedingRankColumnListener columnListener = new SeedingRankColumnListener();
            this.seedingRankColumn.addCellRefreshListener(columnListener);
            this.seedingRankColumn.addCellAddedListener(columnListener);
            tm.addColumn(this.seedingRankColumn);
            this.plugin_interface.addConfigSection(new ConfigSectionQueue());
            this.plugin_interface.addConfigSection(new ConfigSectionSeeding());
            this.plugin_interface.addConfigSection(new ConfigSectionSeedingAutoStarting());
            this.plugin_interface.addConfigSection(new ConfigSectionSeedingFirstPriority());
            this.plugin_interface.addConfigSection(new ConfigSectionSeedingIgnore());
        }
        catch (NoClassDefFoundError e) {
            this.log.log(2, "SWT UI Config not loaded for StartStopRulesDefaulPlugin. " + e.getMessage() + " not found.");
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        this.reloadConfigParams();
        this.download_manager = this.plugin_interface.getDownloadManager();
        this.download_manager.addListener(new StartStopDMListener());
        this.changeCheckerTimer.schedule((TimerTask)new ChangeCheckerTimerTask(), 10000L, 30000L);
        this.changeCheckerTimer.schedule((TimerTask)new ChangeFlagCheckerTask(), 10000L, 500L);
    }

    private void recalcAllSeedingRanks(boolean force) {
        if (this.closingDown) {
            return;
        }
        try {
            this.this_mon.enter();
            downloadData[] dlDataArray = this.downloadDataMap.values().toArray(new downloadData[0]);
            int i = 0;
            while (i < dlDataArray.length) {
                if (force) {
                    dlDataArray[i].setSeedingRank(0);
                }
                dlDataArray[i].recalcSeedingRank();
                ++i;
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void configurationSaved() {
        this.reloadConfigParams();
    }

    private void reloadConfigParams() {
        block13: {
            try {
                this.this_mon.enter();
                int iNewRankType = this.plugin_config.getIntParameter("StartStopManager_iRankType");
                this.minPeersToBoostNoSeeds = this.plugin_config.getIntParameter("StartStopManager_iMinPeersToBoostNoSeeds");
                this.minSpeedForActiveDL = this.plugin_config.getIntParameter("StartStopManager_iMinSpeedForActiveDL");
                this.minSpeedForActiveSeeding = this.plugin_config.getIntParameter("StartStopManager_iMinSpeedForActiveSeeding");
                this.maxActive = this.plugin_config.getIntParameter("max active torrents");
                this.maxDownloads = this.plugin_config.getIntParameter("max downloads");
                this.numPeersAsFullCopy = this.plugin_config.getIntParameter("StartStopManager_iNumPeersAsFullCopy");
                this.iFakeFullCopySeedStart = this.plugin_config.getIntParameter("StartStopManager_iFakeFullCopySeedStart");
                this.iRankTypeSeedFallback = this.plugin_config.getIntParameter("StartStopManager_iRankTypeSeedFallback");
                this.bAutoReposition = this.plugin_config.getBooleanParameter("StartStopManager_bAutoReposition");
                this.minTimeAlive = this.plugin_config.getIntParameter("StartStopManager_iMinSeedingTime") * 1000;
                this.bPreferLargerSwarms = this.plugin_config.getBooleanParameter("StartStopManager_bPreferLargerSwarms");
                this.bDebugLog = this.plugin_config.getBooleanParameter("StartStopManager_bDebugLog");
                this.iIgnoreSeedCount = this.plugin_config.getIntParameter("StartStopManager_iIgnoreSeedCount");
                this.bIgnore0Peers = this.plugin_config.getBooleanParameter("StartStopManager_bIgnore0Peers");
                this.iIgnoreShareRatio = (int)(1000.0f * this.plugin_config.getFloatParameter("Stop Ratio"));
                this.iIgnoreShareRatio_SeedStart = this.plugin_config.getIntParameter("StartStopManager_iIgnoreShareRatioSeedStart");
                this.iIgnoreRatioPeers = this.plugin_config.getIntParameter("Stop Peers Ratio", 0);
                this.iIgnoreRatioPeers_SeedStart = this.plugin_config.getIntParameter("StartStopManager_iIgnoreRatioPeersSeedStart", 0);
                this.minQueueingShareRatio = this.plugin_config.getIntParameter("StartStopManager_iFirstPriority_ShareRatio");
                this.iFirstPriorityType = this.plugin_config.getIntParameter("StartStopManager_iFirstPriority_Type");
                this.iFirstPrioritySeedingMinutes = this.plugin_config.getIntParameter("StartStopManager_iFirstPriority_SeedingMinutes");
                this.iFirstPriorityDLMinutes = this.plugin_config.getIntParameter("StartStopManager_iFirstPriority_DLMinutes");
                this.bAutoStart0Peers = this.plugin_config.getBooleanParameter("StartStopManager_bAutoStart0Peers");
                this.iMaxUploadSpeed = this.plugin_config.getIntParameter("Max Upload Speed KBs", 0);
                if (iNewRankType != this.iRankType) {
                    this.iRankType = iNewRankType;
                    if (this.iRankType == 3) {
                        if (this.recalcSeedingRanksTask == null) {
                            this.recalcSeedingRanksTask = new RecalcSeedingRanksTask();
                            this.changeCheckerTimer.schedule(this.recalcSeedingRanksTask, 1000L, 1000L);
                        }
                    } else if (this.recalcSeedingRanksTask != null) {
                        this.recalcSeedingRanksTask.cancel();
                        this.recalcSeedingRanksTask = null;
                    }
                }
                this.recalcAllSeedingRanks(true);
                this.somethingChanged = true;
                if (this.bDebugLog) {
                    this.log.log(1, "somethingChanged: config reload");
                    try {
                        if (this.debugMenuItem == null && this.seedingRankColumn != null) {
                            this.debugMenuItem = ((TableColumnCore)this.seedingRankColumn).addContextMenuItem("StartStopRules.menu.viewDebug");
                            this.debugMenuItem.addListener(new MenuItemListener(){

                                public void selected(MenuItem _menu, Object _target) {
                                    Download dl = (Download)((TableRow)_target).getDataSource();
                                    downloadData dlData = (downloadData)StartStopRulesDefaultPlugin.this.downloadDataMap.get(dl);
                                    if (dlData != null) {
                                        new TextViewerWindow(null, null, String.valueOf(dlData.sExplainFP) + "\n" + dlData.sTrace);
                                    }
                                }
                            });
                        }
                        break block13;
                    }
                    catch (Throwable t) {
                        Debug.printStackTrace(t);
                    }
                    break block13;
                }
                if (this.debugMenuItem != null && this.seedingRankColumn != null) {
                    ((TableColumnCore)this.seedingRankColumn).removeContextMenuItem(this.debugMenuItem);
                    this.debugMenuItem = null;
                }
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    private int calcMaxSeeders(int iDLs) {
        return this.maxActive == 0 ? 99999 : this.maxActive - iDLs;
    }

    protected void process() {
        try {
            Download download;
            Object dlData;
            int maxTorrents;
            int iExtraFPs;
            this.this_mon.enter();
            int totalForcedSeeding = 0;
            int totalWaitingToSeed = 0;
            int totalWaitingToDL = 0;
            int totalDownloading = 0;
            int activeDLCount = 0;
            int activeSeedingCount = 0;
            int totalComplete = 0;
            int totalIncompleteQueued = 0;
            int totalFirstPriority = 0;
            int totalStalledSeeders = 0;
            int total0PeerSeeders = 0;
            Object[] dlDataArray = this.downloadDataMap.values().toArray(new downloadData[this.downloadDataMap.size()]);
            boolean bSeedHasRanking = this.iRankType == 0 || this.iRankType == 3 || SystemTime.getCurrentTime() - this.startedOn > 90000L;
            int i = 0;
            while (i < dlDataArray.length) {
                downloadData dlData2 = dlDataArray[i];
                Download download2 = dlData2.getDownloadObject();
                DownloadStats stats = download2.getStats();
                int completionLevel = stats.getDownloadCompleted(false);
                if (completionLevel >= 1000 || !download2.isForceStart()) {
                    int state = download2.getState();
                    if (completionLevel == 1000) {
                        if (!(bSeedHasRanking || dlData2.getSeedingRank() <= 0 || state != 9 && state != 3)) {
                            bSeedHasRanking = true;
                        }
                        if (state != 8 && state != 7) {
                            ++totalComplete;
                            if (dlData2.getActivelySeeding()) {
                                ++activeSeedingCount;
                                if (download2.isForceStart()) {
                                    ++totalForcedSeeding;
                                }
                            } else if (state == 5) {
                                ++totalStalledSeeders;
                                if (this.bAutoStart0Peers && this.calcPeersNoUs(download2) == 0 && this.scrapeResultOk(download2)) {
                                    ++total0PeerSeeders;
                                }
                            }
                            if (state == 3 || state == 1 || state == 2) {
                                ++totalWaitingToSeed;
                            }
                            if (dlData2.isFirstPriority()) {
                                ++totalFirstPriority;
                                bSeedHasRanking = true;
                            }
                        }
                    } else {
                        if (state == 4) {
                            ++totalDownloading;
                        }
                        if (dlData2.getActivelyDownloading()) {
                            ++activeDLCount;
                        }
                        if (state == 3 || state == 1 || state == 2) {
                            ++totalWaitingToDL;
                        } else if (state == 9) {
                            ++totalIncompleteQueued;
                        }
                    }
                }
                ++i;
            }
            int maxSeeders = this.calcMaxSeeders(activeDLCount + totalWaitingToDL);
            int n = iExtraFPs = this.maxActive != 0 && this.maxDownloads != 0 && this.maxDownloads + totalFirstPriority - this.maxActive > 0 ? this.maxDownloads + totalFirstPriority - this.maxActive : 0;
            if (this.maxActive == 0) {
                maxTorrents = 9999;
            } else if (this.iMaxUploadSpeed == 0) {
                maxTorrents = this.maxActive + 4;
            } else {
                int minSpeedPerActive = this.minSpeedForActiveSeeding * 2 / 1024;
                if (minSpeedPerActive < 3) {
                    minSpeedPerActive = 3;
                }
                if ((maxTorrents = this.iMaxUploadSpeed / minSpeedPerActive) < this.maxActive) {
                    maxTorrents = this.maxActive;
                }
            }
            String[] mainDebugEntries = null;
            if (this.bDebugLog) {
                this.log.log(1, ">>process()");
                mainDebugEntries = new String[]{"bHasSR=" + bSeedHasRanking, "tFrcdCding=" + totalForcedSeeding, "actvCDs=" + activeSeedingCount, "tW8tingToCd=" + totalWaitingToSeed, "tDLing=" + totalDownloading, "actvDLs=" + activeDLCount, "tW8tingToDL=" + totalWaitingToDL, "tCom=" + totalComplete, "tIncQd=" + totalIncompleteQueued, "mxCdrs=" + maxSeeders, "t1stPr=" + totalFirstPriority, "maxT=" + maxTorrents};
            }
            this.somethingChanged = false;
            if (this.iRankType != 0) {
                Arrays.sort(dlDataArray);
            } else {
                Arrays.sort(dlDataArray, new Comparator(){

                    public final int compare(Object a, Object b) {
                        boolean bIsComplete;
                        Download aDL = ((downloadData)a).getDownloadObject();
                        Download bDL = ((downloadData)b).getDownloadObject();
                        boolean aIsComplete = aDL.getStats().getDownloadCompleted(false) == 1000;
                        boolean bl = bIsComplete = bDL.getStats().getDownloadCompleted(false) == 1000;
                        if (aIsComplete && !bIsComplete) {
                            return 1;
                        }
                        if (!aIsComplete && bIsComplete) {
                            return -1;
                        }
                        boolean aIsFP = ((downloadData)a).isFirstPriority();
                        boolean bIsFP = ((downloadData)b).isFirstPriority();
                        if (aIsFP && !bIsFP) {
                            return -1;
                        }
                        if (!aIsFP && bIsFP) {
                            return 1;
                        }
                        return aDL.getPosition() - bDL.getPosition();
                    }
                });
            }
            int numWaitingOrSeeding = totalForcedSeeding;
            int numWaitingOrDLing = 0;
            boolean higherQueued = false;
            int posComplete = 0;
            int iSeedingPos = 0;
            long smallest_size = Long.MAX_VALUE;
            int smallest_size_index = -1;
            int i2 = 0;
            while (i2 < dlDataArray.length) {
                dlData = dlDataArray[i2];
                download = ((downloadData)dlData).getDownloadObject();
                if (!(download.getState() != 1 || download.getStats().getDownloadCompleted(false) != 1000 && this.getAlreadyAllocatingOrChecking())) {
                    Torrent t = download.getTorrent();
                    if (t == null) {
                        smallest_size_index = i2;
                    } else {
                        long size = t.getSize();
                        if (size < smallest_size) {
                            smallest_size = size;
                            smallest_size_index = i2;
                        }
                    }
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < dlDataArray.length) {
                dlData = dlDataArray[i2];
                download = ((downloadData)dlData).getDownloadObject();
                boolean bStopAndQueued = false;
                ((downloadData)dlData).sTrace = "";
                if (i2 == smallest_size_index) {
                    try {
                        download.initialize();
                    }
                    catch (Exception size) {
                        // empty catch block
                    }
                }
                if (this.bAutoReposition && this.iRankType != 0 && download.getStats().getDownloadCompleted(false) == 1000 && bSeedHasRanking) {
                    download.setPosition(++posComplete);
                }
                if (download.getStats().getDownloadCompleted(false) == 1000) {
                    ((downloadData)dlData).setSeedingPos(++iSeedingPos);
                }
                if (download.getState() != 6 && download.getState() != 7 && download.getState() != 8) {
                    if (download.getStats().getDownloadCompleted(false) != 1000) {
                        if (this.bDebugLog) {
                            String s = ">> " + download.getTorrent().getName() + "]: state=" + sStates.charAt(download.getState()) + ";shareRatio=" + download.getStats().getShareRatio() + ";numW8tngorDLing=" + numWaitingOrDLing + ";maxCDrs=" + maxSeeders + ";forced=" + download.isForceStart() + ";forcedStart=" + download.isForceStart() + ";actvDLs=" + activeDLCount;
                            this.log.log(1, s);
                            ((downloadData)dlData).sTrace = String.valueOf(((downloadData)dlData).sTrace) + s + "\n";
                        }
                        if (!download.isForceStart()) {
                            int state = download.getState();
                            if (state == 2) {
                                ++numWaitingOrDLing;
                            } else if (state == 3 || state == 4 || state == 1) {
                                boolean bActivelyDownloading = ((downloadData)dlData).getActivelyDownloading();
                                if (this.maxDownloads != 0 && numWaitingOrDLing >= this.maxDownloads - iExtraFPs && (bActivelyDownloading || state != 4)) {
                                    try {
                                        if (this.bDebugLog) {
                                            String s = "   stopAndQueue() > maxDownloads";
                                            this.log.log(1, s);
                                            ((downloadData)dlData).sTrace = String.valueOf(((downloadData)dlData).sTrace) + s + "\n";
                                        }
                                        download.stopAndQueue();
                                        if (state == 4) {
                                            --totalDownloading;
                                            if (bActivelyDownloading) {
                                                --activeDLCount;
                                            }
                                        } else {
                                            --totalWaitingToDL;
                                        }
                                        maxSeeders = this.calcMaxSeeders(activeDLCount + totalWaitingToDL);
                                    }
                                    catch (Exception s) {
                                        // empty catch block
                                    }
                                    state = download.getState();
                                } else if (bActivelyDownloading) {
                                    ++numWaitingOrDLing;
                                }
                            }
                            if (state == 9 && (this.maxDownloads == 0 || numWaitingOrDLing < this.maxDownloads - iExtraFPs)) {
                                try {
                                    if (this.bDebugLog) {
                                        String s = "   restart()";
                                        this.log.log(1, s);
                                        ((downloadData)dlData).sTrace = String.valueOf(((downloadData)dlData).sTrace) + s + "\n";
                                    }
                                    download.restart();
                                    ++numWaitingOrDLing;
                                    maxSeeders = this.calcMaxSeeders(activeDLCount + ++totalWaitingToDL);
                                }
                                catch (Exception s) {
                                    // empty catch block
                                }
                                state = download.getState();
                            }
                            if (state == 3 && (this.maxDownloads == 0 || activeDLCount < this.maxDownloads - iExtraFPs)) {
                                try {
                                    if (this.bDebugLog) {
                                        String s = "   start() activeDLCount < maxDownloads";
                                        this.log.log(1, s);
                                        ((downloadData)dlData).sTrace = String.valueOf(((downloadData)dlData).sTrace) + s + "\n";
                                    }
                                    download.start();
                                    ++numWaitingOrDLing;
                                    maxSeeders = this.calcMaxSeeders(++activeDLCount + --totalWaitingToDL);
                                }
                                catch (Exception s) {
                                    // empty catch block
                                }
                                state = download.getState();
                            }
                            if (this.bDebugLog) {
                                String s = "<< " + download.getTorrent().getName() + "]: state=" + sStates.charAt(download.getState()) + ";shareRatio=" + download.getStats().getShareRatio() + ";numW8tngorDLing=" + numWaitingOrDLing + ";maxCDrs=" + maxSeeders + ";forced=" + download.isForceStart() + ";forcedStart=" + download.isForceStart() + ";actvDLs=" + activeDLCount;
                                this.log.log(1, s);
                                ((downloadData)dlData).sTrace = String.valueOf(((downloadData)dlData).sTrace) + s + "\n";
                            }
                        }
                    } else if (bSeedHasRanking || totalFirstPriority > 0) {
                        String[] debugEntries = null;
                        String sDebugLine = "";
                        boolean isFP = ((downloadData)dlData).isFirstPriority();
                        if (bSeedHasRanking || isFP) {
                            int state = download.getState();
                            int numPeers = this.calcPeersNoUs(download);
                            if (this.bAutoStart0Peers && numPeers == 0 && this.scrapeResultOk(download)) {
                                if (state == 9) {
                                    try {
                                        if (this.bDebugLog) {
                                            sDebugLine = String.valueOf(sDebugLine) + "\nrestart() 0Peers";
                                        }
                                        download.restart();
                                        state = download.getState();
                                        if (state == 3) {
                                            if (this.bDebugLog) {
                                                sDebugLine = String.valueOf(sDebugLine) + "\nstart(); 0Peers";
                                            }
                                            download.start();
                                        }
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                if (state == 3) {
                                    try {
                                        if (this.bDebugLog) {
                                            sDebugLine = String.valueOf(sDebugLine) + "\nstart(); 0Peers";
                                        }
                                        download.start();
                                    }
                                    catch (Exception exception) {}
                                }
                            } else {
                                boolean okToQueue;
                                int shareRatio = download.getStats().getShareRatio();
                                boolean bActivelySeeding = ((downloadData)dlData).getActivelySeeding();
                                boolean bl = okToQueue = (state == 3 || state == 5) && !download.isForceStart() && !isFP;
                                if (okToQueue && state == 5 && this.iRankType != 3) {
                                    long timeAlive = SystemTime.getCurrentTime() - download.getStats().getTimeStarted();
                                    boolean bl2 = okToQueue = timeAlive >= this.minTimeAlive;
                                }
                                if (state != 9 && (state == 3 || state == 1 || state == 2 || state == 5 && bActivelySeeding && !download.isForceStart())) {
                                    ++numWaitingOrSeeding;
                                }
                                if (this.bDebugLog) {
                                    debugEntries = new String[]{"state=" + sStates.charAt(state), "shareR=" + shareRatio, "nWorCDing=" + numWaitingOrSeeding, "nWorDLing=" + numWaitingOrDLing, "ok2Q=" + okToQueue, "sr=" + ((downloadData)dlData).getSeedingRank(), "hgherQd=" + higherQueued, "maxCDrs=" + maxSeeders, "1stP=" + isFP, "actCDingCount=" + activeSeedingCount, "ActCDing=" + bActivelySeeding};
                                }
                                if (okToQueue) {
                                    int numSeeds = this.calcSeedsNoUs(download);
                                    if (this.iIgnoreShareRatio != 0 && shareRatio > this.iIgnoreShareRatio && numSeeds >= this.iIgnoreShareRatio_SeedStart && shareRatio != -1 && ((downloadData)dlData).getSeedingRank() != -6) {
                                        if (this.bDebugLog) {
                                            sDebugLine = String.valueOf(sDebugLine) + "\nShare Ratio Met";
                                        }
                                        ((downloadData)dlData).setSeedingRank(-6);
                                    }
                                    if (this.iIgnoreRatioPeers != 0 && ((downloadData)dlData).getSeedingRank() != -3) {
                                        float ratio;
                                        if (this.numPeersAsFullCopy != 0 && numSeeds >= this.iFakeFullCopySeedStart) {
                                            numSeeds += numPeers / this.numPeersAsFullCopy;
                                        }
                                        if (numSeeds != 0 && numSeeds >= this.iIgnoreRatioPeers_SeedStart && (ratio = (float)numPeers / (float)numSeeds) <= (float)this.iIgnoreRatioPeers) {
                                            sDebugLine = String.valueOf(sDebugLine) + "\nP:S Met";
                                            ((downloadData)dlData).setSeedingRank(-3);
                                        }
                                    }
                                } else if (state == 9 && numWaitingOrSeeding < maxSeeders && activeSeedingCount + totalStalledSeeders - total0PeerSeeders + totalDownloading < maxTorrents && ((downloadData)dlData).getSeedingRank() > -2 && !higherQueued) {
                                    try {
                                        if (this.bDebugLog) {
                                            sDebugLine = String.valueOf(sDebugLine) + "\nrestart() numWaitingOrSeeding < maxSeeders";
                                        }
                                        download.restart();
                                        okToQueue = false;
                                        ++totalWaitingToSeed;
                                        ++numWaitingOrSeeding;
                                        if (this.iRankType == 3) {
                                            ((downloadData)dlData).recalcSeedingRank();
                                        }
                                    }
                                    catch (Exception numSeeds) {
                                        // empty catch block
                                    }
                                    state = download.getState();
                                }
                                if (state == 3 && activeSeedingCount < maxSeeders) {
                                    if (((downloadData)dlData).getSeedingRank() > -2) {
                                        try {
                                            if (this.bDebugLog) {
                                                sDebugLine = String.valueOf(sDebugLine) + "\nstart(); activeSeedingCount < maxSeeders";
                                            }
                                            download.start();
                                            okToQueue = false;
                                        }
                                        catch (Exception numSeeds) {
                                            // empty catch block
                                        }
                                        state = download.getState();
                                        ++activeSeedingCount;
                                    } else if (okToQueue) {
                                        try {
                                            if (this.bDebugLog) {
                                                sDebugLine = String.valueOf(sDebugLine) + "\nstopAndQueue()";
                                            }
                                            download.stopAndQueue();
                                            bStopAndQueued = true;
                                            --totalWaitingToSeed;
                                            if (bActivelySeeding) {
                                                --numWaitingOrSeeding;
                                            }
                                        }
                                        catch (Exception numSeeds) {
                                            // empty catch block
                                        }
                                        state = download.getState();
                                    }
                                }
                                if (okToQueue && (bActivelySeeding || state != 5) && (numWaitingOrSeeding > maxSeeders || higherQueued || ((downloadData)dlData).getSeedingRank() <= -2)) {
                                    try {
                                        if (this.bDebugLog) {
                                            sDebugLine = String.valueOf(sDebugLine) + "\nstopAndQueue()";
                                            if (numWaitingOrSeeding > maxSeeders) {
                                                sDebugLine = String.valueOf(sDebugLine) + "; > Max";
                                            }
                                            if (higherQueued) {
                                                sDebugLine = String.valueOf(sDebugLine) + "; higherQueued (it should be seeding instead of this one)";
                                            }
                                            if (((downloadData)dlData).getSeedingRank() <= -2) {
                                                sDebugLine = String.valueOf(sDebugLine) + "; ignoreRule met";
                                            }
                                        }
                                        if (state == 3) {
                                            --totalWaitingToSeed;
                                        }
                                        download.stopAndQueue();
                                        bStopAndQueued = true;
                                        if (bActivelySeeding) {
                                            --activeSeedingCount;
                                            --numWaitingOrSeeding;
                                        }
                                    }
                                    catch (Exception numSeeds) {
                                        // empty catch block
                                    }
                                    state = download.getState();
                                }
                                if (bStopAndQueued && this.iRankType == 3) {
                                    int j = 0;
                                    while (j < dlDataArray.length) {
                                        int sr = ((downloadData)dlDataArray[j]).getSeedingRank();
                                        if (sr > 0 && sr < 10000000) {
                                            ((downloadData)dlDataArray[j]).setSeedingRank(sr + 1);
                                        }
                                        ++j;
                                    }
                                    ((downloadData)dlData).setSeedingRank(10000000 - totalComplete);
                                }
                                if (download.getState() == 9 && ((downloadData)dlData).getSeedingRank() >= 0) {
                                    higherQueued = true;
                                }
                                if (this.bDebugLog) {
                                    String[] debugEntries2 = new String[]{"state=" + sStates.charAt(download.getState()), "shareR=" + download.getStats().getShareRatio(), "nWorCDing=" + numWaitingOrSeeding, "nWorDLing=" + numWaitingOrDLing, "ok2Q=" + okToQueue, "sr=" + ((downloadData)dlData).getSeedingRank(), "hgherQd=" + higherQueued, "maxCDrs=" + maxSeeders, "1stP=" + ((downloadData)dlData).isFirstPriority(), "actCDingCount=" + activeSeedingCount, "ActCDing=" + bActivelySeeding};
                                    this.printDebugChanges(String.valueOf(download.getName()) + "] ", debugEntries, debugEntries2, sDebugLine, "  ", true, (downloadData)dlData);
                                }
                            }
                        }
                    }
                }
                ++i2;
            }
            if (this.bDebugLog) {
                String[] mainDebugEntries2 = new String[]{"bHasSR=" + bSeedHasRanking, "tFrcdCding=" + totalForcedSeeding, "actvCDs=" + activeSeedingCount, "tW8tingToCd=" + totalWaitingToSeed, "tDLing=" + totalDownloading, "actvDLs=" + activeDLCount, "tW8tingToDL=" + totalWaitingToDL, "tCom=" + totalComplete, "tIncQd=" + totalIncompleteQueued, "mxCdrs=" + maxSeeders, "t1stPr=" + totalFirstPriority, "maxT=" + maxTorrents};
                this.printDebugChanges("<<process() ", mainDebugEntries, mainDebugEntries2, "", "", true, null);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    private void printDebugChanges(String sPrefixFirstLine, String[] oldEntries, String[] newEntries, String sDebugLine, String sPrefix, boolean bAlwaysPrintNoChangeLine, downloadData dlData) {
        boolean bAnyChanged = false;
        String sDebugLineNoChange = sPrefixFirstLine;
        String sDebugLineOld = "";
        String sDebugLineNew = "";
        int j = 0;
        while (j < oldEntries.length) {
            if (oldEntries[j].equals(newEntries[j])) {
                sDebugLineNoChange = String.valueOf(sDebugLineNoChange) + oldEntries[j] + ";";
            } else {
                sDebugLineOld = String.valueOf(sDebugLineOld) + oldEntries[j] + ";";
                sDebugLineNew = String.valueOf(sDebugLineNew) + newEntries[j] + ";";
                bAnyChanged = true;
            }
            ++j;
        }
        String sDebugLineOut = String.valueOf(bAlwaysPrintNoChangeLine || bAnyChanged ? sDebugLineNoChange : "") + (bAnyChanged ? "\nOld:" + sDebugLineOld + "\nNew:" + sDebugLineNew : "") + sDebugLine;
        if (!sDebugLineOut.equals("")) {
            String[] lines = sDebugLineOut.split("\n");
            int i = 0;
            while (i < lines.length) {
                String s = String.valueOf(sPrefix) + (i > 0 ? "  " : "") + lines[i];
                this.log.log(1, s);
                if (dlData != null) {
                    dlData.sTrace = String.valueOf(dlData.sTrace) + s + "\n";
                }
                ++i;
            }
        }
    }

    public boolean getAlreadyAllocatingOrChecking() {
        Download[] downloads = this.download_manager.getDownloads(false);
        int i = 0;
        while (i < downloads.length) {
            Download download = downloads[i];
            int state = download.getState();
            if (state == 2) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int calcPeersNoUs(Download download) {
        DownloadAnnounceResult ar;
        int numPeers = 0;
        DownloadScrapeResult sr = download.getLastScrapeResult();
        if (sr.getScrapeStartTime() > 0L && (numPeers = sr.getNonSeedCount()) > 0 && download.getState() == 4 && sr.getScrapeStartTime() > download.getStats().getTimeStarted()) {
            --numPeers;
        }
        if (numPeers == 0 && (ar = download.getLastAnnounceResult()) != null && ar.getResponseType() == 1) {
            numPeers = ar.getNonSeedCount();
        }
        return numPeers;
    }

    public boolean scrapeResultOk(Download download) {
        DownloadScrapeResult sr = download.getLastScrapeResult();
        return sr.getResponseType() == 1;
    }

    public int calcSeedsNoUs(Download download) {
        DownloadAnnounceResult ar;
        int numSeeds = 0;
        DownloadScrapeResult sr = download.getLastScrapeResult();
        if (sr.getScrapeStartTime() > 0L) {
            long seedingStartedOn = download.getStats().getTimeStartedSeeding();
            numSeeds = sr.getSeedCount();
            if (numSeeds > 0 && seedingStartedOn > 0L && download.getState() == 5 && sr.getScrapeStartTime() > seedingStartedOn) {
                --numSeeds;
            }
        }
        if (numSeeds == 0 && (ar = download.getLastAnnounceResult()) != null && ar.getResponseType() == 1) {
            numSeeds = ar.getSeedCount();
        }
        return numSeeds;
    }

    private class RecalcSeedingRanksTask
    extends TimerTask {
        RecalcSeedingRanksTask() {
        }

        public void run() {
            StartStopRulesDefaultPlugin.this.recalcAllSeedingRanks(false);
        }
    }

    private class ChangeFlagCheckerTask
    extends TimerTask {
        long last_process_time = 0L;

        ChangeFlagCheckerTask() {
        }

        public void run() {
            if (StartStopRulesDefaultPlugin.this.closingDown) {
                return;
            }
            long now = SystemTime.getCurrentTime();
            if (now < this.last_process_time || now - this.last_process_time >= 30000L) {
                StartStopRulesDefaultPlugin.this.somethingChanged = true;
            }
            if (StartStopRulesDefaultPlugin.this.somethingChanged) {
                try {
                    this.last_process_time = now;
                    StartStopRulesDefaultPlugin.this.process();
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    private class StartStopDownloadListener
    implements DownloadListener {
        StartStopDownloadListener() {
        }

        public void stateChanged(Download download, int old_state, int new_state) {
            downloadData dlData = (downloadData)StartStopRulesDefaultPlugin.this.downloadDataMap.get(download);
            if (dlData != null) {
                dlData.recalcSeedingRank();
                StartStopRulesDefaultPlugin.this.somethingChanged = true;
                if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                    StartStopRulesDefaultPlugin.this.log.log(1, "somethingChanged: stateChange for " + download.getName());
                }
            }
        }

        public void positionChanged(Download download, int oldPosition, int newPosition) {
            downloadData dlData = (downloadData)StartStopRulesDefaultPlugin.this.downloadDataMap.get(download);
            if (dlData != null) {
                dlData.recalcSeedingRank();
                StartStopRulesDefaultPlugin.this.somethingChanged = true;
                if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                    StartStopRulesDefaultPlugin.this.log.log(1, "somethingChanged: positionChanged for " + download.getName());
                }
            }
        }
    }

    private class StartStopDMTrackerListener
    implements DownloadTrackerListener {
        StartStopDMTrackerListener() {
        }

        public void scrapeResult(DownloadScrapeResult result) {
            downloadData dlData = (downloadData)StartStopRulesDefaultPlugin.this.downloadDataMap.get(result.getDownload());
            if (dlData != null) {
                dlData.recalcSeedingRank();
                StartStopRulesDefaultPlugin.this.somethingChanged = true;
                if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                    StartStopRulesDefaultPlugin.this.log.log(1, "somethingChanged: new scrapeResult for " + result.getDownload().getName());
                }
            }
        }

        public void announceResult(DownloadAnnounceResult result) {
        }
    }

    private class StartStopDMListener
    implements DownloadManagerListener {
        private DownloadTrackerListener download_tracker_listener;
        private DownloadListener download_listener;

        public StartStopDMListener() {
            this.download_tracker_listener = new StartStopDMTrackerListener();
            this.download_listener = new StartStopDownloadListener();
        }

        public void downloadAdded(Download download) {
            downloadData dlData = null;
            if (StartStopRulesDefaultPlugin.this.downloadDataMap.containsKey(download)) {
                dlData = (downloadData)StartStopRulesDefaultPlugin.this.downloadDataMap.get(download);
            } else {
                dlData = new downloadData(download);
                StartStopRulesDefaultPlugin.this.downloadDataMap.put(download, dlData);
                download.addListener(this.download_listener);
                download.addTrackerListener(this.download_tracker_listener);
            }
            if (dlData != null) {
                dlData.recalcSeedingRank();
                StartStopRulesDefaultPlugin.this.somethingChanged = true;
                if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                    StartStopRulesDefaultPlugin.this.log.log(1, "somethingChanged: downloadAdded: " + download.getName());
                }
            }
        }

        public void downloadRemoved(Download download) {
            download.removeListener(this.download_listener);
            download.removeTrackerListener(this.download_tracker_listener);
            if (StartStopRulesDefaultPlugin.this.downloadDataMap.containsKey(download)) {
                StartStopRulesDefaultPlugin.this.downloadDataMap.remove(download);
            }
            StartStopRulesDefaultPlugin.this.somethingChanged = true;
            if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                StartStopRulesDefaultPlugin.this.log.log(1, "somethingChanged: downloadRemoved: " + download.getName());
            }
        }
    }

    private class ChangeCheckerTimerTask
    extends TimerTask {
        ChangeCheckerTimerTask() {
        }

        public void run() {
            try {
                StartStopRulesDefaultPlugin.this.this_mon.enter();
                downloadData[] dlDataArray = StartStopRulesDefaultPlugin.this.downloadDataMap.values().toArray(new downloadData[0]);
                int iNumDLing = 0;
                int iNumCDing = 0;
                int i = 0;
                while (i < dlDataArray.length) {
                    int completionLevel;
                    Download dl = dlDataArray[i].getDownloadObject();
                    DownloadStats stats = dl.getStats();
                    if (dlDataArray[i].getActivelyDownloading()) {
                        ++iNumDLing;
                    }
                    if (dlDataArray[i].getActivelySeeding()) {
                        ++iNumCDing;
                        int shareRatio = dl.getStats().getShareRatio();
                        int numSeeds = StartStopRulesDefaultPlugin.this.calcSeedsNoUs(dl);
                        if (StartStopRulesDefaultPlugin.this.iIgnoreShareRatio != 0 && shareRatio > StartStopRulesDefaultPlugin.this.iIgnoreShareRatio && numSeeds >= StartStopRulesDefaultPlugin.this.iIgnoreShareRatio_SeedStart && shareRatio != -1) {
                            StartStopRulesDefaultPlugin.this.somethingChanged = true;
                        }
                    }
                    if (dl.getState() == 3) {
                        StartStopRulesDefaultPlugin.this.somethingChanged = true;
                        if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                            StartStopRulesDefaultPlugin.this.log.log(1, "somethingChanged: Download is ready");
                        }
                    }
                    if ((completionLevel = stats.getDownloadCompleted(false)) == 1000 && dlDataArray[i].getSeedingRank() >= 50000000 && !dlDataArray[i].isFirstPriority()) {
                        dlDataArray[i].recalcSeedingRank();
                        StartStopRulesDefaultPlugin.this.somethingChanged = true;
                        if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                            StartStopRulesDefaultPlugin.this.log.log(1, "somethingChanged: FirstPriority lost for " + dl.getName());
                        }
                    }
                    ++i;
                }
                int iMaxSeeders = StartStopRulesDefaultPlugin.this.calcMaxSeeders(iNumDLing);
                if (iNumCDing > iMaxSeeders) {
                    StartStopRulesDefaultPlugin.this.somethingChanged = true;
                    if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                        StartStopRulesDefaultPlugin.this.log.log(1, "somethingChanged: More Seeding than limit");
                    }
                }
            }
            finally {
                StartStopRulesDefaultPlugin.this.this_mon.exit();
            }
        }
    }

    private class downloadData
    implements Comparable {
        protected int sr;
        protected int iSeedingPos;
        protected Download dl;
        private boolean bActivelyDownloading;
        private boolean bActivelySeeding;
        public String sExplainFP = "";
        public String sTrace = "";
        private AEMonitor downloadData_this_mon = new AEMonitor("StartStopRules:downloadData");

        public int compareTo(Object obj) {
            int value = ((downloadData)obj).getSeedingRank() - this.sr;
            if (value == 0) {
                return this.dl.getPosition() - ((downloadData)obj).getDownloadObject().getPosition();
            }
            return value;
        }

        public downloadData(Download _dl) {
            this.dl = _dl;
            this.iSeedingPos = 100000 - this.dl.getPosition();
        }

        public int getSeedingPos() {
            return this.iSeedingPos;
        }

        public void setSeedingPos(int iPos) {
            this.iSeedingPos = iPos;
        }

        Download getDownloadObject() {
            return this.dl;
        }

        public boolean getActivelyDownloading() {
            boolean bIsActive = false;
            DownloadStats stats = this.dl.getStats();
            int state = this.dl.getState();
            if (state == 4 && (stats.getDownloadAverage() >= (long)StartStopRulesDefaultPlugin.this.minSpeedForActiveDL || SystemTime.getCurrentTime() - stats.getTimeStarted() <= 30000L)) {
                bIsActive = true;
            }
            if (this.bActivelyDownloading != bIsActive) {
                this.bActivelyDownloading = bIsActive;
                StartStopRulesDefaultPlugin.this.somethingChanged = true;
                if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                    StartStopRulesDefaultPlugin.this.log.log(1, "somethingChanged: ActivelyDownloading changed for " + this.dl.getName());
                }
            }
            return this.bActivelyDownloading;
        }

        public boolean getActivelySeeding() {
            boolean bIsActive = false;
            DownloadStats stats = this.dl.getStats();
            int state = this.dl.getState();
            if (!(StartStopRulesDefaultPlugin.this.iRankType != 3 || this.isFirstPriority() || StartStopRulesDefaultPlugin.this.bAutoStart0Peers && StartStopRulesDefaultPlugin.this.calcPeersNoUs(this.dl) == 0 && StartStopRulesDefaultPlugin.this.scrapeResultOk(this.dl))) {
                return state == 5;
            }
            if (!(state != 5 || stats.getUploadAverage() < (long)StartStopRulesDefaultPlugin.this.minSpeedForActiveSeeding && SystemTime.getCurrentTime() - stats.getTimeStarted() > 30000L || StartStopRulesDefaultPlugin.this.bAutoStart0Peers && StartStopRulesDefaultPlugin.this.calcPeersNoUs(this.dl) <= 0)) {
                bIsActive = true;
            }
            if (this.bActivelySeeding != bIsActive) {
                this.bActivelySeeding = bIsActive;
                StartStopRulesDefaultPlugin.this.somethingChanged = true;
                if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                    StartStopRulesDefaultPlugin.this.log.log(1, "somethingChanged: ActivelySeeding changed for " + this.dl.getName());
                }
            }
            return this.bActivelySeeding;
        }

        public boolean getIsSeeding() {
            int state = this.dl.getState();
            if (state == 5) {
                return true;
            }
            return this.dl.getStats().getDownloadCompleted(false) == 1000 && (state == 3 || state == 1 || state == 2);
        }

        public boolean getIsDownloading() {
            int state = this.dl.getState();
            if (state == 4) {
                return true;
            }
            return this.dl.getStats().getDownloadCompleted(false) < 1000 && (state == 3 || state == 1 || state == 2);
        }

        public int getSeedingRank() {
            return this.sr;
        }

        public void setSeedingRank(int newSeedingRank) {
            this.sr = newSeedingRank;
        }

        public int recalcSeedingRank() {
            boolean bNewSRInRange;
            int newSR;
            boolean bScrapeResultsOk;
            int num_seeds_excluding_us;
            int num_peers_excluding_us;
            block39: {
                block42: {
                    int state;
                    DownloadStats stats;
                    block41: {
                        block40: {
                            block38: {
                                block34: {
                                    float ratio;
                                    block37: {
                                        block36: {
                                            int shareRatio;
                                            block35: {
                                                block33: {
                                                    try {
                                                        this.downloadData_this_mon.enter();
                                                        stats = this.dl.getStats();
                                                        int numCompleted = stats.getDownloadCompleted(false);
                                                        if (numCompleted >= 1000) break block33;
                                                        this.setSeedingRank(1000000000 - this.dl.getPosition());
                                                        int n = this.sr;
                                                        this.downloadData_this_mon.exit();
                                                        return n;
                                                    }
                                                    catch (Throwable throwable) {
                                                        this.downloadData_this_mon.exit();
                                                        throw throwable;
                                                    }
                                                }
                                                shareRatio = stats.getShareRatio();
                                                num_peers_excluding_us = StartStopRulesDefaultPlugin.this.calcPeersNoUs(this.dl);
                                                num_seeds_excluding_us = StartStopRulesDefaultPlugin.this.calcSeedsNoUs(this.dl);
                                                if (StartStopRulesDefaultPlugin.this.numPeersAsFullCopy != 0 && num_seeds_excluding_us >= StartStopRulesDefaultPlugin.this.iFakeFullCopySeedStart) {
                                                    num_seeds_excluding_us += num_peers_excluding_us / StartStopRulesDefaultPlugin.this.numPeersAsFullCopy;
                                                }
                                                bScrapeResultsOk = num_peers_excluding_us > 0 || num_seeds_excluding_us > 0 || StartStopRulesDefaultPlugin.this.scrapeResultOk(this.dl);
                                                newSR = 0;
                                                if (this.isFirstPriority()) {
                                                    newSR = 50000000;
                                                    break block34;
                                                }
                                                if (num_peers_excluding_us != 0 || !bScrapeResultsOk || !StartStopRulesDefaultPlugin.this.bIgnore0Peers) break block35;
                                                this.setSeedingRank(-5);
                                                this.downloadData_this_mon.exit();
                                                return -5;
                                            }
                                            if (StartStopRulesDefaultPlugin.this.iIgnoreShareRatio == 0 || shareRatio <= StartStopRulesDefaultPlugin.this.iIgnoreShareRatio || num_seeds_excluding_us < StartStopRulesDefaultPlugin.this.iIgnoreShareRatio_SeedStart || shareRatio == -1) break block36;
                                            this.setSeedingRank(-6);
                                            int n = this.sr;
                                            this.downloadData_this_mon.exit();
                                            return n;
                                        }
                                        if (StartStopRulesDefaultPlugin.this.iIgnoreSeedCount == 0 || num_seeds_excluding_us < StartStopRulesDefaultPlugin.this.iIgnoreSeedCount) break block37;
                                        this.setSeedingRank(-4);
                                        this.downloadData_this_mon.exit();
                                        return -4;
                                    }
                                    if (StartStopRulesDefaultPlugin.this.iIgnoreRatioPeers == 0 || num_seeds_excluding_us == 0 || !((ratio = (float)num_peers_excluding_us / (float)num_seeds_excluding_us) <= (float)StartStopRulesDefaultPlugin.this.iIgnoreRatioPeers) || num_seeds_excluding_us < StartStopRulesDefaultPlugin.this.iIgnoreRatioPeers_SeedStart) break block34;
                                    this.setSeedingRank(-3);
                                    this.downloadData_this_mon.exit();
                                    return -3;
                                }
                                if (StartStopRulesDefaultPlugin.this.iRankType != 0) break block38;
                                this.setSeedingRank(newSR);
                                int n = newSR;
                                this.downloadData_this_mon.exit();
                                return n;
                            }
                            if (StartStopRulesDefaultPlugin.this.iRankType != 3) break block39;
                            if (newSR < 50000000) break block40;
                            this.setSeedingRank(newSR);
                            int n = newSR;
                            this.downloadData_this_mon.exit();
                            return n;
                        }
                        state = this.dl.getState();
                        if (state != 6 && state != 7 && state != 8) break block41;
                        this.setSeedingRank(-2);
                        this.downloadData_this_mon.exit();
                        return -2;
                    }
                    if (state != 5 && state != 3 && state != 1 && state != 2) break block42;
                    long lMsElapsed = 0L;
                    if (state == 5 && !this.dl.isForceStart()) {
                        lMsElapsed = SystemTime.getCurrentTime() - stats.getTimeStartedSeeding();
                    }
                    int oldSR = this.getSeedingRank();
                    if (lMsElapsed >= StartStopRulesDefaultPlugin.this.minTimeAlive) {
                        this.setSeedingRank(1);
                        if (oldSR > 10000000) {
                            StartStopRulesDefaultPlugin.this.somethingChanged = true;
                            if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                                StartStopRulesDefaultPlugin.this.log.log(1, "somethingChanged: TimeUp for " + this.dl.getName());
                            }
                        }
                    } else {
                        this.setSeedingRank(10000001 + (int)(lMsElapsed / 1000L));
                        if (oldSR <= 10000000) {
                            StartStopRulesDefaultPlugin.this.somethingChanged = true;
                            if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                                StartStopRulesDefaultPlugin.this.log.log(1, "somethingChanged: strange timer change for " + this.dl.getName());
                            }
                        }
                    }
                    int n = this.getSeedingRank();
                    this.downloadData_this_mon.exit();
                    return n;
                }
                if (this.getSeedingRank() <= 0) {
                    this.setSeedingRank(10000000 - this.dl.getPosition());
                    StartStopRulesDefaultPlugin.this.somethingChanged = true;
                    if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                        StartStopRulesDefaultPlugin.this.log.log(1, "somethingChanged: NotIgnored for " + this.dl.getName());
                    }
                }
                int n = this.getSeedingRank();
                this.downloadData_this_mon.exit();
                return n;
            }
            if (StartStopRulesDefaultPlugin.this.iRankType == 2 && (StartStopRulesDefaultPlugin.this.iRankTypeSeedFallback == 0 || StartStopRulesDefaultPlugin.this.iRankTypeSeedFallback > num_seeds_excluding_us)) {
                if (bScrapeResultsOk) {
                    int limit = 24990000;
                    newSR += limit / (num_seeds_excluding_us + 1) + (StartStopRulesDefaultPlugin.this.bPreferLargerSwarms ? 1 : -1) * num_peers_excluding_us * 5;
                    if (num_seeds_excluding_us == 0 && num_peers_excluding_us >= StartStopRulesDefaultPlugin.this.minPeersToBoostNoSeeds) {
                        newSR += limit;
                    }
                }
            } else if (num_peers_excluding_us != 0) {
                if (num_seeds_excluding_us == 0) {
                    if (num_peers_excluding_us >= StartStopRulesDefaultPlugin.this.minPeersToBoostNoSeeds) {
                        newSR += 20000;
                    }
                } else {
                    newSR = num_peers_excluding_us > num_seeds_excluding_us ? (newSR += 10000 - num_seeds_excluding_us * 10000 / num_peers_excluding_us) : (newSR += num_peers_excluding_us * 1000 / num_seeds_excluding_us);
                }
                newSR = StartStopRulesDefaultPlugin.this.bPreferLargerSwarms ? (newSR += num_peers_excluding_us * 5) : (newSR -= num_peers_excluding_us * 5);
            }
            if (newSR < 0) {
                newSR = 1;
            }
            boolean bOldSRInRange = this.sr >= 0 && this.sr < 50000000;
            boolean bl = bNewSRInRange = newSR >= 0 && newSR < 50000000;
            if (bScrapeResultsOk || bOldSRInRange != bNewSRInRange) {
                this.setSeedingRank(newSR);
            }
            int n = this.sr;
            this.downloadData_this_mon.exit();
            return n;
        }

        public boolean isFirstPriority() {
            boolean bLastMatched;
            if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                this.sExplainFP = "FP Calculations.  Using " + (StartStopRulesDefaultPlugin.this.iFirstPriorityType == 0 ? "All" : "Any") + ":\n";
            }
            if (!this.dl.isPersistent()) {
                if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                    this.sExplainFP = String.valueOf(this.sExplainFP) + "Not FP: Download not persistent\n";
                }
                return false;
            }
            if (this.dl.getStats().getDownloadCompleted(false) < 1000) {
                if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                    this.sExplainFP = String.valueOf(this.sExplainFP) + "Not FP: Download not complete\n";
                }
                return false;
            }
            if (this.dl.getState() == 8 || this.dl.getState() == 7) {
                if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                    this.sExplainFP = String.valueOf(this.sExplainFP) + "Not FP: Download is ERROR or STOPPED\n";
                }
                return false;
            }
            int numPeers = StartStopRulesDefaultPlugin.this.calcPeersNoUs(this.dl);
            int numSeeds = StartStopRulesDefaultPlugin.this.calcSeedsNoUs(this.dl);
            if (numPeers > 0 && numSeeds > 0 && numSeeds / numPeers >= 10) {
                if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                    this.sExplainFP = String.valueOf(this.sExplainFP) + "Not FP: P:S >= 10:1\n";
                }
                return false;
            }
            if (numPeers == 0 && StartStopRulesDefaultPlugin.this.scrapeResultOk(this.dl)) {
                if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                    this.sExplainFP = String.valueOf(this.sExplainFP) + "Not FP: 0 peers\n";
                }
                return false;
            }
            int shareRatio = this.dl.getStats().getShareRatio();
            boolean bl = bLastMatched = shareRatio != -1 && shareRatio < StartStopRulesDefaultPlugin.this.minQueueingShareRatio;
            if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                this.sExplainFP = String.valueOf(this.sExplainFP) + "  shareRatio(" + shareRatio + ") < " + StartStopRulesDefaultPlugin.this.minQueueingShareRatio + "=" + bLastMatched + "\n";
            }
            if (!bLastMatched && StartStopRulesDefaultPlugin.this.iFirstPriorityType == 0) {
                if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                    this.sExplainFP = String.valueOf(this.sExplainFP) + "..Not FP.  Exit Early\n";
                }
                return false;
            }
            if (bLastMatched && StartStopRulesDefaultPlugin.this.iFirstPriorityType == 1) {
                if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                    this.sExplainFP = String.valueOf(this.sExplainFP) + "..Is FP.  Exit Early\n";
                }
                return true;
            }
            boolean bl2 = bLastMatched = StartStopRulesDefaultPlugin.this.iFirstPrioritySeedingMinutes == 0;
            if (!bLastMatched) {
                long timeSeeding = this.dl.getStats().getSecondsOnlySeeding();
                if (timeSeeding > 0L) {
                    boolean bl3 = bLastMatched = timeSeeding < (long)(StartStopRulesDefaultPlugin.this.iFirstPrioritySeedingMinutes * 60);
                    if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                        this.sExplainFP = String.valueOf(this.sExplainFP) + "  SeedingTime(" + timeSeeding + ") < " + StartStopRulesDefaultPlugin.this.iFirstPrioritySeedingMinutes * 60 + "=" + bLastMatched + "\n";
                    }
                    if (!bLastMatched && StartStopRulesDefaultPlugin.this.iFirstPriorityType == 0) {
                        if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                            this.sExplainFP = String.valueOf(this.sExplainFP) + "..Not FP.  Exit Early\n";
                        }
                        return false;
                    }
                    if (bLastMatched && StartStopRulesDefaultPlugin.this.iFirstPriorityType == 1) {
                        if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                            this.sExplainFP = String.valueOf(this.sExplainFP) + "..Is FP.  Exit Early\n";
                        }
                        return true;
                    }
                }
            } else if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                this.sExplainFP = String.valueOf(this.sExplainFP) + "  SeedingTime setting == 0:  Ignored";
            }
            boolean bl4 = bLastMatched = StartStopRulesDefaultPlugin.this.iFirstPriorityDLMinutes == 0;
            if (!bLastMatched) {
                long timeDLing = this.dl.getStats().getSecondsDownloading();
                if (timeDLing > 0L) {
                    boolean bl5 = bLastMatched = timeDLing < (long)(StartStopRulesDefaultPlugin.this.iFirstPriorityDLMinutes * 60);
                    if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                        this.sExplainFP = String.valueOf(this.sExplainFP) + "  DLTime(" + timeDLing + ") < " + StartStopRulesDefaultPlugin.this.iFirstPriorityDLMinutes * 60 + "=" + bLastMatched + "\n";
                    }
                    if (!bLastMatched && StartStopRulesDefaultPlugin.this.iFirstPriorityType == 0) {
                        if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                            this.sExplainFP = String.valueOf(this.sExplainFP) + "..Not FP.  Exit Early\n";
                        }
                        return false;
                    }
                    if (bLastMatched && StartStopRulesDefaultPlugin.this.iFirstPriorityType == 1) {
                        if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                            this.sExplainFP = String.valueOf(this.sExplainFP) + "..Is FP.  Exit Early\n";
                        }
                        return true;
                    }
                }
            } else if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                this.sExplainFP = String.valueOf(this.sExplainFP) + "  DLTime setting == 0:  Ignored";
            }
            if (StartStopRulesDefaultPlugin.this.iFirstPriorityType == 0) {
                if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                    this.sExplainFP = String.valueOf(this.sExplainFP) + "..Is FP\n";
                }
                return true;
            }
            if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                this.sExplainFP = String.valueOf(this.sExplainFP) + "..Not FP\n";
            }
            return false;
        }
    }

    private class SeedingRankColumnListener
    implements TableCellAddedListener,
    TableCellRefreshListener {
        SeedingRankColumnListener() {
        }

        public void cellAdded(TableCell cell) {
            Download dl = (Download)cell.getDataSource();
            downloadData dlData = (downloadData)StartStopRulesDefaultPlugin.this.downloadDataMap.get(dl);
            if (dlData != null) {
                cell.setSortValue(dlData);
            }
        }

        public void refresh(TableCell cell) {
            Download dl = (Download)cell.getDataSource();
            if (dl == null) {
                return;
            }
            downloadData dlData = (downloadData)StartStopRulesDefaultPlugin.this.downloadDataMap.get(dl);
            if (dlData == null) {
                return;
            }
            int sr = dlData.getSeedingRank();
            String sText = "";
            if (sr >= 0) {
                if (sr >= 50000000) {
                    sText = String.valueOf(sText) + MessageText.getString("StartStopRules.firstPriority") + " ";
                    sr -= 50000000;
                }
                if (StartStopRulesDefaultPlugin.this.iRankType == 3) {
                    if (sr > 10000000) {
                        long timeStarted = dl.getStats().getTimeStartedSeeding();
                        long timeLeft = dl.isForceStart() ? 31536000L : (timeStarted <= 0L ? StartStopRulesDefaultPlugin.this.minTimeAlive : StartStopRulesDefaultPlugin.this.minTimeAlive - (SystemTime.getCurrentTime() - timeStarted));
                        sText = String.valueOf(sText) + TimeFormatter.format(timeLeft / 1000L);
                    } else if (sr > 0) {
                        sText = String.valueOf(sText) + MessageText.getString("StartStopRules.waiting");
                    }
                } else if (sr > 0) {
                    if (SystemTime.getCurrentTime() - dl.getStats().getTimeStartedSeeding() < StartStopRulesDefaultPlugin.this.minTimeAlive) {
                        sText = String.valueOf(sText) + "* ";
                    }
                    sText = String.valueOf(sText) + String.valueOf(sr);
                }
            } else {
                sText = sr == -3 ? MessageText.getString("StartStopRules.ratioMet") : (sr == -4 ? MessageText.getString("StartStopRules.numSeedsMet") : (sr == -2 ? "" : (sr == -5 ? MessageText.getString("StartStopRules.0Peers") : (sr == -6 ? MessageText.getString("StartStopRules.shareRatioMet") : "ERR" + sr))));
            }
            cell.setText(sText);
            if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                cell.setToolTip(String.valueOf(dlData.sExplainFP) + "\n" + dlData.sTrace);
            } else {
                cell.setToolTip(null);
            }
        }
    }
}

