/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;

public abstract class ECPoint {
    ECCurve curve;
    ECFieldElement x;
    ECFieldElement y;

    protected ECPoint(ECCurve curve, ECFieldElement x, ECFieldElement y) {
        this.curve = curve;
        this.x = x;
        this.y = y;
    }

    public ECFieldElement getX() {
        return this.x;
    }

    public ECFieldElement getY() {
        return this.y;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ECPoint)) {
            return false;
        }
        ECPoint o = (ECPoint)other;
        return this.x.equals(o.x) && this.y.equals(o.y);
    }

    public abstract byte[] getEncoded();

    public abstract ECPoint add(ECPoint var1);

    public abstract ECPoint subtract(ECPoint var1);

    public abstract ECPoint twice();

    public abstract ECPoint multiply(BigInteger var1);

    public static class Fp
    extends ECPoint {
        public Fp(ECCurve curve, ECFieldElement x, ECFieldElement y) {
            super(curve, x, y);
        }

        public byte[] getEncoded() {
            int PC = this.getY().toBigInteger().testBit(0) ? 2 : 3;
            byte[] X = this.getX().toBigInteger().toByteArray();
            byte[] PO = new byte[X.length + 1];
            PO[0] = PC;
            System.arraycopy(X, 0, PO, 1, X.length);
            return PO;
        }

        public ECPoint add(ECPoint b) {
            ECFieldElement gamma = b.y.subtract(this.y).divide(b.x.subtract(this.x));
            ECFieldElement x3 = gamma.multiply(gamma).subtract(this.x).subtract(b.x);
            ECFieldElement y3 = gamma.multiply(this.x.subtract(x3)).subtract(this.y);
            return new Fp(this.curve, x3, y3);
        }

        public ECPoint twice() {
            ECFieldElement TWO = this.curve.fromBigInteger(BigInteger.valueOf(2L));
            ECFieldElement THREE = this.curve.fromBigInteger(BigInteger.valueOf(3L));
            ECFieldElement gamma = this.x.multiply(this.x).multiply(THREE).add(this.curve.a).divide(this.y.multiply(TWO));
            ECFieldElement x3 = gamma.multiply(gamma).subtract(this.x.multiply(TWO));
            ECFieldElement y3 = gamma.multiply(this.x.subtract(x3)).subtract(this.y);
            return new Fp(this.curve, x3, y3);
        }

        public ECPoint subtract(ECPoint p2) {
            return this.add(new Fp(this.curve, p2.x, p2.y.negate()));
        }

        public ECPoint multiply(BigInteger k) {
            BigInteger e = k;
            BigInteger h = e.multiply(BigInteger.valueOf(3L));
            ECPoint R = this;
            int i = h.bitLength() - 2;
            while (i > 0) {
                R = R.twice();
                if (h.testBit(i) && !e.testBit(i)) {
                    R = R.add(this);
                } else if (!h.testBit(i) && e.testBit(i)) {
                    R = R.subtract(this);
                }
                --i;
            }
            return R;
        }
    }
}

