/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl.access.impl;

import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.util.SystemTime;

public class DiskManagerRequestImpl
implements DiskManagerReadRequest {
    private static final int EXPIRATION_TIME = 60000;
    private int pieceNumber;
    private int offset;
    private int length;
    private long timeCreated;
    private final int hashcode;

    public DiskManagerRequestImpl(int _pieceNumber, int _offset, int _length) {
        this.pieceNumber = _pieceNumber;
        this.offset = _offset;
        this.length = _length;
        this.timeCreated = SystemTime.getCurrentTime();
        this.hashcode = this.pieceNumber + this.offset + this.length;
    }

    public boolean isExpired() {
        long wait_time = SystemTime.getCurrentTime() - this.timeCreated;
        if (wait_time < 0L) {
            this.timeCreated = SystemTime.getCurrentTime();
            return false;
        }
        return wait_time > 60000L;
    }

    public void reSetTime() {
        this.timeCreated = SystemTime.getCurrentTime();
    }

    public int getPieceNumber() {
        return this.pieceNumber;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DiskManagerRequestImpl)) {
            return false;
        }
        DiskManagerRequestImpl otherRequest = (DiskManagerRequestImpl)o;
        if (otherRequest.pieceNumber != this.pieceNumber) {
            return false;
        }
        if (otherRequest.offset != this.offset) {
            return false;
        }
        return otherRequest.length == this.length;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public long getTimeCreated() {
        return this.timeCreated;
    }
}

