/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.download.impl;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.download.DownloadManagerStateEvent;
import org.gudy.azureus2.core3.download.DownloadManagerStateListener;
import org.gudy.azureus2.core3.download.impl.DownloadManagerImpl;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerClient;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.TorrentUtils;

public class DownloadManagerStateImpl
implements DownloadManagerState {
    private static final String RESUME_KEY = "resume";
    private static final String TRACKER_CACHE_KEY = "tracker_cache";
    private static final String ATTRIBUTE_KEY = "attributes";
    private static final File ACTIVE_DIR = FileUtil.getUserFile("active");
    private static AEMonitor class_mon;
    private static Map state_map;
    private DownloadManagerImpl download_manager;
    private TOTorrent torrent;
    private boolean write_required;
    private Map tracker_response_cache = new HashMap();
    private Category category;
    private List listeners = new ArrayList();
    private AEMonitor this_mon = new AEMonitor("DownloadManagerState");

    static {
        if (!ACTIVE_DIR.exists()) {
            ACTIVE_DIR.mkdirs();
        }
        class_mon = new AEMonitor("DownloadManagerState:class");
        state_map = new HashMap();
    }

    private static DownloadManagerState getDownloadState(DownloadManagerImpl download_manager, TOTorrent original_torrent, TOTorrent target_torrent) throws TOTorrentException {
        byte[] hash = target_torrent.getHash();
        DownloadManagerStateImpl res = null;
        try {
            class_mon.enter();
            HashWrapper hash_wrapper = new HashWrapper(hash);
            res = (DownloadManagerStateImpl)state_map.get(hash_wrapper);
            if (res == null) {
                res = new DownloadManagerStateImpl(download_manager, target_torrent);
                state_map.put(hash_wrapper, res);
            } else {
                if (res.getDownloadManager() == null && download_manager != null) {
                    res.setDownloadManager(download_manager);
                }
                if (original_torrent != null) {
                    res.mergeTorrentDetails(original_torrent);
                }
            }
        }
        finally {
            class_mon.exit();
        }
        return res;
    }

    public static DownloadManagerState getDownloadState(TOTorrent original_torrent) throws TOTorrentException {
        byte[] torrent_hash = original_torrent.getHash();
        TOTorrent saved_state = null;
        File saved_file = DownloadManagerStateImpl.getStateFile(torrent_hash);
        if (saved_file.exists()) {
            try {
                saved_state = TorrentUtils.readFromFile(saved_file, true);
            }
            catch (Throwable e) {
                Debug.out("Failed to load download state for " + saved_file);
            }
        }
        if (saved_state == null) {
            TorrentUtils.copyToFile(original_torrent, saved_file);
            saved_state = TorrentUtils.readFromFile(saved_file, true);
        }
        return DownloadManagerStateImpl.getDownloadState(null, original_torrent, saved_state);
    }

    protected static DownloadManagerState getDownloadState(DownloadManagerImpl download_manager, String torrent_file, byte[] torrent_hash) throws TOTorrentException {
        File saved_file;
        TOTorrent original_torrent = null;
        TOTorrent saved_state = null;
        if (torrent_hash != null && (saved_file = DownloadManagerStateImpl.getStateFile(torrent_hash)).exists()) {
            try {
                saved_state = TorrentUtils.readFromFile(saved_file, true);
            }
            catch (Throwable e) {
                Debug.out("Failed to load download state for " + saved_file);
            }
        }
        if (saved_state == null) {
            original_torrent = TorrentUtils.readFromFile(new File(torrent_file), true);
            torrent_hash = original_torrent.getHash();
            saved_file = DownloadManagerStateImpl.getStateFile(torrent_hash);
            if (saved_file.exists()) {
                try {
                    saved_state = TorrentUtils.readFromFile(saved_file, true);
                }
                catch (Throwable e) {
                    Debug.out("Failed to load download state for " + saved_file);
                }
            }
            if (saved_state == null) {
                TorrentUtils.copyToFile(original_torrent, saved_file);
                saved_state = TorrentUtils.readFromFile(saved_file, true);
            }
        }
        return DownloadManagerStateImpl.getDownloadState(download_manager, original_torrent, saved_state);
    }

    protected static File getStateFile(byte[] torrent_hash) {
        return new File(ACTIVE_DIR, String.valueOf(ByteFormatter.encodeString(torrent_hash)) + ".dat");
    }

    protected DownloadManagerStateImpl(DownloadManagerImpl _download_manager, TOTorrent _torrent) {
        Category cat;
        String cat_string;
        this.download_manager = _download_manager;
        this.torrent = _torrent;
        String[] map_types = new String[]{RESUME_KEY, TRACKER_CACHE_KEY, ATTRIBUTE_KEY};
        int i = 0;
        while (i < map_types.length) {
            String map_type = map_types[i];
            Object attribute_key = this.torrent.getAdditionalProperty(map_type);
            if (attribute_key != null && !(attribute_key instanceof Map)) {
                Debug.out("Invalid state entry type for '" + map_type + "'");
                this.torrent.removeAdditionalProperty(map_type);
            }
            ++i;
        }
        this.tracker_response_cache = this.torrent.getAdditionalMapProperty(TRACKER_CACHE_KEY);
        if (this.tracker_response_cache == null) {
            this.tracker_response_cache = new HashMap();
        }
        if ((cat_string = this.getStringAttribute("category")) != null && (cat = CategoryManager.getCategory(cat_string)) != null) {
            this.setCategory(cat);
        }
    }

    public DownloadManager getDownloadManager() {
        return this.download_manager;
    }

    protected void setDownloadManager(DownloadManagerImpl dm) {
        this.download_manager = dm;
    }

    public void clearTrackerResponseCache() {
        this.setTrackerResponseCache(new HashMap());
    }

    public Map getTrackerResponseCache() {
        return this.tracker_response_cache;
    }

    public void setTrackerResponseCache(Map value) {
        try {
            boolean changed;
            this.this_mon.enter();
            boolean bl = changed = !BEncoder.mapsAreIdentical(value, this.tracker_response_cache);
            if (changed) {
                this.write_required = true;
                this.tracker_response_cache = value;
                this.torrent.setAdditionalMapProperty(TRACKER_CACHE_KEY, this.tracker_response_cache);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public Map getResumeData() {
        return this.torrent.getAdditionalMapProperty(RESUME_KEY);
    }

    public void clearResumeData() {
        this.setResumeData(null);
    }

    public void setResumeData(Map data) {
        try {
            this.this_mon.enter();
            if (data == null) {
                this.torrent.removeAdditionalProperty(RESUME_KEY);
            } else {
                this.torrent.setAdditionalMapProperty(RESUME_KEY, data);
            }
            this.write_required = true;
        }
        finally {
            this.this_mon.exit();
        }
    }

    public TOTorrent getTorrent() {
        return this.torrent;
    }

    public void save() {
        boolean do_write;
        try {
            this.this_mon.enter();
            do_write = this.write_required;
            this.write_required = false;
        }
        finally {
            this.this_mon.exit();
        }
        if (do_write) {
            try {
                LGLogger.log("Saving state for download '" + TorrentUtils.getLocalisedName(this.torrent) + "'");
                TorrentUtils.writeToFile(this.torrent, true);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void delete() {
        try {
            try {
                class_mon.enter();
                state_map.remove(this.torrent.getHashWrapper());
                TorrentUtils.delete(this.torrent);
            }
            catch (TOTorrentException e) {
                Debug.printStackTrace(e);
            }
        }
        finally {
            class_mon.exit();
        }
    }

    protected void mergeTorrentDetails(TOTorrent other_torrent) {
        try {
            boolean write = TorrentUtils.mergeAnnounceURLs(other_torrent, this.torrent);
            if (write) {
                TRTrackerClient client;
                this.save();
                if (this.download_manager != null && (client = this.download_manager.getTrackerClient()) != null) {
                    client.resetTrackerUrl(false);
                }
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public void setAttribute(String name, String value) {
        if (name.equals("category")) {
            if (value == null) {
                this.setCategory(null);
            } else {
                Category cat = CategoryManager.getCategory(value);
                if (cat == null) {
                    cat = CategoryManager.createCategory(value);
                }
                this.setCategory(cat);
            }
        } else {
            this.setStringAttribute(name, value);
        }
    }

    public String getAttribute(String name) {
        if (name.equals("category")) {
            Category cat = this.getCategory();
            if (cat == null) {
                return null;
            }
            if (cat == CategoryManager.getCategory(2)) {
                return null;
            }
            return cat.getName();
        }
        return this.getStringAttribute(name);
    }

    public Category getCategory() {
        return this.category;
    }

    public void setCategory(Category cat) {
        if (cat == this.category) {
            return;
        }
        if (cat != null && cat.getType() != 0) {
            cat = null;
        }
        Category oldCategory = this.category == null ? CategoryManager.getCategory(2) : this.category;
        this.category = cat;
        if (oldCategory != null) {
            oldCategory.removeManager(this);
        }
        if (this.category != null) {
            this.category.addManager(this);
        }
        if (this.category != null && this.category.getType() == 0) {
            this.setStringAttribute("category", this.category.getName());
        } else {
            this.setStringAttribute("category", null);
        }
    }

    protected String getStringAttribute(String attribute_name) {
        Map attributes = this.torrent.getAdditionalMapProperty(ATTRIBUTE_KEY);
        if (attributes == null) {
            return null;
        }
        byte[] bytes = (byte[])attributes.get(attribute_name);
        if (bytes == null) {
            return null;
        }
        try {
            return new String(bytes, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    protected void setStringAttribute(final String attribute_name, String attribute_value) {
        HashMap<String, byte[]> attributes = this.torrent.getAdditionalMapProperty(ATTRIBUTE_KEY);
        if (attributes == null) {
            if (attribute_value == null) {
                return;
            }
            attributes = new HashMap<String, byte[]>();
            this.torrent.setAdditionalMapProperty(ATTRIBUTE_KEY, attributes);
        }
        boolean changed = false;
        if (attribute_value == null) {
            if (attributes.containsKey(attribute_name)) {
                attributes.remove(attribute_name);
                changed = true;
            }
        } else {
            try {
                byte[] existing_bytes = (byte[])attributes.get(attribute_name);
                byte[] new_bytes = attribute_value.getBytes("UTF8");
                if (existing_bytes == null || !Arrays.equals(existing_bytes, new_bytes)) {
                    attributes.put(attribute_name, new_bytes);
                    changed = true;
                }
            }
            catch (UnsupportedEncodingException e) {
                Debug.printStackTrace(e);
            }
        }
        if (changed) {
            this.write_required = true;
            int i = 0;
            while (i < this.listeners.size()) {
                try {
                    ((DownloadManagerStateListener)this.listeners.get(i)).stateChanged(this, new DownloadManagerStateEvent(){

                        public int getType() {
                            return 1;
                        }

                        public Object getData() {
                            return attribute_name;
                        }
                    });
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                ++i;
            }
        }
    }

    public static DownloadManagerState getDownloadState(DownloadManager dm) {
        return new nullState(dm);
    }

    public void addListener(DownloadManagerStateListener l) {
        this.listeners.add(l);
    }

    public void removeListener(DownloadManagerStateListener l) {
        this.listeners.remove(l);
    }

    protected static class nullState
    implements DownloadManagerState {
        protected DownloadManager download_manager;

        protected nullState(DownloadManager _dm) {
            this.download_manager = _dm;
        }

        public TOTorrent getTorrent() {
            return null;
        }

        public DownloadManager getDownloadManager() {
            return this.download_manager;
        }

        public void clearResumeData() {
        }

        public Map getResumeData() {
            return new HashMap();
        }

        public void setResumeData(Map data) {
        }

        public void clearTrackerResponseCache() {
        }

        public Map getTrackerResponseCache() {
            return new HashMap();
        }

        public void setTrackerResponseCache(Map value) {
        }

        public void setAttribute(String name, String value) {
        }

        public String getAttribute(String name) {
            return null;
        }

        public Category getCategory() {
            return null;
        }

        public void setCategory(Category cat) {
        }

        public void save() {
        }

        public void delete() {
        }

        public void addListener(DownloadManagerStateListener l) {
        }

        public void removeListener(DownloadManagerStateListener l) {
        }
    }
}

