/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.peer.impl.transport.base;

import java.io.IOException;
import java.nio.channels.SocketChannel;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransportDataReader;
import org.gudy.azureus2.core3.peer.impl.transport.base.DataReaderOwner;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.SystemTime;

public class DataReaderSpeedLimiter {
    protected final int slot_period_millis = 25;
    protected final int slot_count = 40;
    protected int bytes_per_second = 0;
    protected int bytes_per_slot;
    protected long current_slot;
    protected int bytes_available;
    protected AEMonitor this_mon = new AEMonitor("DataReaderSpeedLimiter");
    protected static DataReaderSpeedLimiter singleton = new DataReaderSpeedLimiter();

    public static DataReaderSpeedLimiter getSingleton() {
        return singleton;
    }

    protected DataReaderSpeedLimiter() {
        COConfigurationManager.addParameterListener("Max Download Speed KBs", new ParameterListener(){

            public void parameterChanged(String str) {
                DataReaderSpeedLimiter.this.bytes_per_second = COConfigurationManager.getIntParameter("Max Download Speed KBs", 0) * 1024;
                DataReaderSpeedLimiter.this.bytes_per_slot = DataReaderSpeedLimiter.this.bytes_per_second / 40;
            }
        });
        this.bytes_per_second = COConfigurationManager.getIntParameter("Max Download Speed KBs", 0) * 1024;
        this.bytes_per_slot = this.bytes_per_second / 40;
    }

    public PEPeerTransportDataReader getDataReader(DataReaderOwner owner) {
        return new limitedDataReader(owner);
    }

    protected class unlimitedDataReader
    implements PEPeerTransportDataReader {
        protected unlimitedDataReader() {
        }

        public int read(SocketChannel channel, DirectByteBuffer direct_buffer) throws IOException {
            return direct_buffer.read((byte)9, channel);
        }
    }

    protected class limitedDataReader
    implements PEPeerTransportDataReader {
        protected DataReaderOwner owner;
        protected long my_current_slot;
        protected int my_bytes_available;

        protected limitedDataReader(DataReaderOwner _owner) {
            this.owner = _owner;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int read(SocketChannel channel, DirectByteBuffer direct_buffer) throws IOException {
            int my_bytes_per_second = this.owner.getMaximumBytesPerSecond();
            if (DataReaderSpeedLimiter.this.bytes_per_second == 0 && my_bytes_per_second == 0) {
                return direct_buffer.read((byte)9, channel);
            }
            int position = direct_buffer.position((byte)9);
            int limit = direct_buffer.limit((byte)9);
            int bytes_allocated = 0;
            int debug_max_bytes = -1;
            int debug_limit = -1;
            try {
                try {
                    DataReaderSpeedLimiter.this.this_mon.enter();
                    long now = SystemTime.getCurrentTime();
                    long new_slot = now / 25L;
                    if (DataReaderSpeedLimiter.this.bytes_per_second > 0) {
                        long slots = new_slot - DataReaderSpeedLimiter.this.current_slot;
                        DataReaderSpeedLimiter.this.current_slot = new_slot;
                        if (slots < 0L) {
                            DataReaderSpeedLimiter.this.this_mon.exit();
                            return 0;
                        }
                        if (slots > 40L) {
                            slots = 40L;
                        }
                        DataReaderSpeedLimiter.this.bytes_available = (int)((long)DataReaderSpeedLimiter.this.bytes_available + slots * (long)DataReaderSpeedLimiter.this.bytes_per_slot);
                        if (DataReaderSpeedLimiter.this.bytes_available > 3 * DataReaderSpeedLimiter.this.bytes_per_second) {
                            DataReaderSpeedLimiter.this.bytes_available = 3 * DataReaderSpeedLimiter.this.bytes_per_second;
                        }
                        if (DataReaderSpeedLimiter.this.bytes_available == 0) {
                            DataReaderSpeedLimiter.this.this_mon.exit();
                            return 0;
                        }
                    } else {
                        DataReaderSpeedLimiter.this.bytes_available = 0;
                    }
                    if (my_bytes_per_second > 0) {
                        long my_slots = new_slot - this.my_current_slot;
                        this.my_current_slot = new_slot;
                        if (my_slots < 0L) {
                            DataReaderSpeedLimiter.this.this_mon.exit();
                            return 0;
                        }
                        if (my_slots > 40L) {
                            my_slots = 40L;
                        }
                        int my_bytes_per_slot = my_bytes_per_second / 40;
                        this.my_bytes_available = (int)((long)this.my_bytes_available + my_slots * (long)my_bytes_per_slot);
                        if (this.my_bytes_available > 3 * my_bytes_per_second) {
                            this.my_bytes_available = 3 * my_bytes_per_second;
                        }
                        if (this.my_bytes_available == 0) {
                            DataReaderSpeedLimiter.this.this_mon.exit();
                            return 0;
                        }
                    } else {
                        this.my_bytes_available = 0;
                    }
                    int max_bytes = DataReaderSpeedLimiter.this.bytes_available == 0 && this.my_bytes_available == 0 ? 0 : (DataReaderSpeedLimiter.this.bytes_available == 0 ? this.my_bytes_available : (this.my_bytes_available == 0 ? DataReaderSpeedLimiter.this.bytes_available : (DataReaderSpeedLimiter.this.bytes_available < this.my_bytes_available ? DataReaderSpeedLimiter.this.bytes_available : this.my_bytes_available)));
                    int request_read_size = limit - position;
                    debug_max_bytes = max_bytes;
                    if (max_bytes != 0 && request_read_size > max_bytes) {
                        debug_limit = position + max_bytes;
                        direct_buffer.limit((byte)9, position + max_bytes);
                        bytes_allocated = max_bytes;
                    } else {
                        bytes_allocated = request_read_size;
                    }
                    this.my_bytes_available -= bytes_allocated;
                    if (this.my_bytes_available < 0) {
                        this.my_bytes_available = 0;
                    }
                    DataReaderSpeedLimiter.this.bytes_available -= bytes_allocated;
                    if (DataReaderSpeedLimiter.this.bytes_available < 0) {
                        DataReaderSpeedLimiter.this.bytes_available = 0;
                    }
                }
                finally {
                    DataReaderSpeedLimiter.this.this_mon.exit();
                }
                int bytes_read = 0;
                try {
                    int n = bytes_read = direct_buffer.read((byte)9, channel);
                    if (bytes_read < bytes_allocated) {
                        try {
                            DataReaderSpeedLimiter.this.this_mon.enter();
                            DataReaderSpeedLimiter.this.bytes_available += bytes_allocated - bytes_read;
                            this.my_bytes_available += bytes_allocated - bytes_read;
                        }
                        finally {
                            DataReaderSpeedLimiter.this.this_mon.exit();
                        }
                    }
                    direct_buffer.limit((byte)9, limit);
                    return n;
                }
                catch (Throwable throwable) {
                    if (bytes_read < bytes_allocated) {
                        try {
                            DataReaderSpeedLimiter.this.this_mon.enter();
                            DataReaderSpeedLimiter.this.bytes_available += bytes_allocated - bytes_read;
                            this.my_bytes_available += bytes_allocated - bytes_read;
                        }
                        finally {
                            DataReaderSpeedLimiter.this.this_mon.exit();
                        }
                    }
                    direct_buffer.limit((byte)9, limit);
                    throw throwable;
                }
            }
            catch (IllegalArgumentException e) {
                System.out.println("Illegal arg exception");
                System.out.println("buffer: " + direct_buffer.position((byte)9) + "/" + direct_buffer.limit((byte)9));
                System.out.println("    start values:" + position + "/" + limit);
                System.out.println("    alloc = " + bytes_allocated + ", ba = " + DataReaderSpeedLimiter.this.bytes_available + ", mba = " + this.my_bytes_available);
                System.out.println("    max_bytes = " + debug_max_bytes + ", limit = " + debug_limit);
                throw e;
            }
        }
    }
}

