/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import org.gudy.azureus2.core3.util.SystemTime;

public class Average {
    private int refreshRate;
    private int period;
    private int nbElements;
    private long lastUpdate;
    private long[] values;

    private Average(int _refreshRate, int _period) {
        this.refreshRate = _refreshRate;
        this.period = _period;
        this.nbElements = _period * 1000 / _refreshRate + 2;
        this.lastUpdate = SystemTime.getCurrentTime() / (long)_refreshRate;
        this.values = new long[this.nbElements];
    }

    public static Average getInstance(int refreshRate, int period) {
        if (refreshRate < 100) {
            return null;
        }
        if (period * 1000 < refreshRate) {
            return null;
        }
        return new Average(refreshRate, period);
    }

    private synchronized void update(long timeFactor) {
        if (this.lastUpdate < timeFactor - (long)this.nbElements) {
            this.lastUpdate = timeFactor - (long)this.nbElements - 1L;
        }
        long i = this.lastUpdate + 1L;
        while (i < timeFactor) {
            this.values[(int)(i % (long)this.nbElements)] = 0L;
            ++i;
        }
        this.values[(int)((timeFactor + 1L) % (long)this.nbElements)] = 0L;
        this.lastUpdate = timeFactor;
    }

    public void addValue(long value) {
        long timeFactor = SystemTime.getCurrentTime() / (long)this.refreshRate;
        this.update(timeFactor);
        int n = (int)(timeFactor % (long)this.nbElements);
        this.values[n] = this.values[n] + value;
    }

    public long getAverage() {
        long timeFactor = SystemTime.getCurrentTime() / (long)this.refreshRate;
        this.update(timeFactor);
        long sum = 0L;
        long i = timeFactor + 2L;
        while (i < timeFactor + (long)this.nbElements) {
            sum += this.values[(int)(i % (long)this.nbElements)];
            ++i;
        }
        return sum / (long)this.period;
    }
}

