/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

public class TimeFormatter {
    public static String format(long time) {
        if (time >= 31536000L) {
            return "\u221e";
        }
        int secs = (int)time % 60;
        int mins = (int)(time / 60L) % 60;
        int hours = (int)(time / 3600L) % 24;
        int days = (int)(time / 86400L);
        String result = "";
        if (days > 0) {
            result = String.valueOf(days) + "d ";
        }
        if (hours > 0 || days > 0) {
            result = String.valueOf(result) + hours + "h ";
        }
        if (days == 0 && (mins > 0 || hours > 0) && mins < 10) {
            result = String.valueOf(result) + "0" + mins + "m ";
        }
        if (days == 0 && (mins > 0 || hours > 0) && mins >= 10) {
            result = String.valueOf(result) + mins + "m ";
        }
        if (hours == 0 && days == 0 && (secs > 0 || mins > 0) && secs < 10) {
            result = String.valueOf(result) + "0" + secs + "s ";
        }
        if (hours == 0 && days == 0 && (secs > 0 || mins > 0) && secs >= 10) {
            result = String.valueOf(result) + secs + "s ";
        }
        return result.length() == 0 ? "" : result.substring(0, result.length() - 1);
    }

    public static String formatColon(long time) {
        if (time >= 31536000L) {
            return "\u221e";
        }
        if (time < 0L) {
            return "";
        }
        int secs = (int)time % 60;
        int mins = (int)(time / 60L) % 60;
        int hours = (int)(time / 3600L) % 24;
        int days = (int)(time / 86400L);
        String result = "";
        if (days > 0) {
            result = String.valueOf(days) + "d ";
        }
        result = String.valueOf(result) + TimeFormatter.twoDigits(hours) + ":" + TimeFormatter.twoDigits(mins) + ":" + TimeFormatter.twoDigits(secs);
        return result;
    }

    private static String twoDigits(int i) {
        return i < 10 ? "0" + i : String.valueOf(i);
    }
}

