/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ui.config;

import java.util.HashMap;
import java.util.Set;
import org.gudy.azureus2.core3.config.impl.ConfigurationDefaults;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.pluginsimpl.local.ui.config.BooleanParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ColorParameter;
import org.gudy.azureus2.pluginsimpl.local.ui.config.DirectoryParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.FileParameter;
import org.gudy.azureus2.pluginsimpl.local.ui.config.IntParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.IntsParameter;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.StringListParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.StringParameterImpl;

public class ParameterRepository {
    private static ParameterRepository instance;
    private static AEMonitor class_mon;
    private HashMap params = new HashMap();

    static {
        class_mon = new AEMonitor("ParameterRepository:class");
    }

    private ParameterRepository() {
    }

    public static ParameterRepository getInstance() {
        try {
            class_mon.enter();
            if (instance == null) {
                instance = new ParameterRepository();
            }
            ParameterRepository parameterRepository = instance;
            class_mon.exit();
            return parameterRepository;
        }
        catch (Throwable throwable) {
            class_mon.exit();
            throw throwable;
        }
    }

    public void addPlugin(Parameter[] parameters, String displayName) {
        this.params.put(displayName, parameters);
        ConfigurationDefaults def = ConfigurationDefaults.getInstance();
        if (def == null) {
            return;
        }
        int i = 0;
        while (i < parameters.length) {
            Parameter parameter = parameters[i];
            if (parameter instanceof ParameterImpl) {
                String sKey = ((ParameterImpl)parameter).getKey();
                if (parameter instanceof StringParameterImpl) {
                    def.addParameter(sKey, ((StringParameterImpl)parameter).getDefaultValue());
                } else if (parameter instanceof IntParameterImpl) {
                    def.addParameter(sKey, ((IntParameterImpl)parameter).getDefaultValue());
                } else if (parameter instanceof BooleanParameterImpl) {
                    def.addParameter(sKey, ((BooleanParameterImpl)parameter).getDefaultValue());
                } else if (parameter instanceof FileParameter) {
                    def.addParameter(sKey, ((FileParameter)parameter).getDefaultValue());
                } else if (parameter instanceof DirectoryParameterImpl) {
                    def.addParameter(sKey, ((DirectoryParameterImpl)parameter).getDefaultValue());
                } else if (parameter instanceof IntsParameter) {
                    def.addParameter(sKey, ((IntsParameter)parameter).getDefaultValue());
                } else if (parameter instanceof StringListParameterImpl) {
                    def.addParameter(sKey, ((StringListParameterImpl)parameter).getDefaultValue());
                } else if (parameter instanceof ColorParameter) {
                    def.addParameter(String.valueOf(sKey) + ".red", ((ColorParameter)parameter).getDefaultRed());
                    def.addParameter(String.valueOf(sKey) + ".green", ((ColorParameter)parameter).getDefaultGreen());
                    def.addParameter(String.valueOf(sKey) + ".blue", ((ColorParameter)parameter).getDefaultBlue());
                }
            }
            ++i;
        }
    }

    public String[] getNames() {
        Set keys = this.params.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    public Parameter[] getParameterBlock(String key) {
        return (Parameter[])this.params.get(key);
    }
}

