/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.update;

import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.update.UpdatableComponent;
import org.gudy.azureus2.plugins.update.Update;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.update.UpdateCheckInstanceListener;
import org.gudy.azureus2.plugins.update.UpdateChecker;
import org.gudy.azureus2.plugins.update.UpdateException;
import org.gudy.azureus2.plugins.update.UpdateInstaller;
import org.gudy.azureus2.plugins.update.UpdateManager;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.pluginsimpl.local.update.UpdatableComponentImpl;
import org.gudy.azureus2.pluginsimpl.local.update.UpdateCheckerImpl;
import org.gudy.azureus2.pluginsimpl.local.update.UpdateImpl;

public class UpdateCheckInstanceImpl
implements UpdateCheckInstance {
    protected List listeners = new ArrayList();
    protected List updates = new ArrayList();
    protected AESemaphore sem = new AESemaphore("UpdateCheckInstance");
    protected UpdateManager manager;
    protected int check_type;
    protected String name;
    protected UpdatableComponentImpl[] components;
    protected UpdateCheckerImpl[] checkers;
    protected boolean completed;
    protected boolean cancelled;
    protected AEMonitor this_mon = new AEMonitor("UpdateCheckInstance");

    protected UpdateCheckInstanceImpl(UpdateManager _manager, int _check_type, String _name, UpdatableComponentImpl[] _components) {
        this.manager = _manager;
        this.check_type = _check_type;
        this.name = _name;
        this.components = _components;
        this.checkers = new UpdateCheckerImpl[this.components.length];
        int i = 0;
        while (i < this.components.length) {
            UpdatableComponentImpl comp = this.components[i];
            this.checkers[i] = new UpdateCheckerImpl(this, comp, this.sem);
            ++i;
        }
    }

    public int getType() {
        return this.check_type;
    }

    public String getName() {
        return this.name;
    }

    public void addUpdatableComponent(UpdatableComponent component, boolean mandatory) {
        UpdatableComponentImpl comp = new UpdatableComponentImpl(component, mandatory);
        UpdatableComponentImpl[] new_comps = new UpdatableComponentImpl[this.components.length + 1];
        System.arraycopy(this.components, 0, new_comps, 0, this.components.length);
        new_comps[this.components.length] = comp;
        this.components = new_comps;
        UpdateCheckerImpl checker = new UpdateCheckerImpl(this, comp, this.sem);
        UpdateCheckerImpl[] new_checkers = new UpdateCheckerImpl[this.checkers.length + 1];
        System.arraycopy(this.checkers, 0, new_checkers, 0, this.checkers.length);
        new_checkers[this.checkers.length] = checker;
        this.checkers = new_checkers;
    }

    public void start() {
        int i = 0;
        while (i < this.components.length) {
            final UpdateCheckerImpl checker = this.checkers[i];
            AEThread t = new AEThread("UpdatableComponent Checker:" + i){

                public void runSupport() {
                    try {
                        checker.getComponent().checkForUpdate(checker);
                    }
                    catch (Throwable e) {
                        checker.failed();
                    }
                }
            };
            t.setDaemon(true);
            t.start();
            ++i;
        }
        AEThread t = new AEThread("UpdatableComponent Completion Waiter"){

            public void runSupport() {
                int i = 0;
                while (i < UpdateCheckInstanceImpl.this.components.length) {
                    UpdateCheckInstanceImpl.this.sem.reserve();
                    ++i;
                }
                try {
                    UpdateCheckInstanceImpl.this.this_mon.enter();
                    if (UpdateCheckInstanceImpl.this.cancelled) {
                        UpdateCheckInstanceImpl.this.this_mon.exit();
                        return;
                    }
                    UpdateCheckInstanceImpl.this.completed = true;
                }
                finally {
                    UpdateCheckInstanceImpl.this.this_mon.exit();
                }
                boolean mandatory_failed = false;
                int i2 = 0;
                while (i2 < UpdateCheckInstanceImpl.this.checkers.length) {
                    if (UpdateCheckInstanceImpl.this.components[i2].isMandatory() && UpdateCheckInstanceImpl.this.checkers[i2].getFailed()) {
                        mandatory_failed = true;
                        break;
                    }
                    ++i2;
                }
                ArrayList<UpdateImpl> target_updates = new ArrayList<UpdateImpl>();
                if (mandatory_failed) {
                    LGLogger.log("Dropping all updates as a mandatory update check failed");
                } else {
                    UpdateImpl update;
                    boolean mandatory_only = false;
                    int i3 = 0;
                    while (i3 < UpdateCheckInstanceImpl.this.updates.size()) {
                        update = (UpdateImpl)UpdateCheckInstanceImpl.this.updates.get(i3);
                        if (update.isMandatory()) {
                            mandatory_only = true;
                            break;
                        }
                        ++i3;
                    }
                    i3 = 0;
                    while (i3 < UpdateCheckInstanceImpl.this.updates.size()) {
                        update = (UpdateImpl)UpdateCheckInstanceImpl.this.updates.get(i3);
                        if (update.isMandatory() || !mandatory_only) {
                            target_updates.add(update);
                        } else {
                            LGLogger.log("Dropping update '" + update.getName() + "' as non-mandatory and mandatory updates found");
                        }
                        ++i3;
                    }
                }
                UpdateCheckInstanceImpl.this.updates = target_updates;
                int i4 = 0;
                while (i4 < UpdateCheckInstanceImpl.this.listeners.size()) {
                    try {
                        ((UpdateCheckInstanceListener)UpdateCheckInstanceImpl.this.listeners.get(i4)).complete(UpdateCheckInstanceImpl.this);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                    ++i4;
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    protected UpdateImpl addUpdate(UpdatableComponentImpl comp, String update_name, String[] desc, String new_version, ResourceDownloader[] downloaders, int restart_required) {
        try {
            this.this_mon.enter();
            UpdateImpl update = new UpdateImpl(update_name, desc, new_version, downloaders, comp.isMandatory(), restart_required);
            this.updates.add(update);
            if (this.cancelled) {
                update.cancel();
            }
            UpdateImpl updateImpl = update;
            this.this_mon.exit();
            return updateImpl;
        }
        catch (Throwable throwable) {
            this.this_mon.exit();
            throw throwable;
        }
    }

    public Update[] getUpdates() {
        try {
            this.this_mon.enter();
            Update[] res = new Update[this.updates.size()];
            this.updates.toArray(res);
            Update[] updateArray = res;
            this.this_mon.exit();
            return updateArray;
        }
        catch (Throwable throwable) {
            this.this_mon.exit();
            throw throwable;
        }
    }

    public UpdateChecker[] getCheckers() {
        return this.checkers;
    }

    public UpdateInstaller createInstaller() throws UpdateException {
        return this.manager.createInstaller();
    }

    public void cancel() {
        boolean just_do_updates = false;
        try {
            this.this_mon.enter();
            if (this.completed) {
                just_do_updates = true;
            }
            this.cancelled = true;
        }
        finally {
            this.this_mon.exit();
        }
        int i = 0;
        while (i < this.updates.size()) {
            ((UpdateImpl)this.updates.get(i)).cancel();
            ++i;
        }
        if (!just_do_updates) {
            i = 0;
            while (i < this.checkers.length) {
                if (this.checkers[i] != null) {
                    this.checkers[i].cancel();
                }
                ++i;
            }
            i = 0;
            while (i < this.listeners.size()) {
                try {
                    ((UpdateCheckInstanceListener)this.listeners.get(i)).cancelled(this);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                ++i;
            }
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public UpdateManager getManager() {
        return this.manager;
    }

    public void addListener(UpdateCheckInstanceListener l) {
        this.listeners.add(l);
        if (this.completed) {
            l.complete(this);
        } else if (this.cancelled) {
            l.cancelled(this);
        }
    }

    public void removeListener(UpdateCheckInstanceListener l) {
        this.listeners.remove(l);
    }
}

