/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import com.aelitis.azureus.core.AzureusCore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.StringIterator;
import org.gudy.azureus2.core3.config.StringList;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.ui.swt.FileDownloadWindow;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Utils;

public class OpenUrlWindow {
    protected static String CONFIG_REFERRER_DEFAULT = "openUrl.referrer.default";
    protected static String last_referrer = null;

    static {
        last_referrer = COConfigurationManager.getStringParameter(CONFIG_REFERRER_DEFAULT, "");
    }

    public OpenUrlWindow(final AzureusCore azureus_core, final Display display, String linkURL, String referrer) {
        final Shell shell = new Shell(display, 67680);
        shell.setText(MessageText.getString("openUrl.title"));
        if (!Constants.isOSX) {
            shell.setImage(ImageRepository.getImage("azureus"));
        }
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        shell.setLayout((Layout)layout);
        Label label = new Label((Composite)shell, 0);
        label.setText(MessageText.getString("openUrl.url"));
        GridData gridData = new GridData();
        label.setLayoutData((Object)gridData);
        final Text url = new Text((Composite)shell, 2048);
        gridData = new GridData();
        gridData.widthHint = 400;
        gridData.horizontalSpan = 2;
        url.setLayoutData((Object)gridData);
        if (linkURL == null) {
            Utils.setTextLinkFromClipboard(shell, gridData, url);
        } else {
            Utils.setTextLink(shell, gridData, url, linkURL);
        }
        url.setSelection(url.getText().length());
        Label referrer_label = new Label((Composite)shell, 0);
        referrer_label.setText(MessageText.getString("openUrl.referrer"));
        gridData = new GridData();
        referrer_label.setLayoutData((Object)gridData);
        final Combo referrer_combo = new Combo((Composite)shell, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 150;
        gridData.grabExcessHorizontalSpace = true;
        referrer_combo.setLayoutData((Object)gridData);
        final StringList referrers = COConfigurationManager.getStringListParameter("url_open_referrers");
        StringIterator iter = referrers.iterator();
        while (iter.hasNext()) {
            referrer_combo.add(iter.next());
        }
        if (referrer != null && referrer.length() > 0) {
            referrer_combo.setText(referrer);
        } else if (last_referrer != null) {
            referrer_combo.setText(last_referrer);
        }
        Label referrer_info = new Label((Composite)shell, 0);
        referrer_info.setText(MessageText.getString("openUrl.referrer.info"));
        Label labelSeparator = new Label((Composite)shell, 258);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        labelSeparator.setLayoutData((Object)gridData);
        Composite panel = new Composite((Composite)shell, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        panel.setLayout((Layout)layout);
        gridData = new GridData(896);
        gridData.horizontalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        panel.setLayoutData((Object)gridData);
        new Label(panel, 0);
        Button ok = new Button(panel, 8);
        gridData = new GridData(896);
        gridData.widthHint = 70;
        gridData.grabExcessHorizontalSpace = true;
        ok.setLayoutData((Object)gridData);
        ok.setText(MessageText.getString("Button.ok"));
        ok.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                last_referrer = referrer_combo.getText().trim();
                if (!referrers.contains(last_referrer)) {
                    referrers.add(last_referrer);
                    COConfigurationManager.setParameter("url_open_referrers", referrers);
                    COConfigurationManager.save();
                }
                COConfigurationManager.setParameter(CONFIG_REFERRER_DEFAULT, last_referrer);
                COConfigurationManager.save();
                new FileDownloadWindow(azureus_core, display, url.getText(), last_referrer);
                shell.dispose();
            }
        });
        shell.setDefaultButton(ok);
        Button cancel = new Button(panel, 8);
        gridData = new GridData(128);
        gridData.grabExcessHorizontalSpace = false;
        gridData.widthHint = 70;
        cancel.setLayoutData((Object)gridData);
        cancel.setText(MessageText.getString("Button.cancel"));
        cancel.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                shell.dispose();
            }
        });
        shell.pack();
        Utils.createURLDropTarget((Control)shell, url);
        shell.open();
    }
}

