/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.AzureusCore;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.ui.swt.mainwindow.MainWindow;
import org.gudy.azureus2.ui.swt.views.AbstractIView;
import org.gudy.azureus2.ui.swt.views.IView;
import org.gudy.azureus2.ui.swt.views.MyTorrentsView;
import org.gudy.azureus2.ui.swt.views.table.TableColumnCore;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnManager;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.AvailabilityItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.CategoryItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.CompletionItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.DoneItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.DownItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.DownSpeedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.DownSpeedLimitItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.ETAItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.HealthItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.MaxUploadsItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.NameItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.OnlyCDing4Item;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.PeersItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.PiecesItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.RankItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.RemainingItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.SavePathItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.SecondsDownloadingItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.SecondsSeedingItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.SeedToPeerRatioItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.SeedsItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.ShareRatioItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.SizeItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.StatusItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.TorrentPathItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.TotalSpeedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.TrackerNameItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.TrackerNextAccessItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.TrackerStatusItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.UpItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.UpSpeedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.UpSpeedLimitItem;

public class MyTorrentsSuperView
extends AbstractIView {
    private AzureusCore azureus_core;
    private GlobalManager globalManager;
    private MyTorrentsView torrentview;
    private MyTorrentsView seedingview;
    private SashForm form;
    static final TableColumnCore[] tableIncompleteItems = new TableColumnCore[]{new HealthItem("MyTorrents"), new RankItem("MyTorrents"), new NameItem("MyTorrents"), new SizeItem("MyTorrents"), new DownItem(), new DoneItem("MyTorrents"), new StatusItem("MyTorrents"), new SeedsItem("MyTorrents"), new PeersItem("MyTorrents"), new DownSpeedItem(), new UpSpeedItem("MyTorrents"), new ETAItem(), new ShareRatioItem("MyTorrents"), new UpItem("MyTorrents"), new UpSpeedLimitItem("MyTorrents"), new TrackerStatusItem("MyTorrents"), new RemainingItem(), new PiecesItem(), new CompletionItem(), new MaxUploadsItem("MyTorrents"), new TotalSpeedItem("MyTorrents"), new SavePathItem("MyTorrents"), new TorrentPathItem("MyTorrents"), new CategoryItem("MyTorrents"), new AvailabilityItem("MyTorrents"), new SecondsSeedingItem("MyTorrents"), new SecondsDownloadingItem("MyTorrents"), new OnlyCDing4Item("MyTorrents"), new TrackerNextAccessItem("MyTorrents"), new TrackerNameItem("MyTorrents"), new SeedToPeerRatioItem("MyTorrents"), new DownSpeedLimitItem("MyTorrents")};
    static final TableColumnCore[] tableCompleteItems = new TableColumnCore[]{new HealthItem("MySeeders"), new RankItem("MySeeders"), new NameItem("MySeeders"), new SizeItem("MySeeders"), new DoneItem("MySeeders"), new StatusItem("MySeeders"), new SeedsItem("MySeeders"), new PeersItem("MySeeders"), new UpSpeedItem("MySeeders"), new ShareRatioItem("MySeeders"), new UpItem("MySeeders"), new UpSpeedLimitItem("MySeeders"), new MaxUploadsItem("MySeeders"), new TotalSpeedItem("MySeeders"), new SavePathItem("MySeeders"), new TorrentPathItem("MySeeders"), new CategoryItem("MySeeders"), new AvailabilityItem("MySeeders"), new SecondsSeedingItem("MySeeders"), new SecondsDownloadingItem("MySeeders"), new OnlyCDing4Item("MySeeders"), new TrackerStatusItem("MySeeders"), new TrackerNextAccessItem("MySeeders"), new TrackerNameItem("MySeeders"), new SeedToPeerRatioItem("MySeeders")};

    public MyTorrentsSuperView(AzureusCore _azureus_core) {
        this.azureus_core = _azureus_core;
        this.globalManager = this.azureus_core.getGlobalManager();
        TableColumnManager tcExtensions = TableColumnManager.getInstance();
        int i = 0;
        while (i < tableCompleteItems.length) {
            tcExtensions.addColumn(tableCompleteItems[i]);
            ++i;
        }
        i = 0;
        while (i < tableIncompleteItems.length) {
            tcExtensions.addColumn(tableIncompleteItems[i]);
            ++i;
        }
    }

    public Composite getComposite() {
        return this.form;
    }

    public void delete() {
        MainWindow.getWindow().setMytorrents(null);
        if (this.torrentview != null) {
            this.torrentview.delete();
        }
        if (this.seedingview != null) {
            this.seedingview.delete();
        }
        super.delete();
    }

    public void initialize(Composite composite0) {
        if (this.form != null) {
            return;
        }
        this.form = new SashForm(composite0, 512);
        GridData gridData = new GridData(1808);
        this.form.setLayoutData((Object)gridData);
        Composite child1 = new Composite((Composite)this.form, 0);
        child1.setLayout((Layout)new FillLayout());
        this.torrentview = new MyTorrentsView(this.azureus_core, false, tableIncompleteItems);
        this.torrentview.initialize(child1);
        child1.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                int[] weights = MyTorrentsSuperView.this.form.getWeights();
                int iSashValue = weights[0] * 100 / (weights[0] + weights[1]);
                COConfigurationManager.setParameter("MyTorrents.SplitAt", iSashValue);
            }
        });
        Composite child2 = new Composite((Composite)this.form, 0);
        child2.setLayout((Layout)new FillLayout());
        this.seedingview = new MyTorrentsView(this.azureus_core, true, tableCompleteItems);
        this.seedingview.initialize(child2);
        int weight = COConfigurationManager.getIntParameter("MyTorrents.SplitAt", 30);
        if (weight > 100) {
            weight = 100;
        }
        this.form.setWeights(new int[]{weight, 100 - weight});
    }

    public void refresh() {
        if (this.getComposite() == null || this.getComposite().isDisposed()) {
            return;
        }
        this.seedingview.refresh();
        this.torrentview.refresh();
    }

    public String getFullTitle() {
        return MessageText.getString("MyTorrentsView.mytorrents");
    }

    private IView getCurrentView() {
        try {
            if (this.torrentview.getTable().isFocusControl()) {
                return this.torrentview;
            }
            if (this.seedingview.getTable().isFocusControl()) {
                return this.seedingview;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public boolean isEnabled(String itemKey) {
        IView currentView = this.getCurrentView();
        if (currentView != null) {
            return currentView.isEnabled(itemKey);
        }
        return false;
    }

    public void itemActivated(String itemKey) {
        IView currentView = this.getCurrentView();
        if (currentView != null) {
            currentView.itemActivated(itemKey);
        }
    }

    public void removeDownloadBar(DownloadManager manager) {
        this.torrentview.removeDownloadBar(manager);
        this.seedingview.removeDownloadBar(manager);
    }
}

