/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.update;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Properties;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.UnloadablePlugin;

public class UpdaterUpdateChecker
implements UnloadablePlugin {
    public static void checkPlugin() {
        try {
            File user_plugin_dir = FileUtil.getUserFile("plugins");
            File user_updater_plugin = new File(user_plugin_dir, "azupdater");
            File user_updater_props = new File(user_updater_plugin, "plugin.properties");
            if (user_updater_props.exists()) {
                return;
            }
            File shared_plugin_dir = FileUtil.getApplicationFile("plugins");
            File shared_updater_plugin = new File(shared_plugin_dir, "azupdater");
            shared_updater_plugin.mkdirs();
            File props = new File(shared_updater_plugin, "plugin.properties");
            if (props.exists()) {
                return;
            }
            PrintWriter pw = null;
            try {
                pw = new PrintWriter(new FileWriter(props));
                pw.println("plugin.class=org.gudy.azureus2.update.UpdaterUpdateChecker;org.gudy.azureus2.update.UpdaterPatcher");
                pw.println("plugin.name=Azureus Update Support;Azureus Updater Support Patcher");
            }
            finally {
                if (pw != null) {
                    pw.close();
                }
            }
            if (!props.exists()) {
                throw new Exception("Failed to write '" + props.toString() + "'");
            }
        }
        catch (Throwable e) {
            LGLogger.logUnrepeatableAlert("azupdater plugin: initialisation error", e);
        }
    }

    public void initialize(PluginInterface pi) {
        Properties props = pi.getPluginProperties();
        props.setProperty("plugin.mandatory", "true");
        if (pi.getPluginVersion() == null) {
            props.setProperty("plugin.version", "1.0");
        }
        props.setProperty("plugin.id", "azupdater");
    }

    public void unload() {
    }
}

