/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.cxx;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.FileManager;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.Utilities;
import gov.llnl.babel.backend.writers.LanguageWriterForCxx;
import gov.llnl.babel.backend.writers.LineCountingFilterWriter;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Comment;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.Type;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;

public class Cxx {
    public static final String FUNCTION_RESULT = "_result";
    public static final String NULL = "NULL";
    public static final String RAW_ARRAY_EXT = "_tmp";
    public static final int FILE_ROLE_MIN = 0;
    public static final int FILE_ROLE_MAX = 3;
    public static final int FILE_ROLE_NONE = 0;
    public static final int FILE_ROLE_IMPL = 1;
    public static final int FILE_ROLE_SKEL = 2;
    public static final int FILE_ROLE_STUB = 3;
    public static final String[] FILE_ROLE_SUFFIX = new String[]{"", "Impl", "Skel", ""};
    public static final int FILE_TYPE_MIN = 0;
    public static final int FILE_TYPE_MAX = 4;
    public static final int FILE_TYPE_NONE = 0;
    public static final int FILE_TYPE_CXX_HEADER = 1;
    public static final int FILE_TYPE_CXX_SOURCE = 2;
    public static final int FILE_TYPE_C_HEADER = 3;
    public static final int FILE_TYPE_C_SOURCE = 4;
    public static final String[] FILE_TYPE_EXTENSION = new String[]{"", ".hh", ".cc", ".h", ".c"};
    private static final String[] s_types = new String[]{"void", "bool", "char", "::std::complex<double>", "double", "::std::complex<float>", "float", "int32_t", "int64_t", "void*", "::std::string"};
    private static final String[] s_array_types = new String[]{null, "::sidl::array<bool>", "::sidl::array<char>", "::sidl::array< ::sidl::dcomplex>", "::sidl::array<double>", "::sidl::array< ::sidl::fcomplex>", "::sidl::array<float>", "::sidl::array<int32_t>", "::sidl::array<int64_t>", "::sidl::array<void*>", "::sidl::array< ::std::string>"};

    public static String getFileSuffix(int role) {
        if (0 <= role && role <= 3) {
            return FILE_ROLE_SUFFIX[role];
        }
        return FILE_ROLE_SUFFIX[0];
    }

    public static String getFileExtension(int ftype) {
        if (0 <= ftype && ftype <= 4) {
            return FILE_TYPE_EXTENSION[ftype];
        }
        return FILE_TYPE_EXTENSION[0];
    }

    public static String generateFilename(SymbolID id, int role, int ftype) {
        BabelConfiguration s_babel_config = BabelConfiguration.getInstance();
        if (s_babel_config.makePackageSubdirs() && s_babel_config.getShortFileNames()) {
            return Cxx.generateFilename(id.getShortName(), role, ftype);
        }
        return Cxx.generateFilename(id.getFullName(), role, ftype);
    }

    public static String generateFilename(String symbolName, int role, int ftype) {
        String name = symbolName.replace('.', '_');
        String suffix = Cxx.getFileSuffix(role);
        String extension = Cxx.getFileExtension(ftype);
        if (suffix == null || suffix.equals("")) {
            return name + extension;
        }
        return name + "_" + suffix + extension;
    }

    public static String generateRoleDescription(SymbolID id, int role) {
        switch (role) {
            case 1: {
                return "Server-side implementation for " + id.getFullName();
            }
            case 2: {
                return "Server-side glue code for " + id.getFullName();
            }
            case 3: {
                return "Client-side glue code for " + id.getFullName();
            }
        }
        return "Generated code for " + id.getFullName();
    }

    public static LanguageWriterForCxx createHeader(Symbol symbol, int role, String filegroup) throws CodeGenerationException {
        SymbolID id = symbol.getSymbolID();
        int type = symbol.getSymbolType();
        String filename = Cxx.generateFilename(id, role, 1);
        LanguageWriterForCxx lw = null;
        if (role == 1) {
            Writer fw = FileManager.getInstance().createWriter(id, type, filegroup, filename);
            LineCountingFilterWriter lcfw = new LineCountingFilterWriter(fw);
            PrintWriter pw = new PrintWriter(lcfw);
            lw = new LanguageWriterForCxx(pw, lcfw);
        } else {
            PrintWriter pw = FileManager.getInstance().createFile(id, type, filegroup, filename);
            lw = new LanguageWriterForCxx(pw);
        }
        lw.writeBanner(symbol, filename, role == 1, Cxx.generateRoleDescription(id, role));
        return lw;
    }

    public static LanguageWriterForCxx createSource(Symbol symbol, int role, String filegroup) throws CodeGenerationException {
        SymbolID id = symbol.getSymbolID();
        int type = symbol.getSymbolType();
        String filename = Cxx.generateFilename(id, role, 2);
        LanguageWriterForCxx lw = null;
        if (role == 1) {
            Writer fw = FileManager.getInstance().createWriter(id, type, filegroup, filename);
            LineCountingFilterWriter lcfw = new LineCountingFilterWriter(fw);
            PrintWriter pw = new PrintWriter(lcfw);
            lw = new LanguageWriterForCxx(pw, lcfw);
        } else {
            PrintWriter pw = FileManager.getInstance().createFile(id, type, filegroup, filename);
            lw = new LanguageWriterForCxx(pw);
        }
        lw.writeBanner(symbol, filename, role == 1, Cxx.generateRoleDescription(id, role));
        return lw;
    }

    public static void nestPackagesInNamespaces(LanguageWriterForCxx writer, Symbol symbol) {
        StringTokenizer tokens = new StringTokenizer(symbol.getSymbolID().getFullName(), ".");
        int tokenCount = tokens.countTokens();
        int i = 0;
        while (i + 1 < tokenCount) {
            writer.println("namespace " + tokens.nextToken() + " { ");
            writer.tab();
            ++i;
        }
        writer.println();
    }

    public static void unnestPackagesInNamespaces(LanguageWriterForCxx writer, Symbol symbol) {
        Stack<String> stack = new Stack<String>();
        StringTokenizer tokens = new StringTokenizer(symbol.getSymbolID().getFullName(), ".");
        int tokenCount = tokens.countTokens();
        int i = 0;
        while (i + 1 < tokenCount) {
            stack.push(tokens.nextToken());
            ++i;
        }
        while (!stack.empty()) {
            writer.backTab();
            writer.print("} ");
            writer.writeCommentLine("end namespace " + (String)stack.pop());
        }
        writer.println();
    }

    public static void beginExternCRegion(LanguageWriterForCxx writer) {
        writer.println("extern \"C\" {");
        writer.println();
        writer.tab();
    }

    public static void endExternCRegion(LanguageWriterForCxx writer) {
        writer.backTab();
        writer.println();
        writer.println("} // end extern \"C\"");
    }

    public static String getSymbolName(SymbolID id, String postfix) {
        if (postfix == null || postfix.trim().equals("")) {
            return "::" + Utilities.replace(id.getFullName(), ".", "::");
        }
        return "::" + Utilities.replace(id.getFullName(), ".", "::") + "_" + postfix;
    }

    public static String getSymbolName(SymbolID id) {
        return Cxx.getSymbolName(id, null);
    }

    public static String getSymbolNameWithoutLeadingColons(SymbolID id, String postfix) {
        if (postfix == null || postfix.trim().equals("")) {
            return Utilities.replace(id.getFullName(), ".", "::");
        }
        return Utilities.replace(id.getFullName(), ".", "::") + "_" + postfix;
    }

    public static String getEnumName(SymbolID id) {
        return Cxx.getSymbolName(id);
    }

    public static String getObjectName(SymbolID id) {
        return Cxx.getSymbolName(id);
    }

    public static String reinterpretCast(String newtype, String arg) {
        return "reinterpret_cast< " + newtype + ">(" + arg + ")";
    }

    public static String constCast(String newtype, String arg) {
        return "const_cast< " + newtype + ">(" + arg + ")";
    }

    public static String getCxxString(Type type, boolean rarrays) throws CodeGenerationException {
        int t = type.getType();
        if (t < s_types.length) {
            return s_types[t];
        }
        if (t == 15) {
            Symbol symbol = Utilities.lookupSymbol(type.getSymbolID());
            return Cxx.getSymbolName(symbol.getSymbolID());
        }
        if (t == 16) {
            Type atype = type.getArrayType();
            if (rarrays && type.isRarray()) {
                if (atype.getType() == 3 || atype.getType() == 5) {
                    return IOR.getReturnString(atype, true, false) + "*";
                }
                return Cxx.getCxxString(atype, true) + "*";
            }
            if (null != atype) {
                int a = atype.getType();
                if (a < s_array_types.length) {
                    return s_array_types[a];
                }
                return "::sidl::array< " + Cxx.getObjectName(atype.getSymbolID()) + ">";
            }
            return "::sidl::basearray";
        }
        return null;
    }

    public static String getReturnString(Type type) throws CodeGenerationException {
        return Cxx.getCxxString(type, false);
    }

    public static String getRarrayReturnString(Type type) throws CodeGenerationException {
        return Cxx.getCxxString(type, true);
    }

    public static String getArgModeComment(Argument arg) {
        return "/* " + arg.getModeString() + " */ ";
    }

    public static String getArgumentString(Argument arg, boolean rarrays) throws CodeGenerationException {
        int mode = arg.getMode();
        StringBuffer argString = new StringBuffer(50);
        argString.append(Cxx.getArgModeComment(arg));
        Type type = arg.getType();
        if (mode == 0 && (type.getType() == 10 || type.getType() == 5 || type.getType() == 3)) {
            argString.append("const ");
            argString.append(Cxx.getReturnString(type));
            argString.append("&");
        } else if (rarrays && type.isRarray()) {
            argString.append(Cxx.getRarrayReturnString(type));
        } else {
            argString.append(Cxx.getReturnString(type));
            if (mode != 0) {
                argString.append("&");
            }
        }
        argString.append(" ");
        argString.append(arg.getFormalName());
        return argString.toString();
    }

    public static String getIORCall(String objName, Type t) {
        switch (t.getDetailedType()) {
            case 16: {
                return objName + (null != t.getArrayType() ? "._get_ior()" : "._get_baseior()");
            }
            case 12: 
            case 13: {
                return objName + "._get_ior()";
            }
        }
        return null;
    }

    public static String getMethodImplName(SymbolID id, String methodName) {
        return Cxx.getSymbolName(id, "impl") + "::" + methodName;
    }

    public static String getMethodSkelName(SymbolID id, String methodName) {
        return "skel_" + id.getFullName().replace('.', '_') + '_' + methodName;
    }

    public static String getMethodSkelName(SymbolID id, Method method) {
        return Cxx.getMethodSkelName(id, method.getLongMethodName());
    }

    public static String getMethodStubName(SymbolID id, String methodName) {
        return Cxx.getSymbolNameWithoutLeadingColons(id, "") + "::" + methodName;
    }

    public static Set generateDependencyIncludes(LanguageWriterForCxx writer, Extendable ext, boolean removeSelf) throws CodeGenerationException {
        HashSet<SymbolID> includes = new HashSet<SymbolID>();
        Iterator i = ext.getMethods(true).iterator();
        while (i.hasNext()) {
            Method method = (Method)i.next();
            includes.addAll(method.getSymbolReferences());
        }
        writer.generateInclude("sidl_cxx.hh", true);
        if (removeSelf) {
            includes.remove(ext.getSymbolID());
        } else {
            includes.add(ext.getSymbolID());
        }
        writer.generateInclude(IOR.getHeaderFile(ext.getSymbolID()), true);
        if (!includes.isEmpty()) {
            writer.writeComment("Includes for all method dependencies.", false);
            ArrayList entries = Utilities.sort(includes);
            Iterator i2 = entries.iterator();
            while (i2.hasNext()) {
                String header = Cxx.generateFilename((SymbolID)i2.next(), 3, 1);
                writer.generateInclude(header, true);
            }
            writer.println();
        }
        return includes;
    }

    public static void generateMethodSignature(LanguageWriterForCxx writer, Method method, String suffix, String altcomment, int role, boolean rarrays) throws CodeGenerationException {
        BabelConfiguration s_babel_config = BabelConfiguration.getInstance();
        if (method == null) {
            return;
        }
        boolean doReturn = suffix.equals("_post") && method.getReturnType().getType() != 0;
        Comment comment = method.getComment();
        writer.writeComment(comment, altcomment);
        boolean canThrowNullIORException = role == 3 && s_babel_config.makeCxxCheckNullIOR();
        ArrayList vArgs = null;
        vArgs = rarrays ? method.getArgumentListWithIndices() : method.getArgumentListWithOutIndices();
        if (method.isStatic()) {
            writer.print("static ");
        }
        writer.println(Cxx.getReturnString(method.getReturnType()));
        writer.print(method.getShortMethodName());
        if (vArgs.size() > 0) {
            writer.println(" (");
            writer.tab();
            Cxx.generateArgumentList(writer, method, rarrays);
            writer.println();
            writer.backTab();
            writer.println(")");
            Cxx.generateThrowsList(writer, method, canThrowNullIORException);
            writer.println(";");
        } else {
            writer.print("() ");
            Cxx.generateThrowsList(writer, method, canThrowNullIORException);
            writer.print(";");
        }
        writer.println();
    }

    public static void generateInlineMethodSignature(LanguageWriterForCxx writer, Method method, String altcomment, int role, boolean isSuper) throws CodeGenerationException {
        boolean canThrowNullIORException;
        BabelConfiguration s_babel_config = BabelConfiguration.getInstance();
        if (method == null) {
            return;
        }
        Comment comment = method.getComment();
        writer.writeComment(comment, altcomment);
        boolean bl = canThrowNullIORException = role == 3 && s_babel_config.makeCxxCheckNullIOR();
        if (!isSuper) {
            writer.print("inline ");
        }
        if (method.isStatic()) {
            writer.print("static ");
        }
        writer.println(Cxx.getReturnString(method.getReturnType()));
        writer.print(method.getShortMethodName());
        if (method.getArgumentList().size() > 0) {
            writer.println(" (");
            writer.tab();
            Cxx.generateArgumentList(writer, method, true);
            writer.println();
            writer.backTab();
            writer.println(")");
            Cxx.generateThrowsList(writer, method, canThrowNullIORException);
            writer.println("{");
        } else {
            writer.print("() ");
            Cxx.generateThrowsList(writer, method, canThrowNullIORException);
            writer.print("{");
        }
        writer.println();
    }

    public static void generateArgumentList(LanguageWriterForCxx writer, Method method, boolean rarrays) throws CodeGenerationException {
        ArrayList args = null;
        args = rarrays ? method.getArgumentListWithIndices() : method.getArgumentListWithOutIndices();
        Iterator a = args.iterator();
        while (a.hasNext()) {
            Argument arg = (Argument)a.next();
            writer.print(Cxx.getArgumentString(arg, rarrays));
            if (!a.hasNext()) continue;
            writer.println(",");
        }
    }

    public static void generateThrowsList(LanguageWriterForCxx writer, Method method, boolean canThrowNullIORException) {
        Set exceptions = method.getThrows();
        BabelConfiguration s_babel_config = BabelConfiguration.getInstance();
        if (exceptions == null || exceptions.isEmpty()) {
            if (canThrowNullIORException && s_babel_config.makeCxxCheckNullIOR()) {
                writer.println("throw ( ::sidl::NullIORException ) ");
            } else {
                writer.println("throw () ");
            }
            return;
        }
        writer.println("throw ( ");
        writer.tab();
        if (canThrowNullIORException && s_babel_config.makeCxxCheckNullIOR()) {
            writer.print("::sidl::NullIORException, ");
        }
        Iterator e = exceptions.iterator();
        while (e.hasNext()) {
            SymbolID id = (SymbolID)e.next();
            writer.print(Cxx.getObjectName(id));
            if (!e.hasNext()) continue;
            writer.println(", ");
        }
        writer.println();
        writer.backTab();
        writer.print(")");
    }

    public static String generateThrowsList(Method method, boolean canThrowNullIORException) {
        Set exceptions = method.getThrows();
        BabelConfiguration s_babel_config = BabelConfiguration.getInstance();
        StringBuffer ret = new StringBuffer();
        if (exceptions == null || exceptions.isEmpty()) {
            if (canThrowNullIORException && s_babel_config.makeCxxCheckNullIOR()) {
                return "throw ( ::sidl::NullIORException ) \n";
            }
            return "throw () \n";
        }
        ret.append("throw ( ");
        if (canThrowNullIORException && s_babel_config.makeCxxCheckNullIOR()) {
            ret.append("::sidl::NullIORException, \n");
        }
        Iterator e = exceptions.iterator();
        while (e.hasNext()) {
            SymbolID id = (SymbolID)e.next();
            ret.append(Cxx.getObjectName(id));
            if (!e.hasNext()) continue;
            ret.append(",\n");
        }
        ret.append(")");
        return ret.toString();
    }

    public static boolean inlineStub(Method m) {
        Set thrws = m.getThrows();
        if (!thrws.isEmpty()) {
            return false;
        }
        int return_type = m.getReturnType().getType();
        if (return_type == 1 || return_type == 3 || return_type == 5 || return_type >= 12 || return_type == 10) {
            return false;
        }
        ArrayList args = m.getArgumentList();
        Iterator a = args.iterator();
        while (a.hasNext()) {
            Argument arg = (Argument)a.next();
            int arg_type = arg.getType().getType();
            int arg_mode = arg.getMode();
            if (arg_type != 1 && arg_type != 3 && arg_type != 5 && arg_type != 10 && arg_type < 12) continue;
            return false;
        }
        return true;
    }

    public static String generateFunctionDeclaration(Method m, Extendable d_ext, String d_self, boolean rarrays) throws CodeGenerationException {
        ArrayList vArgs = null;
        vArgs = rarrays ? m.getArgumentListWithIndices() : m.getArgumentListWithOutIndices();
        int nargs = vArgs.size();
        StringBuffer func_decl = new StringBuffer(nargs * 32);
        String extra_close_paren = "";
        String shortMethodName = m.getShortMethodName();
        String longMethodName = m.getLongMethodName();
        Comment comment = m.getComment();
        BabelConfiguration s_babel_config = BabelConfiguration.getInstance();
        Type return_type = m.getReturnType();
        SymbolID id = return_type.getSymbolID();
        func_decl.append(Cxx.getReturnString(return_type));
        func_decl.append("\n");
        func_decl.append(Cxx.getMethodStubName(d_ext.getSymbolID(), shortMethodName));
        func_decl.append("( ");
        Iterator it = vArgs.iterator();
        while (it.hasNext()) {
            Argument arg = (Argument)it.next();
            Type type = arg.getType();
            int typeInt = type.getDetailedType();
            String argName = arg.getFormalName();
            String mode = Cxx.getArgModeComment(arg);
            int modeInt = arg.getMode();
            func_decl.append(Cxx.getArgumentString(arg, rarrays));
            if (!it.hasNext()) continue;
            func_decl.append(", ");
        }
        func_decl.append(" )\n");
        func_decl.append(Cxx.generateThrowsList(m, true));
        return func_decl.toString().trim();
    }

    public static String generateInitialization(Method m, Extendable d_ext, String d_self) throws CodeGenerationException {
        ArrayList vArgs = m.getArgumentList();
        int nargs = vArgs.size();
        StringBuffer init_stuff = new StringBuffer(nargs * 128);
        String extra_close_paren = "";
        String shortMethodName = m.getShortMethodName();
        String longMethodName = m.getLongMethodName();
        Comment comment = m.getComment();
        BabelConfiguration s_babel_config = BabelConfiguration.getInstance();
        Type return_type = m.getReturnType();
        SymbolID id = return_type.getSymbolID();
        if (return_type.getType() != 0) {
            init_stuff.append(Cxx.getCxxString(return_type, true));
            init_stuff.append(" _result;\n");
        }
        return init_stuff.toString().trim();
    }

    public static String generatePreIORCall(Method m, Extendable d_ext, String d_self, boolean rarrays) throws CodeGenerationException {
        String nm = "Cxx.generatePreIORCall: ";
        ArrayList vArgs = null;
        vArgs = rarrays ? m.getArgumentListWithIndices() : m.getArgumentListWithOutIndices();
        int nargs = vArgs.size();
        StringBuffer pre_ior = new StringBuffer(nargs * 128);
        String extra_close_paren = "";
        String shortMethodName = m.getShortMethodName();
        String longMethodName = m.getLongMethodName();
        Comment comment = m.getComment();
        BabelConfiguration s_babel_config = BabelConfiguration.getInstance();
        Type return_type = m.getReturnType();
        SymbolID id = return_type.getSymbolID();
        switch (return_type.getDetailedType()) {
            case 0: {
                break;
            }
            case 9: {
                break;
            }
            case 1: {
                pre_ior.append("sidl_bool _local_result;\n");
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 11: {
                pre_ior.append(IOR.getEnumName(return_type.getSymbolID()) + " _local_result;\n");
                break;
            }
            case 5: {
                pre_ior.append("struct sidl_fcomplex _local_result;\n");
                break;
            }
            case 3: {
                pre_ior.append("struct sidl_dcomplex _local_result;\n");
                break;
            }
            case 10: {
                pre_ior.append("char * _local_result;\n");
                break;
            }
            case 15: {
                throw new CodeGenerationException("Cxx.generatePreIORCall: Type.SYMBOL should have been resolved to\nType.ENUM, Type.CLASS, or Type.INTERFACE.");
            }
            case 12: 
            case 13: {
                break;
            }
            case 16: {
                String iorArrayName = IOR.getReturnString(return_type, true, false);
                pre_ior.append(iorArrayName + " _local_result;\n");
                break;
            }
            default: {
                throw new CodeGenerationException("Cxx.generatePreIORCall: Unexpected User Defined Return Type \"" + return_type.getType() + "\".");
            }
        }
        Iterator it = vArgs.iterator();
        block51: while (it.hasNext()) {
            Argument arg = (Argument)it.next();
            Type type = arg.getType();
            int typeInt = type.getDetailedType();
            String argName = arg.getFormalName();
            String mode = Cxx.getArgModeComment(arg);
            int modeInt = arg.getMode();
            switch (typeInt) {
                case 16: {
                    String iorArrayName = IOR.getReturnString(type, true, false);
                    if (rarrays && type.isRarray()) {
                        String r_name = arg.getFormalName();
                        int aIntType = type.getArrayType().getType();
                        String sidl_array_name = IOR.getArrayNameWithoutAsterix(aIntType);
                        int dim = type.getArrayDimension();
                        pre_ior.append("int32_t " + r_name + "_lower[" + dim + "], " + r_name + "_upper[" + dim + "], " + r_name + "_stride[" + dim + "];\n");
                        pre_ior.append(sidl_array_name + " " + r_name + "_real;\n");
                        pre_ior.append(sidl_array_name + " *" + r_name + RAW_ARRAY_EXT + " = &" + r_name + "_real;\n");
                        List indices = type.getArrayIndices();
                        String init_func_name = IOR.getArrayNameForFunctions(aIntType) + "_init";
                        int x = 0;
                        Iterator i = indices.iterator();
                        while (i.hasNext()) {
                            pre_ior.append(r_name + "_upper[" + x + "] = " + (String)i.next() + "-1;\n");
                            ++x;
                        }
                        pre_ior.append(init_func_name + "(" + r_name + ", " + r_name + RAW_ARRAY_EXT + ", " + type.getArrayDimension() + ", " + r_name + "_lower, " + r_name + "_upper, " + r_name + "_stride);\n");
                        continue block51;
                    }
                    switch (modeInt) {
                        case 0: {
                            break;
                        }
                        case 2: {
                            pre_ior.append(iorArrayName + " _local_" + argName + ";\n");
                            break;
                        }
                        case 1: {
                            pre_ior.append("if (" + argName + ") {\n");
                            pre_ior.append("  " + argName + ".addRef();\n");
                            pre_ior.append("}\n");
                            pre_ior.append(iorArrayName + " _local_" + argName + " = " + Cxx.getIORCall(argName, type) + ";\n");
                        }
                    }
                    continue block51;
                }
                case 1: {
                    switch (modeInt) {
                        case 0: 
                        case 1: {
                            pre_ior.append("sidl_bool _local_" + argName + " = " + argName + ";\n");
                            break;
                        }
                        case 2: {
                            pre_ior.append("sidl_bool _local_" + argName + ";\n");
                        }
                    }
                    continue block51;
                }
                case 2: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    continue block51;
                }
                case 12: 
                case 13: {
                    id = type.getSymbolID();
                    switch (modeInt) {
                        case 0: {
                            break;
                        }
                        case 2: {
                            pre_ior.append(IOR.getObjectName(id) + "* _local_" + argName + ";\n");
                            break;
                        }
                        case 1: {
                            pre_ior.append(IOR.getObjectName(id) + "* _local_" + argName + " = " + argName + "._get_ior();\n");
                            pre_ior.append(argName + "._set_ior( 0 );\n");
                        }
                    }
                    continue block51;
                }
                case 3: {
                    switch (modeInt) {
                        case 0: 
                        case 1: {
                            pre_ior.append("struct sidl_dcomplex _local_" + argName + " = {");
                            pre_ior.append(argName + ".real(), ");
                            pre_ior.append(argName + ".imag() } ; \n");
                            break;
                        }
                        case 2: {
                            pre_ior.append("struct sidl_dcomplex _local_" + argName + "; \n");
                        }
                    }
                    continue block51;
                }
                case 11: {
                    String ior_name = IOR.getEnumName(type.getSymbolID());
                    continue block51;
                }
                case 5: {
                    switch (modeInt) {
                        case 0: 
                        case 1: {
                            pre_ior.append("struct sidl_fcomplex _local_" + argName + " = {");
                            pre_ior.append(argName + ".real(), ");
                            pre_ior.append(argName + ".imag() } ; \n");
                            break;
                        }
                        case 2: {
                            pre_ior.append("struct sidl_fcomplex _local_" + argName + "; \n");
                        }
                    }
                    continue block51;
                }
                case 10: {
                    switch (modeInt) {
                        case 0: {
                            break;
                        }
                        case 2: {
                            pre_ior.append("char * _local_" + argName + " = 0;\n");
                            break;
                        }
                        case 1: {
                            pre_ior.append("char * _local_" + argName + " = sidl_String_strdup( " + argName + ".c_str() );\n");
                        }
                    }
                    continue block51;
                }
                case 15: {
                    throw new CodeGenerationException("Cxx.generatePreIORCall: Type.SYMBOL should have been resolved to\nType.ENUM, Type.CLASS, or Type.INTERFACE.");
                }
            }
            throw new CodeGenerationException("Cxx.generatePreIORCall: Unexpected User Defined Return Type \"" + return_type.getType() + "\".");
        }
        if (m.getThrows().size() > 0) {
            pre_ior.append("sidl_BaseInterface__object * _exception = 0;\n");
        }
        pre_ior.append("/*pack args to dispatch to ior*/\n");
        return pre_ior.toString().trim();
    }

    public static String generateIORCall(Method m, Extendable d_ext, String d_self, boolean isSuper, boolean rarrays) throws CodeGenerationException {
        String nm = "Cxx.generateIORCall: ";
        ArrayList vArgs = m.getArgumentList();
        int nargs = vArgs.size();
        StringBuffer ior_call = new StringBuffer(nargs * 128);
        String extra_close_paren = "";
        String shortMethodName = m.getShortMethodName();
        String longMethodName = m.getLongMethodName();
        Comment comment = m.getComment();
        BabelConfiguration s_babel_config = BabelConfiguration.getInstance();
        Type return_type = m.getReturnType();
        SymbolID id = return_type.getSymbolID();
        switch (return_type.getDetailedType()) {
            case 16: {
                String iorArrayName = IOR.getReturnString(return_type, true, false);
                ior_call.append("_local_result = ");
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 10: 
            case 11: {
                ior_call.append("_local_result = ");
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                ior_call.append("_result = ");
                break;
            }
            case 12: 
            case 13: {
                ior_call.append("_result = " + Cxx.getReturnString(return_type) + "( ");
                extra_close_paren = ", false)";
                break;
            }
            case 15: {
                throw new CodeGenerationException("Cxx.generateIORCall: Type.SYMBOL should have been resolved to\nType.ENUM, Type.CLASS, or Type.INTERFACE.");
            }
            case 0: {
                break;
            }
            default: {
                throw new CodeGenerationException("Cxx.generateIORCall: Unexpected User Defined Return Type \"" + return_type.getType() + "\".");
            }
        }
        if (isSuper) {
            ior_call.append("(*(superEPV->f_" + m.getLongMethodName() + "))(" + d_self);
            if (nargs > 0) {
                ior_call.append(", ");
            }
        } else if (m.isStatic()) {
            ior_call.append("( _get_sepv()->" + IOR.getVectorEntry(longMethodName) + ")( ");
        } else {
            ior_call.append("(*(d_self->d_epv->f_" + m.getLongMethodName() + "))(" + d_self);
            if (nargs > 0) {
                ior_call.append(", ");
            }
        }
        Iterator it = vArgs.iterator();
        while (it.hasNext()) {
            Argument arg = (Argument)it.next();
            Type type = arg.getType();
            int typeInt = type.getDetailedType();
            String argName = arg.getFormalName();
            String mode = Cxx.getArgModeComment(arg);
            int modeInt = arg.getMode();
            ior_call.append(mode);
            switch (typeInt) {
                case 16: {
                    String iorArrayName = IOR.getReturnString(type, true, false);
                    if (rarrays && type.isRarray()) {
                        if (modeInt == 1) {
                            ior_call.append("&");
                        }
                        ior_call.append(argName + RAW_ARRAY_EXT);
                        break;
                    }
                    switch (modeInt) {
                        case 0: {
                            ior_call.append(Cxx.getIORCall(argName, type));
                            break;
                        }
                        case 1: 
                        case 2: {
                            ior_call.append("&_local_" + argName);
                        }
                    }
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    switch (modeInt) {
                        case 0: {
                            ior_call.append("_local_" + argName);
                            break;
                        }
                        case 1: 
                        case 2: {
                            ior_call.append("&_local_" + argName);
                        }
                    }
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    switch (modeInt) {
                        case 0: {
                            ior_call.append(argName);
                            break;
                        }
                        case 1: 
                        case 2: {
                            ior_call.append("&" + argName);
                        }
                    }
                    break;
                }
                case 12: 
                case 13: {
                    id = type.getSymbolID();
                    switch (modeInt) {
                        case 0: {
                            ior_call.append(argName + "._get_ior()");
                            break;
                        }
                        case 1: 
                        case 2: {
                            ior_call.append("&_local_" + argName);
                        }
                    }
                    break;
                }
                case 11: {
                    String ior_name = IOR.getEnumName(type.getSymbolID());
                    switch (modeInt) {
                        case 0: {
                            ior_call.append("(" + ior_name + ")" + argName);
                            break;
                        }
                        case 1: 
                        case 2: {
                            ior_call.append("(" + ior_name + "*)&" + argName);
                        }
                    }
                    break;
                }
                case 10: {
                    switch (modeInt) {
                        case 0: {
                            ior_call.append(argName + ".c_str()");
                            break;
                        }
                        case 1: 
                        case 2: {
                            ior_call.append("&_local_" + argName);
                        }
                    }
                    break;
                }
                case 15: {
                    throw new CodeGenerationException("Cxx.generateIORCall: Type.SYMBOL should have been resolved to\nType.ENUM, Type.CLASS, or Type.INTERFACE.");
                }
                default: {
                    throw new CodeGenerationException("Cxx.generateIORCall: Unexpected User Defined Return Type \"" + return_type.getType() + "\".");
                }
            }
            if (!it.hasNext()) continue;
            ior_call.append(", ");
        }
        if (m.getThrows().size() > 0) {
            if (nargs > 0 || !m.isStatic()) {
                ior_call.append(", ");
            }
            ior_call.append("&_exception");
        }
        ior_call.append(" )" + extra_close_paren + ";\n");
        ior_call.append("/*dispatch to ior*/\n");
        return ior_call.toString().trim();
    }

    public static String generatePostIORCall(Method m, Extendable d_ext, String d_self, boolean rarrays) throws CodeGenerationException {
        String nm = "Cxx.generatePostIORCall: ";
        ArrayList vArgs = m.getArgumentList();
        int nargs = vArgs.size();
        StringBuffer post_ior = new StringBuffer(nargs * 128);
        String extra_close_paren = "";
        String shortMethodName = m.getShortMethodName();
        String longMethodName = m.getLongMethodName();
        Comment comment = m.getComment();
        BabelConfiguration s_babel_config = BabelConfiguration.getInstance();
        Type return_type = m.getReturnType();
        SymbolID id = return_type.getSymbolID();
        switch (return_type.getDetailedType()) {
            case 16: {
                String iorArrayName = IOR.getReturnString(return_type, true, false);
                post_ior.append("_result._set_ior(_local_result);\n");
                break;
            }
            case 1: {
                post_ior.append("_result = _local_result;\n");
                break;
            }
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                break;
            }
            case 11: {
                post_ior.append("_result = (" + Cxx.getEnumName(return_type.getSymbolID()) + ")_local_result;\n");
                break;
            }
            case 5: {
                post_ior.append("_result = ::std::complex<float>(_local_result.real,_local_result.imaginary);\n");
                break;
            }
            case 3: {
                post_ior.append("_result = ::std::complex<double>(_local_result.real,_local_result.imaginary);\n");
                break;
            }
            case 10: {
                post_ior.append("if (_local_result) {\n  _result = _local_result;\n  free( _local_result );\n}\n");
                break;
            }
            case 15: {
                throw new CodeGenerationException("Cxx.generatePostIORCall: Type.SYMBOL should have been resolved to\nType.ENUM, Type.CLASS, or Type.INTERFACE.");
            }
            default: {
                throw new CodeGenerationException("Cxx.generatePostIORCall: Unexpected User Defined Return Type " + return_type.getType() + "\".");
            }
        }
        Iterator it = vArgs.iterator();
        block21: while (it.hasNext()) {
            Argument arg = (Argument)it.next();
            Type type = arg.getType();
            int typeInt = type.getDetailedType();
            String argName = arg.getFormalName();
            String mode = Cxx.getArgModeComment(arg);
            int modeInt = arg.getMode();
            boolean isOut = modeInt == 2 || modeInt == 1;
            switch (typeInt) {
                case 16: {
                    String iorArrayName = IOR.getReturnString(type, true, false);
                    if (rarrays && type.isRarray() || !isOut) continue block21;
                    post_ior.append(argName + "._set_ior(_local_" + argName + ");\n");
                    continue block21;
                }
                case 1: {
                    if (!isOut) continue block21;
                    post_ior.append(argName + " = _local_" + argName + ";\n");
                    continue block21;
                }
                case 2: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    continue block21;
                }
                case 12: 
                case 13: {
                    id = type.getSymbolID();
                    if (modeInt == 2) {
                        post_ior.append("if ( " + argName + "._not_nil() ) {\n");
                        post_ior.append("  " + argName + ".deleteRef();\n");
                        post_ior.append("}\n");
                    }
                    if (!isOut) continue block21;
                    post_ior.append(argName + "._set_ior( _local_" + argName + ");\n");
                    continue block21;
                }
                case 11: {
                    String ior_name = IOR.getEnumName(type.getSymbolID());
                    continue block21;
                }
                case 3: {
                    if (!isOut) continue block21;
                    post_ior.append(argName + " = ::std::complex<double>(_local_" + argName + ".real, _local_" + argName + ".imaginary);\n");
                    continue block21;
                }
                case 5: {
                    if (!isOut) continue block21;
                    post_ior.append(argName + " = ::std::complex<float>(_local_" + argName + ".real, _local_" + argName + ".imaginary);\n");
                    continue block21;
                }
                case 10: {
                    if (!isOut) continue block21;
                    post_ior.append("if (_local_" + argName + ") {\n");
                    post_ior.append("  " + argName + " = _local_" + argName + ";\n");
                    post_ior.append("  sidl_String_free( _local_" + argName + ");\n");
                    post_ior.append("}\n");
                    post_ior.append("else {\n");
                    post_ior.append("  " + argName + " = \"\";\n");
                    post_ior.append("}\n");
                    continue block21;
                }
                case 15: {
                    throw new CodeGenerationException("Cxx.generatePostIORCall: Type.SYMBOL should have been resolved to\nType.ENUM, Type.CLASS, or Type.INTERFACE.");
                }
            }
            throw new CodeGenerationException("Cxx.generatePostIORCall: Unexpected User Defined Return Type \"" + return_type.getType() + "\".");
        }
        post_ior.append("/*unpack results and cleanup*/\n");
        return post_ior.toString().trim();
    }
}

