/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.python;

import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.Utilities;
import gov.llnl.babel.backend.python.Python;
import gov.llnl.babel.backend.writers.LanguageWriter;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TranslateArguments {
    private LanguageWriter d_lw;
    private Method d_m;
    private boolean d_convertIncoming = true;
    private boolean d_localVars;
    private boolean d_borrowArrays = false;
    private boolean d_isClient;
    public static final String RETURN_VAR = "_return";

    public TranslateArguments(LanguageWriter writer, Method m, boolean localVars, boolean isClient) {
        this.d_lw = writer;
        this.d_m = m;
        this.d_localVars = localVars;
        this.d_isClient = isClient;
    }

    public void setConvertIncoming(boolean convertIncoming) {
        this.d_convertIncoming = convertIncoming;
    }

    public boolean isConvertIncoming() {
        return this.d_convertIncoming;
    }

    public final void setBorrowArrays(boolean borrowArrays) {
        this.d_borrowArrays = borrowArrays;
    }

    public final boolean isBorrowArrays() {
        return this.d_borrowArrays;
    }

    public static boolean hasProxy(Type ty, boolean inout, boolean isClient) {
        int t = ty.getDetailedType();
        return t == 5 || t == 3 || t == 7 || t == 8 || t == 11 || t == 1 || ty.isRarray() && inout && !isClient;
    }

    public static String proxyVariable(String var) {
        return "_proxy_" + var;
    }

    private void translateArg(int type, String var, String getValue, boolean sidlToPython, boolean readOnly, boolean isRarray) {
        switch (type) {
            case 3: 
            case 5: {
                if (sidlToPython) {
                    this.d_lw.println(TranslateArguments.proxyVariable(var) + ".real = (" + getValue + var + ").real;");
                    this.d_lw.println(TranslateArguments.proxyVariable(var) + ".imag = (" + getValue + var + ").imaginary;");
                    break;
                }
                this.d_lw.println('(' + getValue + var + ").real = " + TranslateArguments.proxyVariable(var) + ".real;");
                this.d_lw.println('(' + getValue + var + ").imaginary = " + TranslateArguments.proxyVariable(var) + ".imag;");
                break;
            }
            case 7: 
            case 8: 
            case 11: {
                if (sidlToPython) {
                    this.d_lw.println(TranslateArguments.proxyVariable(var) + " = " + getValue + var + ';');
                    break;
                }
                this.d_lw.println(getValue + var + " = " + TranslateArguments.proxyVariable(var) + ';');
                break;
            }
            case 1: {
                if (sidlToPython) {
                    this.d_lw.println(TranslateArguments.proxyVariable(var) + " = " + getValue + var + ';');
                    break;
                }
                this.d_lw.println(getValue + var + " = (" + TranslateArguments.proxyVariable(var) + " ? (TRUE) : (FALSE));");
                break;
            }
            case 10: {
                if (sidlToPython || readOnly) break;
                this.d_lw.println(getValue + var + " = (" + getValue + var + " ? strcpy(malloc(strlen(" + getValue + var + ")+1), " + getValue + var + ") : NULL);");
                break;
            }
            case 16: {
                if (sidlToPython || readOnly || this.d_isClient || !isRarray) break;
                this.d_lw.println("sidl_python_copy((const struct sidl__array *)" + TranslateArguments.proxyVariable(var) + ", (struct sidl__array *)(*" + var + "));");
                this.d_lw.println("sidl_python_deleteRef_array((struct sidl__array *)(" + TranslateArguments.proxyVariable(var) + "));");
            }
        }
    }

    private void addSidlToPythonStart(Type t) throws CodeGenerationException {
        switch (t.getDetailedType()) {
            case 2: {
                this.d_lw.print("(int)");
                break;
            }
            case 12: 
            case 13: {
                Symbol sym = Utilities.lookupSymbol(t.getSymbolID());
                this.d_lw.print("(void *)");
                if (this.d_convertIncoming) {
                    this.d_lw.print(Python.getExtendableNewRef(sym));
                } else {
                    this.d_lw.print(Python.getExtendableWrapper(sym));
                }
                this.d_lw.print(", ");
                break;
            }
            case 16: {
                this.d_lw.print("(void *)");
                if (this.d_borrowArrays) {
                    this.d_lw.print(Python.getBorrowArrayFromSIDL(t.getArrayType()));
                } else {
                    this.d_lw.print(Python.getCopyArrayFromSIDL(t.getArrayType()));
                }
                this.d_lw.print(", ");
                break;
            }
            case 9: {
                this.d_lw.print("(void *)sidl_Opaque_Create, ");
                break;
            }
            case 3: 
            case 5: {
                this.d_lw.print("PyComplex_FromCComplex(");
            }
        }
    }

    private void addSidlToPythonEnd(Type t) {
        switch (t.getDetailedType()) {
            case 3: 
            case 5: {
                this.d_lw.print(")");
            }
        }
    }

    private void addPythonToSidlStart(Type t) throws CodeGenerationException {
        switch (t.getDetailedType()) {
            case 12: 
            case 13: {
                Symbol sym = Utilities.lookupSymbol(t.getSymbolID());
                this.d_lw.print("(void *)");
                this.d_lw.print(Python.getExtendableConverter(sym));
                this.d_lw.print(", ");
                break;
            }
            case 16: {
                this.d_lw.print("(void *)");
                if (this.d_borrowArrays) {
                    this.d_lw.print(Python.getBorrowArrayFromPython(t.getArrayType()));
                } else {
                    this.d_lw.print(Python.getCopyArrayFromPython(t));
                }
                this.d_lw.print(", ");
                break;
            }
            case 9: {
                this.d_lw.print("(void *)sidl_Opaque_Convert, ");
            }
        }
    }

    private void outputFormatString(boolean sidlToPython) throws CodeGenerationException {
        this.d_lw.disableLineBreak();
        this.d_lw.print(sidlToPython && this.d_convertIncoming ? "\"(" : "\"");
        if (!this.d_convertIncoming) {
            this.argFormat(this.d_m.getReturnType(), sidlToPython);
        }
        Iterator i = this.d_m.getArgumentList().iterator();
        while (i.hasNext()) {
            Argument arg = (Argument)i.next();
            int mode = arg.getMode();
            if (mode != 1 && (!this.d_convertIncoming || mode != 0) && (this.d_convertIncoming || mode != 2)) continue;
            this.argFormat(arg.getType(), sidlToPython);
        }
        this.d_lw.print(sidlToPython && this.d_convertIncoming ? ")\"" : "\"");
        this.d_lw.enableLineBreak();
    }

    private void addParameter(String param, Type t, int mode, boolean sidlToPython) throws CodeGenerationException {
        if (this.d_convertIncoming && mode != 2 || !this.d_convertIncoming && mode != 0) {
            boolean proxy = TranslateArguments.hasProxy(t, mode == 1, this.d_isClient);
            boolean isPointer = (!proxy || t.isRarray() && sidlToPython) && !this.d_localVars && mode != 0 && !param.equals(RETURN_VAR);
            this.d_lw.println(",");
            if (!(!proxy || t.isRarray() && sidlToPython)) {
                param = TranslateArguments.proxyVariable(param);
            }
            if (sidlToPython) {
                this.addSidlToPythonStart(t);
                if (isPointer) {
                    this.d_lw.print("*");
                }
            } else {
                this.addPythonToSidlStart(t);
                if (!isPointer) {
                    this.d_lw.print("&");
                }
            }
            this.d_lw.print(param);
            if (sidlToPython) {
                this.addSidlToPythonEnd(t);
            }
        }
    }

    private void outputParameters(boolean sidlToPython) throws CodeGenerationException {
        if (!this.d_convertIncoming && this.d_m.getReturnType().getDetailedType() != 0) {
            this.addParameter(RETURN_VAR, this.d_m.getReturnType(), 2, sidlToPython);
        }
        Iterator i = this.d_m.getArgumentList().iterator();
        while (i.hasNext()) {
            Argument arg = (Argument)i.next();
            this.addParameter(arg.getFormalName(), arg.getType(), arg.getMode(), sidlToPython);
        }
    }

    private void argFormat(Type t, boolean sidlToPython) throws CodeGenerationException {
        switch (t.getDetailedType()) {
            case 1: {
                this.d_lw.print("i");
                break;
            }
            case 2: {
                this.d_lw.print("c");
                break;
            }
            case 3: 
            case 5: {
                this.d_lw.print(sidlToPython ? "N" : "D");
                break;
            }
            case 4: {
                this.d_lw.print("d");
                break;
            }
            case 6: {
                this.d_lw.print("f");
                break;
            }
            case 7: {
                this.d_lw.print("l");
                break;
            }
            case 8: {
                this.d_lw.println("\"");
                this.d_lw.printlnUnformatted("#ifdef HAVE_LONG_LONG");
                this.d_lw.println("\"L\"");
                this.d_lw.printlnUnformatted("#else");
                this.d_lw.println("\"l\"");
                this.d_lw.printlnUnformatted("#endif");
                this.d_lw.print("\"");
                break;
            }
            case 10: {
                this.d_lw.print("z");
                break;
            }
            case 11: {
                this.d_lw.print("l");
                break;
            }
            case 0: {
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 16: {
                this.d_lw.print("O&");
                break;
            }
            default: {
                throw new CodeGenerationException("The " + t.getTypeString() + " type is not currently supported in Python.");
            }
        }
    }

    public void convertIncomingArguments(boolean sidlToPython) {
        if (this.d_convertIncoming) {
            Iterator i = this.d_m.getArgumentList().iterator();
            while (i.hasNext()) {
                Argument arg = (Argument)i.next();
                int mode = arg.getMode();
                if (mode == 2) continue;
                String getValue = mode == 1 && !this.d_localVars ? "*" : "";
                this.translateArg(arg.getType().getDetailedType(), arg.getFormalName(), getValue, sidlToPython, mode == 0, arg.getType().isRarray());
            }
        }
    }

    public void convertOutgoingArguments(boolean sidlToPython) {
        if (!this.d_convertIncoming) {
            String getValue = this.d_localVars ? "" : "*";
            int returnType = this.d_m.getReturnType().getDetailedType();
            if (returnType != 0) {
                this.translateArg(returnType, RETURN_VAR, "", sidlToPython, false, false);
            }
            Iterator i = this.d_m.getArgumentList().iterator();
            while (i.hasNext()) {
                Argument arg = (Argument)i.next();
                int mode = arg.getMode();
                if (mode == 0) continue;
                this.translateArg(arg.getType().getDetailedType(), arg.getFormalName(), getValue, sidlToPython, false, arg.getType().isRarray());
            }
        }
    }

    public static List extractOut(Type returnType, List argList) {
        Iterator args = argList.iterator();
        ArrayList<Argument> outList = new ArrayList<Argument>(argList.size() + 1);
        if (returnType.getDetailedType() != 0) {
            outList.add(new Argument(false, 2, returnType, RETURN_VAR));
        }
        while (args.hasNext()) {
            Argument arg = (Argument)args.next();
            if (arg.getMode() == 0) continue;
            outList.add(arg);
        }
        return outList;
    }

    public void convertPythonToSidl(String arg) throws CodeGenerationException {
        if (this.d_convertIncoming || TranslateArguments.extractOut(this.d_m.getReturnType(), this.d_m.getArgumentList()).size() > 0) {
            this.d_lw.println("PyArg_ParseTuple(" + arg + ", ");
            this.d_lw.tab();
            this.outputFormatString(false);
            this.outputParameters(false);
            this.d_lw.println(");");
            this.d_lw.backTab();
        } else {
            this.d_lw.println("(" + arg + " == Py_None);");
        }
    }

    public void convertPythonToSidl(String arg, String kwDict, String kwList) throws CodeGenerationException {
        this.d_lw.println("PyArg_ParseTupleAndKeywords(");
        this.d_lw.tab();
        this.d_lw.println(arg + ", " + kwDict + ", ");
        this.outputFormatString(false);
        this.d_lw.print(", " + kwList);
        this.outputParameters(false);
        this.d_lw.println(");");
        this.d_lw.backTab();
    }

    public void convertSidlToPython() throws CodeGenerationException {
        this.d_lw.println("Py_BuildValue(");
        this.d_lw.tab();
        this.outputFormatString(true);
        this.outputParameters(true);
        this.d_lw.println(");");
        this.d_lw.backTab();
    }

    public void declareProxy(Type t, String name, int mode) throws CodeGenerationException {
        if (TranslateArguments.hasProxy(t, mode == 1, this.d_isClient)) {
            int typeCode = t.getDetailedType();
            switch (typeCode) {
                case 16: {
                    if (!t.isRarray()) break;
                    this.d_lw.println(IOR.getReturnString(t) + TranslateArguments.proxyVariable(name) + " = NULL;");
                    break;
                }
                case 1: {
                    this.d_lw.println("int " + TranslateArguments.proxyVariable(name) + ";");
                    break;
                }
                case 10: {
                    this.d_lw.println("const char *" + TranslateArguments.proxyVariable(name) + " = NULL;");
                    break;
                }
                case 3: {
                    this.d_lw.println("Py_complex " + TranslateArguments.proxyVariable(name) + ";");
                    break;
                }
                case 5: {
                    this.d_lw.println("Py_complex " + TranslateArguments.proxyVariable(name) + ";");
                    break;
                }
                case 7: 
                case 11: {
                    this.d_lw.println("long " + TranslateArguments.proxyVariable(name) + ";");
                    break;
                }
                case 8: {
                    this.d_lw.printlnUnformatted("#ifdef HAVE_LONG_LONG");
                    this.d_lw.println("long long int " + TranslateArguments.proxyVariable(name) + ";");
                    this.d_lw.printlnUnformatted("#else");
                    this.d_lw.println("long " + TranslateArguments.proxyVariable(name) + ";");
                    this.d_lw.printlnUnformatted("#endif");
                }
            }
        }
    }

    public void declareProxies() throws CodeGenerationException {
        Iterator i = this.d_m.getArgumentList().iterator();
        while (i.hasNext()) {
            Argument arg = (Argument)i.next();
            this.declareProxy(arg.getType(), arg.getFormalName(), arg.getMode());
        }
    }
}

