/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.rmi;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.Utilities;
import gov.llnl.babel.backend.c.C;
import gov.llnl.babel.backend.rmi.RMI;
import gov.llnl.babel.backend.writers.LanguageWriter;
import gov.llnl.babel.backend.writers.LanguageWriterForC;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Class;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolTable;
import gov.llnl.babel.symbols.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class RMIIORSource {
    private static int s_longestBuiltin;
    private static final String s_deleteBuiltin;
    private static final String s_castBuiltin;
    private static final String s_execBuiltin;
    private static final String s_superBuiltin = "_super";
    SymbolID d_baseClass = null;
    SymbolID d_classInfo = null;
    SymbolID d_classInfoI = null;
    private LanguageWriterForC d_writer;

    public static void generateCode(Symbol symbol, LanguageWriterForC writer) throws CodeGenerationException {
        RMIIORSource source = new RMIIORSource(writer);
        source.generateCode(symbol);
    }

    public RMIIORSource(LanguageWriterForC writer) {
        this.d_writer = writer;
    }

    public void generateCode(Symbol symbol) throws CodeGenerationException {
        if (symbol != null) {
            switch (symbol.getSymbolType()) {
                case 11: 
                case 13: 
                case 14: {
                    break;
                }
                case 12: {
                    this.generateSource((Class)symbol);
                }
            }
        }
    }

    private void lookupSymbolIDs() {
        SymbolTable table = SymbolTable.getInstance();
        this.d_baseClass = table.lookupSymbol(BabelConfiguration.getBaseClass()).getSymbolID();
        this.d_classInfo = table.lookupSymbol(BabelConfiguration.getClassInfo()).getSymbolID();
        this.d_classInfoI = table.lookupSymbol(BabelConfiguration.getClassInfoI()).getSymbolID();
    }

    private void generateSource(Class cls) throws CodeGenerationException {
        this.generateMethodExecs(cls);
    }

    private void generateMainExec(Class cls) {
        SymbolID id = cls.getSymbolID();
        String my_symbolName = IOR.getSymbolName(id);
        this.d_writer.println("struct " + my_symbolName + "__method {");
        this.d_writer.tab();
        this.d_writer.println("const char *d_name;");
        this.d_writer.println("void (*d_func)(struct " + my_symbolName + "__object*,");
        this.d_writer.tab();
        this.d_writer.println("struct sidl_io_Deserializer__object *,");
        this.d_writer.println("struct sidl_io_Serializer__object *);");
        this.d_writer.backTab();
        this.d_writer.backTab();
        this.d_writer.println("};");
        this.d_writer.println();
        this.d_writer.println("void");
        this.d_writer.println(my_symbolName + "__exec( struct " + my_symbolName + "__object* self,");
        this.d_writer.println("        const char* methodName,");
        this.d_writer.println("        struct sidl_io_Deserializer__object* inArgs,");
        this.d_writer.println("        struct sidl_io_Serializer__object* outArgs ) { ");
        this.d_writer.tab();
        ArrayList methods = new ArrayList(cls.getMethods(true));
        Collections.sort(methods, new CompareMethods());
        this.d_writer.println("static const struct " + my_symbolName + "__method  s_methods[] = {");
        this.d_writer.tab();
        Iterator i = methods.iterator();
        while (i.hasNext()) {
            Method m = (Method)i.next();
            this.d_writer.println("{ \"" + m.getLongMethodName() + "\", " + my_symbolName + '_' + m.getLongMethodName() + "__exec }" + (i.hasNext() ? "," : ""));
        }
        this.d_writer.backTab();
        this.d_writer.println("};");
        this.d_writer.println("int i, cmp, l = 0;");
        this.d_writer.println("int u = sizeof(s_methods)/sizeof(struct " + my_symbolName + "__method);");
        this.d_writer.println("if (methodName) {");
        this.d_writer.tab();
        this.d_writer.writeCommentLine("Use binary search to locate method");
        this.d_writer.println("while (l < u) {");
        this.d_writer.tab();
        this.d_writer.println("i = (l + u) >> 1;");
        this.d_writer.println("if (!(cmp=strcmp(methodName, s_methods[i].d_name))) {");
        this.d_writer.tab();
        this.d_writer.println("(s_methods[i].d_func)(self, inArgs, outArgs);");
        this.d_writer.println("return;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println("else if (cmp < 0) u = i;");
        this.d_writer.println("else l = i + 1;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.writeCommentLine("TODO: add code for method not found");
        this.d_writer.backTab();
        this.d_writer.println("}");
    }

    private void generateMethodExecs(Class cls) throws CodeGenerationException {
        SymbolID id = cls.getSymbolID();
        String my_symbolName = IOR.getSymbolName(id);
        Collection c = cls.getMethods(true);
        String self = C.getObjectName(id) + " self";
        String baseExcVar = "_ex";
        String mainExcVar = "_ex2";
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Argument arg;
            Iterator a;
            Method m = (Method)i.next();
            boolean hasThrows = !m.getThrows().isEmpty();
            String name = m.getLongMethodName();
            Type returnType = m.getReturnType();
            this.d_writer.println("static void");
            this.d_writer.println(my_symbolName + "_" + name + "__exec(");
            this.d_writer.println("        struct " + my_symbolName + "__object* self,");
            this.d_writer.println("        struct sidl_io_Deserializer__object* inArgs,");
            this.d_writer.println("        struct sidl_io_Serializer__object* outArgs) {");
            this.d_writer.tab();
            this.comment("stack space for arguments");
            ArrayList args = m.getArgumentList();
            int numSerialized = args.size();
            boolean hasArgs = numSerialized > 0;
            boolean hasReturn = returnType.getType() != 0;
            Iterator a2 = args.iterator();
            while (a2.hasNext()) {
                Argument arg2 = (Argument)a2.next();
                if (arg2.getType().getType() == 10 && arg2.getMode() == 0) {
                    this.d_writer.println(IOR.getReturnString(arg2.getType()) + " " + arg2.getFormalName() + "= NULL;");
                    continue;
                }
                if (arg2.getType().getDetailedType() >= 12) {
                    if (arg2.getMode() == 0) {
                        this.d_writer.println(IOR.getReturnString(arg2.getType()) + " " + arg2.getFormalName() + "= NULL;");
                        continue;
                    }
                    this.d_writer.println(IOR.getReturnString(arg2.getType()) + " " + arg2.getFormalName() + "_tmp = NULL;");
                    this.d_writer.println(IOR.getReturnString(arg2.getType()) + "* " + arg2.getFormalName() + " = &" + arg2.getFormalName() + "_tmp;");
                    continue;
                }
                if (arg2.getMode() == 0) {
                    this.d_writer.println(IOR.getArgumentWithFormal(arg2, true, false, true) + ";");
                    continue;
                }
                this.d_writer.println(IOR.getArgumentWithFormal(arg2, true, false, true) + "_tmp;");
                this.d_writer.println(IOR.getArgumentWithFormal(arg2, true, false, false) + "= &" + arg2.getFormalName() + "_tmp;");
            }
            if (hasReturn) {
                ++numSerialized;
                this.d_writer.println(RMIIORSource.getReturnString(returnType) + " _retval;");
            }
            boolean allObj = true;
            if (returnType.getType() != 0 && returnType.getType() < 12) {
                allObj = false;
            }
            if (allObj) {
                a = args.iterator();
                while (a.hasNext()) {
                    arg = (Argument)a.next();
                    if (arg.getType().getType() >= 12) continue;
                    allObj = false;
                }
            }
            if ((hasReturn || hasArgs) && !allObj || hasThrows) {
                this.d_writer.println("sidl_BaseInterface " + baseExcVar + "   = " + "NULL" + ";");
                this.d_writer.println("sidl_BaseInterface *" + mainExcVar + " = " + "&" + baseExcVar + ";");
            }
            this.comment("unpack in and inout argments");
            a = args.iterator();
            while (a.hasNext()) {
                arg = (Argument)a.next();
                if (arg.getType().isArray() || arg.getType().isSymbol() || arg.getType().getType() == 9) continue;
                if (arg.getMode() == 0) {
                    this.d_writer.println(RMI.unpackType("sidl_io_Deserializer", "inArgs", arg.getType(), arg.getFormalName(), "&" + arg.getFormalName()));
                }
                if (arg.getMode() != 1) continue;
                this.d_writer.println(RMI.unpackType("sidl_io_Deserializer", "inArgs", arg.getType(), arg.getFormalName(), arg.getFormalName()));
            }
            this.d_writer.println();
            this.comment("make the call");
            if (returnType.getType() != 0) {
                this.d_writer.print("_retval = ");
            }
            if (m.isStatic()) {
                this.d_writer.print("(" + IOR.getStaticEPVVariable(id, 3, 0) + "." + IOR.getVectorEntry(m.getLongMethodName()) + ")");
            } else {
                this.d_writer.print("(self->" + IOR.getEPVVar(0) + "->" + IOR.getVectorEntry(m.getLongMethodName()) + ")");
            }
            this.d_writer.println("(");
            this.d_writer.tab();
            C.generateArgumentList(this.d_writer, self, false, id, m, false, false, false, hasThrows ? mainExcVar : "", false, false, false);
            this.d_writer.println(");");
            this.d_writer.backTab();
            this.d_writer.println();
            if (hasThrows) {
                this.comment("check if exception thrown");
                this.comment("FIXME");
                this.d_writer.println();
            }
            this.comment("pack return value");
            if (!returnType.isArray() && !returnType.isSymbol() && returnType.getType() != 9 && returnType.getType() != 0) {
                this.d_writer.println(RMI.packType("sidl_io_Serializer", "outArgs", returnType, "_retval", "_retval"));
                this.d_writer.println();
            }
            this.comment("pack out and inout argments");
            a = args.iterator();
            while (a.hasNext()) {
                arg = (Argument)a.next();
                if (arg.getType().isArray() || arg.getType().isSymbol() || arg.getType().getType() == 9 || arg.getMode() != 2 && arg.getMode() != 1) continue;
                this.d_writer.println(RMI.packType("sidl_io_Serializer", "outArgs", arg.getType(), arg.getFormalName(), "*" + arg.getFormalName()));
            }
            this.d_writer.println();
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println("");
        }
    }

    private static String getReturnString(Type type) throws CodeGenerationException {
        return IOR.getReturnString(type, true, false);
    }

    private void comment(String s) {
        this.d_writer.writeCommentLine(s);
    }

    private void generateStaticVariables(Class cls) {
        this.comment("Static variables to hold version of IOR");
        this.d_writer.println("static const int32_t s_IOR_MAJOR_VERSION = 0;");
        this.d_writer.println("static const int32_t s_IOR_MINOR_VERSION = 9;");
        this.d_writer.println();
        if (!cls.isAbstract()) {
            // empty if block
        }
        this.comment("Static variables for managing EPV initialization.");
        boolean has_static = cls.hasStaticMethod(true);
        this.d_writer.println("static int s_remote_initialized = 0;");
        if (has_static) {
            this.d_writer.println("static int s_static_initialized = 0;");
        }
        this.d_writer.println();
        IOR.generateStaticEPVVariables(this.d_writer, cls, has_static, false, 0);
        this.d_writer.println();
        Set parents = Utilities.getAllParents(cls);
        Set new_interfaces = Utilities.getUniqueInterfaceIDs(cls);
        if (!parents.isEmpty()) {
            ArrayList sorted = Utilities.sort(parents);
            Iterator i = sorted.iterator();
            while (i.hasNext()) {
                SymbolID p_id = (SymbolID)i.next();
                String p_name = IOR.getSymbolName(p_id);
                String p_lower = p_name.toLowerCase();
                String p_epv = "static " + IOR.getEPVName(p_id);
                boolean is_old = !new_interfaces.contains(p_id);
                String p_epvStr = is_old ? p_epv + "  " : p_epv + " ";
                this.d_writer.print(p_epvStr);
                this.d_writer.println(IOR.getStaticEPVVariable(p_id, 2, 0) + ";");
            }
        }
    }

    private void generateExternalReferences(Class cls) {
        this.comment("Declare EPV routines defined in the skeleton file.");
        SymbolID id = cls.getSymbolID();
        this.d_writer.openCxxExtern();
        this.d_writer.println("extern void " + IOR.getSetEPVName(id) + "(");
        this.d_writer.tab();
        this.d_writer.println(IOR.getEPVName(id) + "* epv);");
        this.d_writer.backTab();
        if (cls.hasStaticMethod(true)) {
            this.d_writer.println("extern void " + IOR.getSetSEPVName(id) + "(");
            this.d_writer.tab();
            this.d_writer.println(IOR.getSEPVName(id) + "* sepv);");
            this.d_writer.backTab();
        }
        this.d_writer.println("extern void " + IOR.getCallLoadName(id) + "(void);");
        this.d_writer.closeCxxExtern();
        this.d_writer.println();
    }

    private void generateCastFunction(Class cls) {
        this.comment("CAST: dynamic type casting support.");
        SymbolID id = cls.getSymbolID();
        this.d_writer.println("static void* ior_" + IOR.getSymbolName(id) + '_' + s_castBuiltin + '(');
        this.d_writer.tab();
        this.d_writer.println(IOR.getObjectName(id) + "* self,");
        this.d_writer.println("const char* name)");
        this.d_writer.backTab();
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.println("void* cast = NULL;");
        this.d_writer.println();
        this.generateParentSelf(cls, 0, 0);
        this.d_writer.println();
        this.generateCastLogic(cls, 0);
        this.d_writer.println();
        this.d_writer.println("return cast;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void generateCastLogic(Class cls, int level) {
        String self = "s" + String.valueOf(level);
        if (level > 0) {
            this.d_writer.print("} else ");
        }
        this.d_writer.println("if (!strcmp(name, \"" + cls.getFullName() + "\")) {");
        this.d_writer.tab();
        this.d_writer.println("cast = (void*) " + self + ";");
        this.d_writer.backTab();
        ArrayList interfaces = Utilities.sort(Utilities.getUniqueInterfaceIDs(cls));
        Iterator i = interfaces.iterator();
        while (i.hasNext()) {
            SymbolID id = (SymbolID)i.next();
            String fn = id.getFullName();
            String lower = IOR.getSymbolName(id).toLowerCase();
            this.d_writer.println("} else if (!strcmp(name, \"" + fn + "\")) {");
            this.d_writer.tab();
            this.d_writer.println("cast = (void*) &" + self + "->d_" + lower + ";");
            this.d_writer.backTab();
        }
        Class parent = cls.getParentClass();
        if (parent != null) {
            this.generateCastLogic(parent, level + 1);
        } else {
            this.d_writer.println("}");
        }
    }

    private void generateDeleteFunction(Class cls) {
        this.comment("DELETE: call destructor and free object memory.");
        SymbolID id = cls.getSymbolID();
        String name = IOR.getSymbolName(id);
        this.d_writer.println("static void ior_" + name + '_' + s_deleteBuiltin + '(');
        this.d_writer.tab();
        this.d_writer.println(IOR.getObjectName(id) + "* self)");
        this.d_writer.backTab();
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.println(IOR.getFiniName(id) + "(self);");
        this.d_writer.println("memset((void*)self, 0, sizeof(" + IOR.getObjectName(id) + "));");
        this.d_writer.println("free((void*) self);");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void generateSuperFunction(Class cls) {
        this.comment("SUPER: return's parent's non-overrided EPV");
        SymbolID id = cls.getSymbolID();
        String name = IOR.getSymbolName(id);
        Class parent = cls.getParentClass();
        if (parent != null) {
            SymbolID pid = parent.getSymbolID();
            this.d_writer.println("static " + IOR.getEPVName(pid) + "* " + IOR.getSymbolName(id) + '_' + s_superBuiltin + "(void) {");
            this.d_writer.tab();
            this.d_writer.println("return " + IOR.getStaticEPVVariable(id, 1, 0) + ';');
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println();
        }
    }

    private void generateInitEPV(Class cls) throws CodeGenerationException {
        this.comment("EPV: create method entry point vector (EPV) structure.");
        SymbolID id = cls.getSymbolID();
        String name = IOR.getSymbolName(id);
        String object = IOR.getObjectName(id);
        this.d_writer.println("static void " + name + "__init_epv(");
        this.d_writer.tab();
        this.comment("assert( " + IOR.getHaveLockStaticGlobalsMacroName() + " );");
        this.d_writer.println(object + "* self)");
        this.d_writer.backTab();
        this.d_writer.println("{");
        this.d_writer.tab();
        if (cls.getParentClass() != null) {
            this.generateParentSelf(cls, 0, 0);
            this.d_writer.println();
        }
        ArrayList parents = Utilities.sort(Utilities.getAllParents(cls));
        Class parent = cls.getParentClass();
        if (parent != null) {
            this.saveEPVs(parent, 1);
        }
        List methods = (List)cls.getNonstaticMethods(true);
        int mwidth = Math.max(Utilities.getWidth(methods), s_longestBuiltin) + IOR.getVectorEntry("").length();
        for (int j = 0; j < 10; ++j) {
            if (j == 5) continue;
            String mname = IOR.getBuiltinName(j);
            this.d_writer.print("epv->");
            this.d_writer.printAligned(IOR.getVectorEntry(mname), mwidth);
            if (0 == j || 1 == j) {
                this.d_writer.println(" = ior_" + name + '_' + mname + ';');
                continue;
            }
            this.d_writer.println(" = NULL;");
        }
        Iterator i = methods.iterator();
        while (i.hasNext()) {
            Method method = (Method)i.next();
            String mname = method.getLongMethodName();
            this.d_writer.print("epv->");
            this.d_writer.printAligned(IOR.getVectorEntry(mname), mwidth);
            if (parent != null && parent.hasMethodByLongName(mname, true)) {
                this.d_writer.print(" = ");
                this.d_writer.print(IOR.getCast(method, object + "*"));
                this.d_writer.println(" s1->" + IOR.getEPVVar(0) + "->" + IOR.getVectorEntry(mname) + ";");
                continue;
            }
            this.d_writer.println(" = NULL;");
        }
        this.d_writer.println();
        this.copyEPVs(parents);
        this.d_writer.println("s_method_initialized = 1;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void generateInitSEPV(Class cls) {
        if (cls.hasStaticMethod(true)) {
            int w;
            boolean includeParent;
            this.comment("SEPV: create the static entry point vector (SEPV).");
            SymbolID id = cls.getSymbolID();
            String name = IOR.getSymbolName(id);
            String lower = name.toLowerCase();
            int width = name.length();
            this.d_writer.println("static void " + name + "__init_sepv(void)");
            this.d_writer.println("{");
            this.d_writer.tab();
            this.comment("assert( " + IOR.getHaveLockStaticGlobalsMacroName() + " );");
            Class parent = cls.getParentClass();
            SymbolID pid = null;
            boolean bl = includeParent = parent != null && parent.hasStaticMethod(true);
            if (includeParent && (w = IOR.getSymbolName(pid = parent.getSymbolID()).length()) > width) {
                width = w;
            }
            this.d_writer.printAligned(IOR.getSEPVName(id) + "*", width += "struct __sepv*".length());
            this.d_writer.println(" s = &" + IOR.getStaticEPVVariable(pid, 3, 0) + ";");
            if (includeParent) {
                this.d_writer.printAligned(IOR.getSEPVName(pid) + "*", width);
                this.d_writer.println(" p = " + IOR.getStaticsName(pid) + "();");
            }
            this.d_writer.println();
            List methods = (List)cls.getStaticMethods(true);
            int mwidth = Utilities.getWidth(methods) + IOR.getVectorEntry("").length();
            Iterator i = methods.iterator();
            while (i.hasNext()) {
                Method method = (Method)i.next();
                String mname = method.getLongMethodName();
                this.d_writer.print("s->");
                this.d_writer.printAligned(IOR.getVectorEntry(mname), mwidth);
                if (parent != null && parent.hasMethodByLongName(mname, true)) {
                    this.d_writer.println(" = p->" + IOR.getVectorEntry(mname) + ";");
                    continue;
                }
                this.d_writer.println(" = NULL;");
            }
            this.d_writer.println();
            this.d_writer.println(IOR.getSetSEPVName(id) + "(s);");
            this.d_writer.println();
            this.d_writer.println("s_static_initialized = 1;");
            this.d_writer.println("ior_" + name + "__ensure_load_called();");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println();
        }
    }

    private void generateEnsureLoad(Class cls) {
        SymbolID id = cls.getSymbolID();
        String name = IOR.getSymbolName(id);
        String lower = name.toLowerCase();
        this.d_writer.println("static void ior_" + name + "__ensure_load_called(void) " + "{");
        this.d_writer.tab();
        this.comment("assert( " + IOR.getHaveLockStaticGlobalsMacroName() + " );");
        this.d_writer.println("if (! s_load_called ) {");
        this.d_writer.tab();
        this.d_writer.println(name + "__call_load();");
        this.d_writer.println("s_load_called=1;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("}");
    }

    private void generateStaticFunction(Class cls) {
        if (cls.hasStaticMethod(true)) {
            this.comment("STATIC: return static EPV structure for static methods.");
            SymbolID id = cls.getSymbolID();
            String name = IOR.getSymbolName(id);
            String lower = name.toLowerCase();
            this.d_writer.println(IOR.getSEPVName(id) + "*");
            this.d_writer.println(IOR.getStaticsName(id) + "(void)");
            this.d_writer.println("{");
            this.d_writer.tab();
            this.d_writer.println(IOR.getLockStaticGlobalsMacroName() + ";");
            this.d_writer.println("if (!s_static_initialized) {");
            this.d_writer.tab();
            this.d_writer.println(name + "__init_sepv();");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println(IOR.getUnlockStaticGlobalsMacroName() + ";");
            this.d_writer.println("return &" + IOR.getStaticEPVVariable(id, 3, 0) + ";");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println();
        }
    }

    private void generateInitClassInfo(Class cls) {
        if (!cls.isAbstract()) {
            if (this.d_classInfoI.equals(cls.getSymbolID())) {
                this.d_writer.println("static void initMetadata(" + IOR.getObjectName(cls.getSymbolID()) + "*);");
                this.d_writer.println();
            }
            this.comment("initClassInfo: create a ClassInfo interface if necessary.");
            this.d_writer.println("static void");
            this.d_writer.println("initClassInfo(" + C.getObjectName(this.d_classInfo) + " *info)");
            this.d_writer.println("{");
            this.d_writer.tab();
            if (!this.d_classInfoI.equals(cls.getSymbolID())) {
                this.d_writer.println(IOR.getLockStaticGlobalsMacroName() + ";");
            } else {
                this.d_writer.writeCommentLine("ClassInfo for ClassInfoI is a special case");
                this.d_writer.writeCommentLine(IOR.getUnlockStaticGlobalsMacroName() + ";");
            }
            this.d_writer.println("if (s_classInfo_init) {");
            this.d_writer.tab();
            this.d_writer.println(C.getObjectName(this.d_classInfoI) + " impl;");
            this.d_writer.println("s_classInfo_init = 0;");
            this.d_writer.println("impl = " + C.getFullMethodName(this.d_classInfoI, "_create") + "();");
            this.d_writer.println("s_classInfo = " + C.getFullMethodName(this.d_classInfo, "_cast") + "(impl);");
            this.d_writer.println("if (impl) {");
            this.d_writer.tab();
            this.d_writer.println(C.getFullMethodName(this.d_classInfoI, "setName") + "(impl, \"" + cls.getFullName() + "\");");
            this.d_writer.println(C.getFullMethodName(this.d_classInfoI, "setIORVersion") + "(impl, s_IOR_MAJOR_VERSION, s_IOR_MINOR_VERSION);");
            if (this.d_classInfoI.equals(cls.getSymbolID())) {
                this.d_writer.println("initMetadata(impl);");
            }
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println("if (s_classInfo) {");
            this.d_writer.tab();
            this.d_writer.println("if (*info) {");
            this.d_writer.tab();
            this.d_writer.println(C.getFullMethodName(this.d_classInfo, "deleteRef") + "(*info);");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println("*info = s_classInfo;");
            this.d_writer.println(C.getFullMethodName(this.d_classInfo, "addRef") + "(*info);");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.backTab();
            if (!this.d_classInfoI.equals(cls.getSymbolID())) {
                this.d_writer.println(IOR.getUnlockStaticGlobalsMacroName() + ";");
            } else {
                this.d_writer.writeCommentLine("ClassInfo for ClassInfoI is a special case");
                this.d_writer.writeCommentLine(IOR.getUnlockStaticGlobalsMacroName() + ";");
            }
            this.d_writer.println("}");
            this.d_writer.println();
        }
    }

    private void generateInitMetadata(Class cls) {
        if (!cls.isAbstract()) {
            SymbolID id = cls.getSymbolID();
            String object = IOR.getObjectName(id);
            this.comment("initMetadata: store IOR version & class in sidl.BaseClass's data");
            this.d_writer.println("static void");
            this.d_writer.println("initMetadata(" + object + "* self)");
            this.d_writer.println("{");
            this.d_writer.tab();
            this.d_writer.println("if (self) {");
            this.d_writer.tab();
            this.d_writer.println(C.getDataName(this.d_baseClass) + " *data = " + C.getDataGetName(this.d_baseClass) + "(" + C.getFullMethodName(this.d_baseClass, "_cast") + "(self));");
            this.d_writer.println("if (data) {");
            this.d_writer.tab();
            this.d_writer.println("data->d_IOR_major_version = s_IOR_MAJOR_VERSION;");
            this.d_writer.println("data->d_IOR_minor_version = s_IOR_MINOR_VERSION;");
            this.d_writer.println("initClassInfo(&(data->d_classinfo));");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println();
        }
    }

    private void generateNewFunction(Class cls) {
        if (!cls.isAbstract()) {
            this.comment("NEW: allocate object and initialize it.");
            SymbolID id = cls.getSymbolID();
            String object = IOR.getObjectName(id);
            this.d_writer.println(object + "*");
            this.d_writer.println(IOR.getNewName(id) + "(void)");
            this.d_writer.println("{");
            this.d_writer.tab();
            this.d_writer.println(object + "* self =");
            this.d_writer.tab();
            this.d_writer.println("(" + object + "*) malloc(");
            this.d_writer.tab();
            this.d_writer.println("sizeof(" + object + "));");
            this.d_writer.backTab();
            this.d_writer.backTab();
            this.d_writer.println(IOR.getInitName(id) + "(self);");
            this.d_writer.println("initMetadata(self);");
            this.d_writer.println("return self;");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println();
        }
    }

    private void generateInitFunction(Class cls) {
        this.comment("INIT: initialize a new instance of the class object.");
        SymbolID id = cls.getSymbolID();
        this.d_writer.println("void " + IOR.getInitName(id) + "(");
        this.d_writer.tab();
        this.d_writer.println(IOR.getObjectName(id) + "* self)");
        this.d_writer.backTab();
        this.d_writer.println("{");
        this.d_writer.tab();
        this.generateParentSelf(cls, 0, 0);
        this.d_writer.println();
        Class parent = cls.getParentClass();
        if (parent != null) {
            String p = IOR.getSymbolName(parent.getSymbolID());
            this.d_writer.println(IOR.getInitName(parent.getSymbolID()) + "(s1);");
            this.d_writer.println();
        }
        this.d_writer.println(IOR.getLockStaticGlobalsMacroName() + ";");
        this.d_writer.println("if (!s_method_initialized) {");
        this.d_writer.tab();
        this.d_writer.println(IOR.getSymbolName(id) + "__init_epv(s0);");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println(IOR.getUnlockStaticGlobalsMacroName() + ";");
        this.d_writer.println();
        this.fixEPVs(cls, 0, true);
        ArrayList interfaces = Utilities.sort(Utilities.getUniqueInterfaceIDs(cls));
        Iterator i = interfaces.iterator();
        while (i.hasNext()) {
            SymbolID iid = (SymbolID)i.next();
            String n = IOR.getSymbolName(iid).toLowerCase();
            this.d_writer.println("s0->d_" + n + ".d_object = self;");
            this.d_writer.println();
        }
        this.d_writer.println("s0->d_data = NULL;");
        this.d_writer.println();
        this.d_writer.println(RMIIORSource.methodCall(cls, "self", IOR.getBuiltinName(3), ""));
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void generateFiniFunction(Class cls) {
        this.comment("FINI: deallocate a class instance (destructor).");
        SymbolID id = cls.getSymbolID();
        this.d_writer.println("void " + IOR.getFiniName(id) + "(");
        this.d_writer.tab();
        this.d_writer.println(IOR.getObjectName(id) + "* self)");
        this.d_writer.backTab();
        this.d_writer.println("{");
        this.d_writer.tab();
        this.generateParentSelf(cls, 0, 0);
        this.d_writer.println();
        this.d_writer.println(RMIIORSource.methodCall(cls, "s0", IOR.getBuiltinName(4), ""));
        Class parent = cls.getParentClass();
        if (parent != null) {
            this.d_writer.println();
            this.fixEPVs(parent, 1, false);
            String p = IOR.getSymbolName(parent.getSymbolID());
            this.d_writer.println(IOR.getFiniName(parent.getSymbolID()) + "(s1);");
        }
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void generateVersionFunction(Class cls) {
        this.comment("VERSION: Return the version of the IOR used to generate this IOR.");
        SymbolID id = cls.getSymbolID();
        this.d_writer.println("void");
        this.d_writer.println(IOR.getVersionName(id) + "(int32_t *major, int32_t *minor" + ")");
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.println("*major = s_IOR_MAJOR_VERSION;");
        this.d_writer.println("*minor = s_IOR_MINOR_VERSION;");
        this.d_writer.backTab();
        this.d_writer.println("}");
    }

    private void generateRemoteCastFunction(Class cls) {
        this.comment("REMOTE CAST: dynamic type casting for remote objects.");
        SymbolID id = cls.getSymbolID();
        String name = IOR.getSymbolName(id);
        this.d_writer.println("static void* remote_" + name + '_' + s_castBuiltin + '(');
        this.d_writer.tab();
        if (cls.isInterface()) {
            this.d_writer.println("void* self,");
        } else {
            this.d_writer.println(IOR.getObjectName(id) + "* self,");
        }
        this.d_writer.println("const char* name)");
        this.d_writer.backTab();
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.println("return NULL;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void generateRemoteDeleteFunction(Class cls) {
        this.comment("REMOTE DELETE: call the remote destructor for the object.");
        SymbolID id = cls.getSymbolID();
        String name = IOR.getSymbolName(id);
        this.d_writer.println("static void remote_" + name + '_' + s_deleteBuiltin + '(');
        this.d_writer.tab();
        if (cls.isInterface()) {
            this.d_writer.println("void* self)");
        } else {
            this.d_writer.println(IOR.getObjectName(id) + "* self)");
        }
        this.d_writer.backTab();
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.println("free((void*) self);");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void generateRemoteExecFunction(Class cls) {
        this.comment("REMOTE EXEC: call remote exec for the object.");
        SymbolID id = cls.getSymbolID();
        String name = IOR.getSymbolName(id);
        this.d_writer.println("static void remote_" + name + '_' + s_execBuiltin + '(');
        this.d_writer.tab();
        if (cls.isInterface()) {
            this.d_writer.println("void* self)");
        } else {
            this.d_writer.println(IOR.getObjectName(id) + "* self)");
        }
        this.d_writer.backTab();
        this.d_writer.println("{");
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void generateRemoteMethodBodies(Class cls) throws CodeGenerationException {
        SymbolID id = cls.getSymbolID();
        String name = IOR.getSymbolName(id);
        String object = IOR.getObjectName(id);
        Iterator m = cls.getNonstaticMethods(true).iterator();
        while (m.hasNext()) {
            Method method = (Method)m.next();
            String method_name = method.getLongMethodName();
            Type returnType = method.getReturnType();
            this.comment("REMOTE METHOD STUB:" + method_name);
            this.d_writer.println("static " + RMIIORSource.getReturnString(returnType));
            this.d_writer.println("remote_" + name + "_" + method_name + "(");
            this.d_writer.tab();
            boolean hasThrows = !method.getThrows().isEmpty();
            C.generateArgumentList(this.d_writer, "self", false, id, method, true, true, true, hasThrows, false, false, false);
            this.d_writer.println(")");
            this.d_writer.backTab();
            this.d_writer.println("{");
            this.d_writer.tab();
            if (method_name.compareTo("addRef") == 0) {
                this.comment("FIXME  need to think through all of these special cases");
            } else if (method_name.compareTo("isSame") == 0 || method_name.compareTo("queryInt") == 0 || method_name.compareTo("isType") == 0 || method_name.compareTo("getClassInfo") == 0) {
                this.comment("FIXME  need to think through all of these special cases");
                this.d_writer.println("return 0;");
            } else if (method_name.compareTo("deleteRef") == 0) {
                this.d_writer.println("sidl_rmi_InstanceHandle conn = (sidl_rmi_InstanceHandle)self->d_data;");
                this.d_writer.println("self->d_data = NULL;");
                this.d_writer.println("sidl_rmi_InstanceHandle_close(conn);");
                this.d_writer.println("sidl_rmi_InstanceHandle_deleteRef(conn);");
            } else {
                Argument arg;
                this.comment("initialize a new invocation");
                this.d_writer.println("sidl_rmi_InstanceHandle conn = (sidl_rmi_InstanceHandle)self->d_data;");
                this.d_writer.println("sidl_rmi_Invocation inv = sidl_rmi_InstanceHandle_createInvocation( conn, \"" + method_name + "\" );");
                this.d_writer.println("sidl_rmi_Response rsvp = NULL;");
                if (hasThrows) {
                    this.d_writer.println("sidl_BaseInterface *_ex2 =_ex;");
                }
                if (returnType.getType() != 0) {
                    this.d_writer.println(RMIIORSource.getReturnString(returnType) + " _retval;");
                }
                this.d_writer.println();
                this.comment("pack in and inout arguments");
                ArrayList args = method.getArgumentList();
                Iterator a = args.iterator();
                while (a.hasNext()) {
                    arg = (Argument)a.next();
                    if (arg.getType().isArray() || arg.getType().isSymbol() || arg.getType().getType() == 9 || arg.getMode() != 0 && arg.getMode() != 1) continue;
                    this.d_writer.println(RMI.packArg("sidl_rmi_Invocation", "inv", arg));
                }
                this.d_writer.println();
                this.comment("send actual RMI request");
                this.d_writer.println("rsvp = sidl_rmi_Invocation_invokeMethod(inv);");
                this.d_writer.println();
                if (hasThrows) {
                    this.comment("check if exception thrown.");
                    this.comment("FIXME");
                    this.d_writer.println();
                }
                this.comment("extract return value");
                if (!returnType.isArray() && !returnType.isSymbol() && returnType.getType() != 9 && returnType.getType() != 0) {
                    this.d_writer.println(RMI.unpackType("sidl_rmi_Response", "rsvp", returnType, "_retval", "&_retval"));
                }
                this.d_writer.println();
                this.comment("unpack out and inout arguments");
                a = args.iterator();
                while (a.hasNext()) {
                    arg = (Argument)a.next();
                    if (arg.getType().isArray() || arg.getType().isSymbol() || arg.getType().getType() == 9 || arg.getMode() != 2 && arg.getMode() != 1) continue;
                    this.d_writer.println(RMI.unpackArg("sidl_rmi_Response", "rsvp", arg));
                }
                this.d_writer.println();
                this.comment("cleanup and return");
                this.d_writer.println("sidl_rmi_Response_done(rsvp);");
                this.d_writer.println("sidl_rmi_Invocation_deleteRef(inv);");
                this.d_writer.println("sidl_rmi_Response_deleteRef(rsvp);");
                if (returnType.getType() != 0) {
                    this.d_writer.println("return _retval;");
                }
            }
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println();
        }
    }

    private void generateRemoteInitEPV(Class cls) throws CodeGenerationException {
        this.comment("REMOTE EPV: create remote entry point vectors (EPVs).");
        SymbolID id = cls.getSymbolID();
        String name = IOR.getSymbolName(id);
        String lower = name.toLowerCase();
        this.d_writer.println("static void " + name + "__init_remote_epv(void)");
        this.d_writer.println("{");
        this.d_writer.tab();
        this.comment("assert( " + IOR.getHaveLockStaticGlobalsMacroName() + " );");
        ArrayList parents = null;
        if (cls.isInterface()) {
            this.d_writer.print(IOR.getEPVName(id) + "*");
            this.d_writer.println(" epv = &" + IOR.getStaticEPVVariable(id, 2, 0) + ";");
            this.d_writer.println();
        } else {
            parents = Utilities.sort(Utilities.getAllParents(cls));
            this.aliasEPVs(cls, parents, true);
        }
        List methods = (List)cls.getNonstaticMethods(true);
        int mwidth = Math.max(Utilities.getWidth(methods), s_longestBuiltin) + IOR.getVectorEntry("").length();
        int numBuiltins = cls.isInterface() ? 3 : 10;
        for (int j = 0; j < numBuiltins; ++j) {
            if (j == 5) continue;
            String mname = IOR.getBuiltinName(j);
            this.d_writer.print("epv->");
            this.d_writer.printAligned(IOR.getVectorEntry(mname), mwidth);
            if (0 == j || 1 == j || 2 == j) {
                this.d_writer.println(" = remote_" + name + '_' + mname + ';');
                continue;
            }
            this.d_writer.println(" = NULL;");
        }
        Iterator i = methods.iterator();
        while (i.hasNext()) {
            Method method = (Method)i.next();
            String mname = method.getLongMethodName();
            this.d_writer.print("epv->");
            this.d_writer.printAligned(IOR.getVectorEntry(mname), mwidth);
            this.d_writer.println(" = remote_" + name + "_" + mname + ";");
        }
        if (parents != null) {
            this.d_writer.println();
            this.copyEPVs(parents);
        }
        this.d_writer.println("s_remote_initialized = 1;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void generateRemoteConstructor(Class cls) {
        this.comment("REMOTE: generate remote instance given URL string.");
        SymbolID id = cls.getSymbolID();
        String idName = id.getFullName();
        String name = IOR.getSymbolName(id);
        String lower = name.toLowerCase();
        String object = IOR.getObjectName(id);
        this.d_writer.println("static " + object + "*");
        this.d_writer.println(IOR.getRemoteName(id) + "(const char *url)");
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.println("sidl_rmi_InstanceHandle instance = sidl_rmi_ProtocolFactory_createInstance(url, \"" + idName + "\" );");
        this.d_writer.println("if ( instance == NULL) { return NULL; }");
        this.d_writer.println(object + "* self =");
        this.d_writer.tab();
        this.d_writer.println("(" + object + "*) malloc(");
        this.d_writer.tab();
        this.d_writer.println("sizeof(" + object + "));");
        this.d_writer.backTab();
        this.d_writer.backTab();
        this.d_writer.println();
        if (!cls.isInterface()) {
            this.generateParentSelf(cls, 0, 0);
            this.d_writer.println();
        }
        this.d_writer.println(IOR.getLockStaticGlobalsMacroName() + ";");
        this.d_writer.println("if (!s_remote_initialized) {");
        this.d_writer.tab();
        this.d_writer.println(name + "__init_remote_epv();");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println(IOR.getUnlockStaticGlobalsMacroName() + ";");
        this.d_writer.println();
        if (cls.isInterface()) {
            this.d_writer.println("self->" + IOR.getEPVVar(0) + "    = &" + IOR.getStaticEPVVariable(id, 2, 0) + ";");
            this.d_writer.println("self->d_object = (void*) instance;");
        } else {
            this.remoteEPVs(cls, 0);
            this.d_writer.println("self->d_data = (void*) instance;");
        }
        this.d_writer.println();
        this.d_writer.println("return self;");
        this.d_writer.backTab();
        this.d_writer.println("}");
    }

    private void generateParentSelf(Class cls, int level, int width) {
        if (cls != null) {
            if (width == 0) {
                for (Class parent = cls; parent != null; parent = parent.getParentClass()) {
                    int w = IOR.getObjectName(parent.getSymbolID()).length();
                    if (w <= width) continue;
                    width = w;
                }
            }
            SymbolID id = cls.getSymbolID();
            this.d_writer.printAligned(IOR.getObjectName(id) + "*", width + 1);
            this.d_writer.print(" s" + String.valueOf(level) + " = ");
            if (level == 0) {
                this.d_writer.println("self;");
            } else {
                this.d_writer.print("&s" + String.valueOf(level - 1) + "->d_");
                this.d_writer.println(IOR.getSymbolName(id).toLowerCase() + ";");
            }
            this.generateParentSelf(cls.getParentClass(), level + 1, width);
        }
    }

    private void fixEPVs(Class cls, int level, boolean is_new) {
        if (cls != null) {
            String epvVar = IOR.getEPVVar(0);
            this.fixEPVs(cls.getParentClass(), level + 1, is_new);
            String self = "s" + String.valueOf(level);
            int epvType = is_new ? 0 : 1;
            ArrayList ifce = Utilities.sort(Utilities.getUniqueInterfaceIDs(cls));
            int width = Utilities.getWidth(ifce) + "d_.".length() + epvVar.length();
            Iterator i = ifce.iterator();
            while (i.hasNext()) {
                SymbolID id = (SymbolID)i.next();
                String n = IOR.getSymbolName(id).toLowerCase();
                this.d_writer.print(self + "->");
                this.d_writer.printAligned("d_" + n + "." + epvVar, width);
                this.d_writer.print(" = ");
                if (is_new) {
                    this.d_writer.print("&");
                }
                this.d_writer.println(IOR.getStaticEPVVariable(id, epvType, 0) + ";");
            }
            this.d_writer.print(self + "->");
            this.d_writer.printAligned(epvVar, width);
            this.d_writer.print(" = ");
            if (is_new) {
                this.d_writer.print("&");
            }
            this.d_writer.println(IOR.getStaticEPVVariable(cls.getSymbolID(), epvType, 0) + ";");
            this.d_writer.println();
        }
    }

    private void saveEPVs(Class cls, int level) {
        if (cls != null) {
            String epvVar = IOR.getEPVVar(0);
            this.saveEPVs(cls.getParentClass(), level + 1);
            String self = "s" + String.valueOf(level);
            ArrayList ifce = Utilities.sort(Utilities.getUniqueInterfaceIDs(cls));
            int width = Utilities.getWidth(ifce);
            Iterator i = ifce.iterator();
            while (i.hasNext()) {
                SymbolID id = (SymbolID)i.next();
                String n = IOR.getSymbolName(id).toLowerCase();
                this.d_writer.print(IOR.getStaticEPVVariable(id, 1, 0));
                this.d_writer.printSpaces(width - n.length());
                this.d_writer.println(" = " + self + "->d_" + n + "." + epvVar + ";");
            }
            String lower = IOR.getSymbolName(cls.getSymbolID()).toLowerCase();
            this.d_writer.print(IOR.getStaticEPVVariable(cls.getSymbolID(), 1, 0));
            this.d_writer.printSpaces(width - lower.length());
            this.d_writer.println(" = " + self + "->" + epvVar + ";");
            this.d_writer.println();
        }
    }

    private void remoteEPVs(Class cls, int level) {
        if (cls != null) {
            String epvVar = IOR.getEPVVar(0);
            this.remoteEPVs(cls.getParentClass(), level + 1);
            String self = "s" + String.valueOf(level);
            ArrayList ifce = Utilities.sort(Utilities.getUniqueInterfaceIDs(cls));
            Iterator i = ifce.iterator();
            while (i.hasNext()) {
                SymbolID id = (SymbolID)i.next();
                String n = IOR.getSymbolName(id).toLowerCase();
                this.d_writer.println(self + "->d_" + n + "." + epvVar + "    = &" + IOR.getStaticEPVVariable(id, 2, 0) + n + ";");
                this.d_writer.println(self + "->d_" + n + ".d_object = (void*) instance;");
                this.d_writer.println();
            }
            String lower = IOR.getSymbolName(cls.getSymbolID()).toLowerCase();
            this.d_writer.println(self + "->d_data = (void*) instance;");
            this.d_writer.println(self + "->" + epvVar + "  = &" + IOR.getStaticEPVVariable(cls.getSymbolID(), 2, 0) + lower + ";");
            this.d_writer.println();
        }
    }

    private void aliasEPVs(Class cls, Collection parents, boolean remote) {
        SymbolID id = cls.getSymbolID();
        String name = IOR.getSymbolName(id);
        String epv = IOR.getEPVName(id);
        int epvType = remote ? 2 : 0;
        int width = epv.length() + 1;
        int w = Utilities.getWidth(parents) + "struct __epv*".length();
        if (w > width) {
            width = w;
        }
        this.d_writer.printAligned(epv + "*", width);
        this.d_writer.println(" epv = &" + IOR.getStaticEPVVariable(id, epvType, 0) + ";");
        int e = 0;
        Iterator i = parents.iterator();
        while (i.hasNext()) {
            SymbolID sid = (SymbolID)i.next();
            String lower = IOR.getSymbolName(sid).toLowerCase();
            this.d_writer.printAligned(IOR.getEPVName(sid) + "*", width);
            this.d_writer.printAligned(" e" + String.valueOf(e++), 4);
            this.d_writer.println(" = &" + IOR.getStaticEPVVariable(sid, epvType, 0) + ";");
        }
        this.d_writer.println();
    }

    private void copyEPVs(Collection parents) throws CodeGenerationException {
        int e = 0;
        Iterator i = parents.iterator();
        while (i.hasNext()) {
            SymbolID id = (SymbolID)i.next();
            Extendable ext = (Extendable)Utilities.lookupSymbol(id);
            String name = IOR.getSymbolName(id);
            List methods = (List)ext.getNonstaticMethods(true);
            int mwidth = Math.max(Utilities.getWidth(methods), s_longestBuiltin) + IOR.getVectorEntry("").length();
            String self = null;
            self = ext.isInterface() ? "void*" : IOR.getObjectName(id) + "*";
            String estring = "e" + String.valueOf(e) + "->";
            String vecEntry = IOR.getVectorEntry(s_castBuiltin);
            this.d_writer.print(estring);
            this.d_writer.printAligned(vecEntry, mwidth);
            this.d_writer.print(" = (void* (*)(" + self);
            this.d_writer.print(",const char*)) epv->");
            this.d_writer.print(vecEntry);
            this.d_writer.println(";");
            vecEntry = IOR.getVectorEntry(s_deleteBuiltin);
            this.d_writer.print(estring);
            this.d_writer.printAligned(vecEntry, mwidth);
            this.d_writer.println(" = (void (*)(" + self + ")) epv->" + vecEntry + ";");
            Iterator j = methods.iterator();
            while (j.hasNext()) {
                Method method = (Method)j.next();
                String mname = method.getLongMethodName();
                this.d_writer.print(estring);
                this.d_writer.printAligned(IOR.getVectorEntry(mname), mwidth);
                this.d_writer.print(" = " + IOR.getCast(method, self));
                this.d_writer.println(" epv->" + IOR.getVectorEntry(mname) + ";");
            }
            this.d_writer.println();
            ++e;
        }
    }

    private static String methodCall(Extendable ext, String var, String method, String args) {
        String result = "(*(" + var + "->" + IOR.getEPVVar(0) + "->" + IOR.getVectorEntry(method) + "))(" + var;
        if (ext.isInterface()) {
            result = result + "->d_object";
        }
        result = result + args;
        result = result + ");";
        return result;
    }

    private void generateReplaceValue(Symbol symbol) {
        this.d_writer.println("if (result) {");
        this.d_writer.tab();
        if (symbol instanceof Extendable) {
            this.d_writer.println("if (value) {");
            this.d_writer.tab();
            this.d_writer.println(RMIIORSource.methodCall((Extendable)symbol, "value", "addRef", ""));
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println("if (*result) {");
            this.d_writer.tab();
            this.d_writer.println(RMIIORSource.methodCall((Extendable)symbol, "(*result)", "deleteRef", ""));
            this.d_writer.backTab();
            this.d_writer.println("}");
        }
        this.d_writer.println("*result = value;");
        this.d_writer.backTab();
        this.d_writer.println("}");
    }

    public static void generateExternalSignature(LanguageWriter lw, Symbol sym, String terminator) {
        SymbolID id = sym.getSymbolID();
        lw.beginBlockComment(false);
        lw.println("This function returns a pointer to a static structure of");
        lw.println("pointers to function entry points.  Its purpose is to provide");
        lw.println("one-stop shopping for loading DLLs.");
        lw.endBlockComment(false);
        lw.println("const " + IOR.getExternalName(id) + "*");
        lw.println(IOR.getExternalFunc(id) + "(void)" + terminator);
    }

    private void generateExternalFunc(Symbol sym) {
        SymbolID id = sym.getSymbolID();
        this.d_writer.println("static const " + IOR.getExternalName(id));
        this.d_writer.println("s_externalEntryPoints = {");
        this.d_writer.tab();
        if (sym instanceof Class) {
            Class cls = (Class)sym;
            if (!cls.isAbstract()) {
                this.d_writer.println(IOR.getNewName(id) + ",");
            }
            this.d_writer.println(IOR.getRemoteName(id) + ",");
            if (cls.hasStaticMethod(true)) {
                this.d_writer.println(IOR.getStaticsName(id) + ",");
            }
            if (cls.getParentClass() != null) {
                this.d_writer.println(IOR.getSymbolName(id) + "__super");
            }
        }
        this.d_writer.backTab();
        this.d_writer.println("};");
        this.d_writer.println();
        RMIIORSource.generateExternalSignature(this.d_writer, sym, "");
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.println("return &s_externalEntryPoints;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    static {
        s_deleteBuiltin = IOR.getBuiltinName(1);
        s_castBuiltin = IOR.getBuiltinName(0);
        s_execBuiltin = IOR.getBuiltinName(2);
        s_longestBuiltin = 0;
        for (int j = 0; j < 10; ++j) {
            String mname = IOR.getBuiltinName(j);
            if (mname.length() <= s_longestBuiltin) continue;
            s_longestBuiltin = mname.length();
        }
    }

    private static class CompareMethods
    implements Comparator {
        private CompareMethods() {
        }

        public int compare(Object o1, Object o2) {
            Method m1 = (Method)o1;
            Method m2 = (Method)o2;
            return m1.getLongMethodName().compareTo(m2.getLongMethodName());
        }
    }
}

