// 
// File:          conway_TimeStepper_Impl.cc
// Symbol:        conway.TimeStepper-v1.0
// Symbol Type:   class
// Babel Version: 0.8.8
// SIDL Created:  20031111 21:45:56 PST
// Generated:     20031111 21:45:58 PST
// Description:   Server-side implementation for conway.TimeStepper
// 
// WARNING: Automatically generated; only changes within splicers preserved
// 
// babel-version = 0.8.8
// source-line   = 74
// source-url    = file:/home/kumfert/research/babel/demo/conways_life/libCxx/../life.sidl
// 
#include "conway_TimeStepper_Impl.hh"

// DO-NOT-DELETE splicer.begin(cxx.TimeStepper._includes)
#include <iostream>
// DO-NOT-DELETE splicer.end(cxx.TimeStepper._includes)

// user defined constructor
void conway::TimeStepper_impl::_ctor() {
  // DO-NOT-DELETE splicer.begin(cxx.TimeStepper._ctor)
  // add construction details here
  // DO-NOT-DELETE splicer.end(cxx.TimeStepper._ctor)
}

// user defined destructor
void conway::TimeStepper_impl::_dtor() {
  // DO-NOT-DELETE splicer.begin(cxx.TimeStepper._dtor)
  // add destruction details here
  // DO-NOT-DELETE splicer.end(cxx.TimeStepper._dtor)
}

// user defined static methods: (none)

// user defined non-static methods:
/**
 * Method:  init[]
 */
void
conway::TimeStepper_impl::init (
  /*in*/ ::conway::Environment env,
  /*in*/ ::conway::Ruleset rules ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(cxx.TimeStepper.init)
  d_env = env;
  d_rules = rules;
  d_step = 0;
  // DO-NOT-DELETE splicer.end(cxx.TimeStepper.init)
}

/**
 * advance one more timestep 
 * returns population count at new timestep
 */
int32_t
conway::TimeStepper_impl::step () 
throw () 

{
  // DO-NOT-DELETE splicer.begin(cxx.TimeStepper.step)
  if (d_env._is_nil() || d_rules._is_nil() ) { 
    return -1;
  }
  ::sidl::array<int> current = d_env.getGrid();
  if ( d_step==0 ) { 
    current.ensure(2,::sidl::column_major_order);
    d_env.setGrid( current );
  } 
  int lower[2];
  int upper[2];
  lower[0]=current.lower(0);
  lower[1]=current.lower(1);
  upper[0]=current.upper(0);
  upper[1]=current.upper(1);

  if ( d_next._is_nil() ) { 
    d_next = ::sidl::array<int>::createCol(2,lower,upper);  
  }

  int population_count=0;
  for ( int x=lower[0]; x<=upper[0]; x++ ) { 
    for ( int y=lower[1]; y<=upper[1]; y++ ) { 
      int isalive = d_rules.setAlive(x,y,d_env);
      d_next.set(x,y,isalive);
      population_count += (isalive) ? 1 : 0;
    }
  }
  d_env.setGrid( d_next );
  //  d_next = current; // save last grid for next time.
  ++d_step;
  return population_count;
  // DO-NOT-DELETE splicer.end(cxx.TimeStepper.step)
}

/**
 * check the number of steps taken 
 */
int32_t
conway::TimeStepper_impl::nStepsTaken () 
throw () 

{
  // DO-NOT-DELETE splicer.begin(cxx.TimeStepper.nStepsTaken)
  return d_step;
  // DO-NOT-DELETE splicer.end(cxx.TimeStepper.nStepsTaken)
}


// DO-NOT-DELETE splicer.begin(cxx.TimeStepper._misc)
// Put miscellaneous code here
// DO-NOT-DELETE splicer.end(cxx.TimeStepper._misc)

