/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.framework;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Monitor
extends Hashtable {
    public Monitor(int capacity) {
        super(capacity);
    }

    public boolean hasChanged(Object context) {
        Object o = this.get(context);
        if (o != null) {
            Enumeration e = ((ResourceContainer)o).elements();
            while (e.hasMoreElements()) {
                ResourceWrapper rw = (ResourceWrapper)e.nextElement();
                if (rw.timestamp == Monitor.timestamp(rw.resource)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public void invalidate(Object context) {
        if (context != null) {
            this.remove(context);
        }
    }

    public static long timestamp(Object resource) {
        long timestamp;
        if (resource instanceof File) {
            timestamp = ((File)resource).lastModified();
        } else if (resource instanceof URL) {
            try {
                timestamp = ((URL)resource).openConnection().getLastModified();
            }
            catch (IOException iOException) {
                timestamp = 0L;
            }
        } else {
            throw new IllegalArgumentException("Resource not monitorizable.");
        }
        return timestamp;
    }

    public void watch(Object key, Object resource) {
        Object o = this.get(key);
        if (o == null) {
            this.put(key, new ResourceContainer(resource));
        } else {
            ((ResourceContainer)o).addResource(resource);
        }
    }

    class ResourceWrapper {
        public Object resource;
        public long timestamp;

        public ResourceWrapper(Object resource) {
            this.resource = resource;
            this.stamp();
        }

        public void stamp() {
            this.timestamp = Monitor.timestamp(this.resource);
        }
    }

    class ResourceContainer
    extends Vector {
        public ResourceContainer(Object resource) {
            super(1);
            this.addResource(resource);
        }

        public void addResource(Object resource) {
            Enumeration e = this.elements();
            while (e.hasMoreElements()) {
                ResourceWrapper r = (ResourceWrapper)e.nextElement();
                if (!r.resource.toString().equals(resource.toString())) continue;
                r.stamp();
                return;
            }
            this.addElement(new ResourceWrapper(resource));
        }
    }
}

