/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.processor.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.cocoon.processor.sql.ConnectionCreator;
import org.apache.cocoon.processor.sql.SQLProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConnectionDefs {
    protected Hashtable creators = new Hashtable();
    protected Hashtable query_props_table = new Hashtable();
    protected Properties default_query_props = master_default_query_props;
    protected static Properties master_default_query_props = new Properties();

    static {
        ((Hashtable)master_default_query_props).put("doc-element", "ROWSET");
        ((Hashtable)master_default_query_props).put("row-element", "ROW");
        ((Hashtable)master_default_query_props).put("tag-case", "preserve");
        ((Hashtable)master_default_query_props).put("null-indicator", "omit");
        ((Hashtable)master_default_query_props).put("id-attribute", "ID");
        ((Hashtable)master_default_query_props).put("id-attribute-column", "");
        ((Hashtable)master_default_query_props).put("count-attribute", "");
        ((Hashtable)master_default_query_props).put("query-attribute", "");
        ((Hashtable)master_default_query_props).put("skip-rows-attribute", "");
        ((Hashtable)master_default_query_props).put("max-rows-attribute", "");
        ((Hashtable)master_default_query_props).put("update-rows-attribute", "");
        ((Hashtable)master_default_query_props).put("variable-left-delimiter", "{@");
        ((Hashtable)master_default_query_props).put("variable-right-delimiter", "}");
        ((Hashtable)master_default_query_props).put("session-variable-left-delimiter", "{@session.");
        ((Hashtable)master_default_query_props).put("session-variable-right-delimiter", "}");
        ((Hashtable)master_default_query_props).put("error-element", "sqlerror");
        ((Hashtable)master_default_query_props).put("error-message-attribute", "message");
        ((Hashtable)master_default_query_props).put("error-message-element", "");
        ((Hashtable)master_default_query_props).put("error-stacktrace-attribute", "");
        ((Hashtable)master_default_query_props).put("error-stacktrace-element", "");
    }

    public ConnectionDefs(Document document) throws Exception {
        NodeList connectiondefs = document.getElementsByTagName("connectiondefs");
        Node[] connection_defs_ary = new Node[connectiondefs.getLength()];
        int i = 0;
        while (i < connectiondefs.getLength()) {
            connection_defs_ary[i] = connectiondefs.item(i);
            ++i;
        }
        int i2 = 0;
        while (i2 < connection_defs_ary.length) {
            Node connection_def_node = connection_defs_ary[i2];
            NodeList connections = connection_def_node.getChildNodes();
            int j = 0;
            while (j < connections.getLength()) {
                Node node = connections.item(j);
                if (node.getNodeType() == 1) {
                    Element element = (Element)node;
                    String name = element.getNodeName();
                    if (name.equals("connection")) {
                        this.processConnectionDef(element);
                    } else if (name.equals("querydefs")) {
                        this.processQueryDef(element);
                    }
                }
                ++j;
            }
            connection_def_node.getParentNode().removeChild(connection_def_node);
            ++i2;
        }
    }

    public Connection getConnection(String name) throws SQLException {
        ConnectionCreator creator = (ConnectionCreator)this.creators.get(name);
        return creator.getConnection();
    }

    public ConnectionCreator getConnectionCreator(String name) {
        return (ConnectionCreator)this.creators.get(name);
    }

    public Properties getQueryProperties() {
        return (Properties)((Hashtable)this.default_query_props).clone();
    }

    public Properties getQueryProperties(String name) {
        if (name == null || name.equals("")) {
            return this.getQueryProperties();
        }
        Properties props = (Properties)this.query_props_table.get(name);
        if (props == null) {
            return this.getQueryProperties();
        }
        return (Properties)((Hashtable)props).clone();
    }

    protected void processConnectionDef(Element connection) throws Exception {
        String name = connection.getAttribute("name");
        if (name == null || name.equals("querydefs")) {
            return;
        }
        Properties connection_props = new Properties();
        NodeList connection_children = connection.getChildNodes();
        int k = 0;
        while (k < connection_children.getLength()) {
            Node connection_parameter = connection_children.item(k);
            String prop_name = connection_parameter.getNodeName();
            NodeList connection_parameter_values = connection_parameter.getChildNodes();
            StringBuffer value = new StringBuffer();
            int l = 0;
            while (l < connection_parameter_values.getLength()) {
                Node value_node = connection_parameter_values.item(l);
                if (value_node.getNodeType() == 3) {
                    value.append(value_node.getNodeValue());
                }
                ++l;
            }
            ((Hashtable)connection_props).put(prop_name, value.toString());
            ++k;
        }
        if (!((Hashtable)connection_props).containsKey("dburl")) {
            return;
        }
        this.creators.put(name, new ConnectionCreator(connection_props));
        String driver = connection_props.getProperty("driver");
        Hashtable drivers = SQLProcessor.drivers;
        if (driver != null && !drivers.containsKey(driver)) {
            drivers.put(driver, Class.forName(driver).newInstance());
        }
    }

    protected void processQueryDef(Element querydef) {
        String name = querydef.getAttribute("name");
        if (name == null) {
            return;
        }
        NamedNodeMap attributes = querydef.getAttributes();
        Properties props = new Properties(master_default_query_props);
        int i = 0;
        while (i < attributes.getLength()) {
            Node attribute = attributes.item(i);
            ((Hashtable)props).put(attribute.getNodeName(), attribute.getNodeValue());
            ++i;
        }
        this.query_props_table.put(name, props);
        String def = querydef.getAttribute("default");
        if (def != null && (def.equals("y") || def.equals("yes"))) {
            this.default_query_props = props;
        }
    }
}

