/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.processor.xsp;

import java.io.IOException;
import java.io.Reader;
import java.util.Dictionary;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cocoon.framework.Director;
import org.apache.cocoon.framework.XObject;
import org.apache.cocoon.parser.Parser;
import org.apache.cocoon.processor.xsp.XSPGlobal;
import org.apache.cocoon.processor.xsp.XSPUtil;
import org.apache.cocoon.producer.AbstractProducer;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class XSPPage
extends AbstractProducer {
    protected Parser xspParser;
    protected ServletContext servletContext;
    protected XSPGlobal global;

    public final Document getDocument(HttpServletRequest request) throws Exception {
        return this.getDocument(request, null);
    }

    public Document getDocument(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Document document = this.xspParser.createEmptyDocument();
        this.populateDocument(request, response, document);
        return document;
    }

    public String getPath(HttpServletRequest request) {
        return null;
    }

    public Reader getStream(HttpServletRequest request) throws IOException {
        return null;
    }

    public void init(Dictionary parameters) {
        this.init((Director)parameters.get("director"));
        this.global = (XSPGlobal)parameters.get("global");
        this.servletContext = (ServletContext)this.director.getActor("context");
    }

    public void init(Director director) {
        super.init(director);
        this.xspParser = (Parser)this.director.getActor("parser");
    }

    public abstract void populateDocument(HttpServletRequest var1, HttpServletResponse var2, Document var3) throws Exception;

    protected Text xspExpr(byte v, Document factory) {
        return factory.createTextNode(String.valueOf(v));
    }

    protected Text xspExpr(char v, Document factory) {
        return factory.createTextNode(String.valueOf(v));
    }

    protected Text xspExpr(double v, Document factory) {
        return factory.createTextNode(String.valueOf(v));
    }

    protected Text xspExpr(float v, Document factory) {
        return factory.createTextNode(String.valueOf(v));
    }

    protected Text xspExpr(int v, Document factory) {
        return factory.createTextNode(String.valueOf(v));
    }

    protected Text xspExpr(long v, Document factory) {
        return factory.createTextNode(String.valueOf(v));
    }

    protected Node xspExpr(Object v, Document factory) {
        if (v == null) {
            return factory.createTextNode("");
        }
        if (v instanceof Node) {
            Node node = (Node)v;
            if (node.getOwnerDocument() == factory) {
                return node;
            }
            return XSPUtil.cloneNode(node, factory);
        }
        if (v.getClass().isArray()) {
            Object[] elements = (Object[])v;
            DocumentFragment fragment = factory.createDocumentFragment();
            int i = 0;
            while (i < elements.length) {
                fragment.appendChild(this.xspExpr(elements[i], factory));
                ++i;
            }
            return fragment;
        }
        if (v instanceof XObject) {
            DocumentFragment fragment = factory.createDocumentFragment();
            ((XObject)v).toDOM(fragment);
            return fragment;
        }
        return factory.createTextNode(String.valueOf(v));
    }

    protected Text xspExpr(boolean v, Document factory) {
        return factory.createTextNode(String.valueOf(v));
    }
}

