/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.FontState;

public class TableCell
extends FObj {
    int spaceBefore;
    int spaceAfter;
    ColorType backgroundColor;
    FontState fs;
    ColorType borderColor;
    int borderWidth;
    int borderStyle;
    int paddingTop;
    int paddingBottom;
    int paddingLeft;
    int paddingRight;
    int position;
    protected int startOffset;
    protected int width;
    protected int height = 0;
    AreaContainer areaContainer;

    public TableCell(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        this.name = "fo:table-cell";
    }

    public int getHeight() {
        return this.areaContainer.getHeight();
    }

    public Status layout(Area area) throws FOPException {
        Object object;
        if (this.marker == -1001) {
            return new Status(1);
        }
        if (this.marker == -1000) {
            String string = this.properties.get("font-family").getString();
            String string2 = this.properties.get("font-style").getString();
            object = this.properties.get("font-weight").getString();
            int n = this.properties.get("font-size").getLength().mvalue();
            this.fs = new FontState(area.getFontInfo(), string, string2, (String)object, n);
            this.borderColor = this.properties.get("border-color").getColorType();
            this.borderWidth = this.properties.get("border-width").getLength().mvalue();
            this.borderStyle = this.properties.get("border-style").getEnum();
            this.paddingLeft = this.paddingTop = this.properties.get("padding").getLength().mvalue();
            this.paddingRight = this.paddingTop;
            this.paddingBottom = this.paddingTop;
            if (this.paddingTop == 0) {
                this.paddingTop = this.properties.get("padding-top").getLength().mvalue();
                this.paddingLeft = this.properties.get("padding-left").getLength().mvalue();
                this.paddingBottom = this.properties.get("padding-bottom").getLength().mvalue();
                this.paddingRight = this.properties.get("padding-right").getLength().mvalue();
            }
            this.spaceBefore = this.properties.get("space-before.optimum").getLength().mvalue();
            this.spaceAfter = this.properties.get("space-after.optimum").getLength().mvalue();
            this.backgroundColor = this.properties.get("background-color").getColorType();
            if (area instanceof BlockArea) {
                area.end();
            }
            this.marker = 0;
        }
        if (this.spaceBefore != 0 && this.marker == 0) {
            area.addDisplaySpace(this.spaceBefore);
        }
        this.areaContainer = new AreaContainer(this.fs, this.startOffset - area.borderWidthLeft, -area.borderWidthTop, this.width, area.spaceLeft(), 2);
        this.areaContainer.setPage(area.getPage());
        this.areaContainer.setPadding(this.paddingTop, this.paddingLeft, this.paddingBottom, this.paddingRight);
        this.areaContainer.setBackgroundColor(this.backgroundColor);
        this.areaContainer.setBorderStyle(this.borderStyle, this.borderStyle, this.borderStyle, this.borderStyle);
        this.areaContainer.setBorderWidth(this.borderWidth, this.borderWidth, this.borderWidth, this.borderWidth);
        this.areaContainer.setBorderColor(this.borderColor, this.borderColor, this.borderColor, this.borderColor);
        this.areaContainer.start();
        int n = this.children.size();
        int n2 = this.marker;
        while (n2 < n) {
            object = (FObj)this.children.elementAt(n2);
            ((FONode)object).setIsInTableCell();
            ((FONode)object).forceWidth(this.width);
            Status status = ((FObj)object).layout(this.areaContainer);
            if (status.isIncomplete()) {
                this.marker = n2;
                if (n2 == 0 && status.getCode() == 2) {
                    return new Status(2);
                }
                return new Status(3);
            }
            ++n2;
        }
        this.areaContainer.end();
        area.addChild(this.areaContainer);
        return new Status(1);
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public void setHeight(int n) {
        this.areaContainer.setMaxHeight(n);
        this.areaContainer.setHeight(n);
    }

    public void setStartOffset(int n) {
        this.startOffset = n;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new TableCell(fObj, propertyList);
        }
    }
}

