/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layout;

import org.apache.fop.layout.Area;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.LineArea;
import org.apache.fop.layout.LinkSet;
import org.apache.fop.render.Renderer;

public class BlockArea
extends Area {
    protected int startIndent;
    protected int endIndent;
    protected int textIndent;
    protected int lineHeight;
    protected int halfLeading;
    protected int align;
    protected int alignLastLine;
    protected LineArea currentLineArea;
    protected LinkSet currentLinkSet;
    protected boolean hasLines = false;

    public BlockArea(FontState fontState, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        super(fontState, n, n2);
        this.startIndent = n3;
        this.endIndent = n4;
        this.textIndent = n5;
        this.contentRectangleWidth = n - n3 - n4;
        this.align = n6;
        this.alignLastLine = n7;
        this.lineHeight = n8;
        if (fontState != null) {
            this.halfLeading = (n8 - fontState.getFontSize()) / 2;
        }
    }

    public void addLineArea(LineArea lineArea) {
        if (!lineArea.isEmpty()) {
            this.addDisplaySpace(this.halfLeading);
            int n = lineArea.getHeight();
            this.addChild(lineArea);
            this.increaseHeight(n);
            this.addDisplaySpace(this.halfLeading);
        }
    }

    public int addText(FontState fontState, float f, float f2, float f3, int n, LinkSet linkSet, int n2, char[] cArray, int n3, int n4) {
        int n5 = n3;
        int n6 = n4;
        char[] cArray2 = cArray;
        if (this.currentHeight + this.currentLineArea.getHeight() > this.maxHeight) {
            return n3;
        }
        this.currentLineArea.changeFont(fontState);
        this.currentLineArea.changeColor(f, f2, f3);
        this.currentLineArea.changeWrapOption(n);
        this.currentLineArea.changeWhiteSpaceTreatment(n2);
        if (linkSet != null) {
            this.currentLinkSet = linkSet;
            linkSet.setYOffset(this.currentHeight);
        }
        n5 = this.currentLineArea.addText(cArray2, n5, n6, linkSet);
        this.hasLines = true;
        while (n5 != -1) {
            this.currentLineArea.align(this.align);
            this.addLineArea(this.currentLineArea);
            this.currentLineArea = new LineArea(fontState, this.lineHeight, this.halfLeading, this.allocationWidth, this.startIndent, this.endIndent);
            if (this.currentHeight + this.currentLineArea.getHeight() > this.maxHeight) {
                return n5;
            }
            this.currentLineArea.changeFont(fontState);
            this.currentLineArea.changeColor(f, f2, f3);
            this.currentLineArea.changeWrapOption(n);
            this.currentLineArea.changeWhiteSpaceTreatment(n2);
            if (linkSet != null) {
                linkSet.setYOffset(this.currentHeight);
            }
            n5 = this.currentLineArea.addText(cArray2, n5, n6, linkSet);
        }
        return -1;
    }

    public void end() {
        if (this.hasLines) {
            this.currentLineArea.addPending();
            this.currentLineArea.align(this.alignLastLine);
            this.addLineArea(this.currentLineArea);
        }
    }

    public int getEndIndent() {
        return this.endIndent;
    }

    public int getStartIndent() {
        return this.startIndent + this.paddingLeft + this.borderWidthLeft;
    }

    public void render(Renderer renderer) {
        renderer.renderBlockArea(this);
    }

    public void setIndents(int n, int n2) {
        this.startIndent = n;
        this.endIndent = n2;
        this.contentRectangleWidth = this.allocationWidth - n - n2;
    }

    public int spaceLeft() {
        return this.maxHeight - this.currentHeight;
    }

    public void start() {
        this.currentLineArea = new LineArea(this.fontState, this.lineHeight, this.halfLeading, this.allocationWidth, this.startIndent + this.textIndent, this.endIndent);
    }
}

