/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layout;

import org.apache.fop.layout.AreaTree;
import org.apache.fop.layout.Page;
import org.apache.fop.layout.Region;

public class PageMaster {
    private int width;
    private int height;
    private Region body;
    private Region before;
    private Region after;
    private Region start;
    private Region end;

    public PageMaster(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public void addAfter(Region region) {
        this.after = region;
    }

    public void addBefore(Region region) {
        this.before = region;
    }

    public void addBody(Region region) {
        this.body = region;
    }

    public void addEnd(Region region) {
        this.end = region;
    }

    public void addStart(Region region) {
        this.start = region;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public Page makePage(AreaTree areaTree) {
        Page page = new Page(areaTree, this.height, this.width);
        if (this.body != null) {
            page.addBody(this.body.makeAreaContainer());
        }
        if (this.before != null) {
            page.addBefore(this.before.makeAreaContainer());
        }
        if (this.after != null) {
            page.addAfter(this.after.makeAreaContainer());
        }
        if (this.start != null) {
            page.addStart(this.start.makeAreaContainer());
        }
        if (this.end != null) {
            page.addEnd(this.end.makeAreaContainer());
        }
        return page;
    }
}

