/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class NativeMath
extends ScriptableObject {
    static /* synthetic */ Class class$java$lang$Math;
    static /* synthetic */ Class class$org$mozilla$javascript$NativeMath;

    public double abs(double d) {
        if (d == 0.0) {
            return 0.0;
        }
        if (d < 0.0) {
            return -d;
        }
        return d;
    }

    public double acos(double d) {
        if (d != d || d > 1.0 || d < -1.0) {
            return Double.NaN;
        }
        return Math.acos(d);
    }

    public double asin(double d) {
        if (d != d || d > 1.0 || d < -1.0) {
            return Double.NaN;
        }
        return Math.asin(d);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public double exp(double d) {
        if (d == Double.POSITIVE_INFINITY) {
            return d;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        return Math.exp(d);
    }

    public String getClassName() {
        return "Math";
    }

    public static Scriptable init(Scriptable scriptable) throws PropertyException {
        NativeMath nativeMath = new NativeMath();
        nativeMath.setPrototype(ScriptableObject.getObjectPrototype(scriptable));
        nativeMath.setParentScope(scriptable);
        String[] stringArray = new String[]{"atan", "atan2", "ceil", "cos", "floor", "random", "sin", "sqrt", "tan"};
        nativeMath.defineFunctionProperties(stringArray, class$java$lang$Math != null ? class$java$lang$Math : (class$java$lang$Math = NativeMath.class$("java.lang.Math")), 2);
        String[] stringArray2 = new String[]{"acos", "asin", "abs", "exp", "max", "min", "round", "pow", "log"};
        nativeMath.defineFunctionProperties(stringArray2, class$org$mozilla$javascript$NativeMath != null ? class$org$mozilla$javascript$NativeMath : (class$org$mozilla$javascript$NativeMath = NativeMath.class$("org.mozilla.javascript.NativeMath")), 2);
        ((FunctionObject)nativeMath.get("max", scriptable)).setLength((short)2);
        ((FunctionObject)nativeMath.get("min", scriptable)).setLength((short)2);
        int n = 7;
        nativeMath.defineProperty("E", new Double(Math.E), 7);
        nativeMath.defineProperty("PI", new Double(Math.PI), 7);
        nativeMath.defineProperty("LN10", new Double(2.302585092994046), 7);
        nativeMath.defineProperty("LN2", new Double(0.6931471805599453), 7);
        nativeMath.defineProperty("LOG2E", new Double(1.4426950408889634), 7);
        nativeMath.defineProperty("LOG10E", new Double(0.4342944819032518), 7);
        nativeMath.defineProperty("SQRT1_2", new Double(0.7071067811865476), 7);
        nativeMath.defineProperty("SQRT2", new Double(1.4142135623730951), 7);
        ScriptableObject scriptableObject = (ScriptableObject)scriptable;
        scriptableObject.defineProperty("Math", nativeMath, 2);
        return nativeMath;
    }

    public double log(double d) {
        if (d < 0.0) {
            return Double.NaN;
        }
        return Math.log(d);
    }

    public static double max(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        double d = Double.NEGATIVE_INFINITY;
        if (objectArray.length == 0) {
            return d;
        }
        int n = 0;
        while (n < objectArray.length) {
            double d2 = ScriptRuntime.toNumber(objectArray[n]);
            if (d2 != d2) {
                return d2;
            }
            d = Math.max(d, d2);
            ++n;
        }
        return d;
    }

    public static double min(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        double d = Double.POSITIVE_INFINITY;
        if (objectArray.length == 0) {
            return d;
        }
        int n = 0;
        while (n < objectArray.length) {
            double d2 = ScriptRuntime.toNumber(objectArray[n]);
            if (d2 != d2) {
                return d2;
            }
            d = Math.min(d, d2);
            ++n;
        }
        return d;
    }

    public double pow(double d, double d2) {
        if (d2 == 0.0) {
            return 1.0;
        }
        if (d == 0.0 && d2 < 0.0) {
            Double d3 = new Double(d);
            if (d3.equals(new Double(0.0))) {
                return Double.POSITIVE_INFINITY;
            }
            if ((double)((int)d2) == d2 && ((int)d2 & 1) == 1) {
                return Double.NEGATIVE_INFINITY;
            }
            return Double.POSITIVE_INFINITY;
        }
        return Math.pow(d, d2);
    }

    public double round(double d) {
        if (d != d) {
            return d;
        }
        if (d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
            return d;
        }
        long l = Math.round(d);
        if (l == 0L) {
            if (d < 0.0) {
                return ScriptRuntime.negativeZero;
            }
            return d == 0.0 ? d : 0.0;
        }
        return l;
    }
}

