/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Composite;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeEventSupport;
import org.apache.batik.bridge.BridgeMutationEvent;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.DefaultUnitProcessorContext;
import org.apache.batik.bridge.GraphicsNodeBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.ext.awt.image.renderable.Clip;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.filter.Mask;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.svg.SVGElement;

public class SVGUseElementBridge
implements GraphicsNodeBridge,
SVGConstants {
    public GraphicsNode createGraphicsNode(BridgeContext bridgeContext, Element element) {
        CompositeGraphicsNode compositeGraphicsNode = new CompositeGraphicsNode();
        CSSStyleDeclaration cSSStyleDeclaration = CSSUtilities.getComputedStyle(element);
        DefaultUnitProcessorContext defaultUnitProcessorContext = new DefaultUnitProcessorContext(bridgeContext, cSSStyleDeclaration);
        String string = element.getAttributeNS(null, "x");
        float f = 0.0f;
        if (string.length() != 0) {
            f = SVGUtilities.svgToUserSpace(element, "x", string, defaultUnitProcessorContext, (short)2);
        }
        string = element.getAttributeNS(null, "y");
        float f2 = 0.0f;
        if (string.length() != 0) {
            f2 = SVGUtilities.svgToUserSpace(element, "y", string, defaultUnitProcessorContext, (short)1);
        }
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(f, f2);
        String string2 = element.getAttributeNS(null, "transform");
        if (string2.length() > 0) {
            affineTransform.preConcatenate(SVGUtilities.convertAffineTransform(string2));
        }
        compositeGraphicsNode.setTransform(affineTransform);
        Rectangle2D rectangle2D = CSSUtilities.convertEnableBackground((SVGElement)element, cSSStyleDeclaration, defaultUnitProcessorContext);
        if (rectangle2D != null) {
            compositeGraphicsNode.setBackgroundEnable(rectangle2D);
        }
        compositeGraphicsNode.setVisible(CSSUtilities.convertVisibility(element));
        return compositeGraphicsNode;
    }

    public void buildGraphicsNode(GraphicsNode graphicsNode, BridgeContext bridgeContext, Element element) {
        CSSStyleDeclaration cSSStyleDeclaration = CSSUtilities.getComputedStyle(element);
        CSSPrimitiveValue cSSPrimitiveValue = (CSSPrimitiveValue)cSSStyleDeclaration.getPropertyCSSValue("opacity");
        Composite composite = CSSUtilities.convertOpacityToComposite(cSSPrimitiveValue);
        graphicsNode.setComposite(composite);
        Filter filter = CSSUtilities.convertFilter(element, graphicsNode, bridgeContext);
        graphicsNode.setFilter(filter);
        Mask mask = CSSUtilities.convertMask(element, graphicsNode, bridgeContext);
        graphicsNode.setMask(mask);
        Clip clip = CSSUtilities.convertClipPath(element, graphicsNode, bridgeContext);
        graphicsNode.setClip(clip);
        BridgeEventSupport.addDOMListener(bridgeContext, (SVGElement)element);
    }

    public void update(BridgeMutationEvent bridgeMutationEvent) {
    }

    public boolean isContainer() {
        return false;
    }
}

