/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import org.apache.batik.css.DOMStyleSheetList;
import org.apache.batik.css.ElementWithID;
import org.apache.batik.css.svg.SVGViewCSS;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.GenericAttr;
import org.apache.batik.dom.GenericAttrNS;
import org.apache.batik.dom.GenericCDATASection;
import org.apache.batik.dom.GenericComment;
import org.apache.batik.dom.GenericDocumentFragment;
import org.apache.batik.dom.GenericElement;
import org.apache.batik.dom.GenericElementNS;
import org.apache.batik.dom.GenericEntityReference;
import org.apache.batik.dom.GenericProcessingInstruction;
import org.apache.batik.dom.GenericText;
import org.apache.batik.dom.StyleSheetFactory;
import org.apache.batik.dom.StyleSheetProcessingInstruction;
import org.apache.batik.dom.svg.DefaultSVGContext;
import org.apache.batik.dom.svg.SVGContext;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.dom.svg.SVGOMAElement;
import org.apache.batik.dom.svg.SVGOMCircleElement;
import org.apache.batik.dom.svg.SVGOMClipPathElement;
import org.apache.batik.dom.svg.SVGOMDefsElement;
import org.apache.batik.dom.svg.SVGOMDescElement;
import org.apache.batik.dom.svg.SVGOMEllipseElement;
import org.apache.batik.dom.svg.SVGOMFEBlendElement;
import org.apache.batik.dom.svg.SVGOMFEColorMatrixElement;
import org.apache.batik.dom.svg.SVGOMFEComponentTransferElement;
import org.apache.batik.dom.svg.SVGOMFECompositeElement;
import org.apache.batik.dom.svg.SVGOMFEConvolveMatrixElement;
import org.apache.batik.dom.svg.SVGOMFEDiffuseLightingElement;
import org.apache.batik.dom.svg.SVGOMFEDisplacementMapElement;
import org.apache.batik.dom.svg.SVGOMFEDistantLightElement;
import org.apache.batik.dom.svg.SVGOMFEFloodElement;
import org.apache.batik.dom.svg.SVGOMFEFuncAElement;
import org.apache.batik.dom.svg.SVGOMFEFuncBElement;
import org.apache.batik.dom.svg.SVGOMFEFuncGElement;
import org.apache.batik.dom.svg.SVGOMFEFuncRElement;
import org.apache.batik.dom.svg.SVGOMFEGaussianBlurElement;
import org.apache.batik.dom.svg.SVGOMFEImageElement;
import org.apache.batik.dom.svg.SVGOMFEMergeElement;
import org.apache.batik.dom.svg.SVGOMFEMergeNodeElement;
import org.apache.batik.dom.svg.SVGOMFEMorphologyElement;
import org.apache.batik.dom.svg.SVGOMFEOffsetElement;
import org.apache.batik.dom.svg.SVGOMFEPointLightElement;
import org.apache.batik.dom.svg.SVGOMFESpecularLightingElement;
import org.apache.batik.dom.svg.SVGOMFESpotLightElement;
import org.apache.batik.dom.svg.SVGOMFETileElement;
import org.apache.batik.dom.svg.SVGOMFETurbulenceElement;
import org.apache.batik.dom.svg.SVGOMFilterElement;
import org.apache.batik.dom.svg.SVGOMGElement;
import org.apache.batik.dom.svg.SVGOMImageElement;
import org.apache.batik.dom.svg.SVGOMLineElement;
import org.apache.batik.dom.svg.SVGOMLinearGradientElement;
import org.apache.batik.dom.svg.SVGOMMaskElement;
import org.apache.batik.dom.svg.SVGOMMetadataElement;
import org.apache.batik.dom.svg.SVGOMPathElement;
import org.apache.batik.dom.svg.SVGOMPatternElement;
import org.apache.batik.dom.svg.SVGOMPolygonElement;
import org.apache.batik.dom.svg.SVGOMPolylineElement;
import org.apache.batik.dom.svg.SVGOMRadialGradientElement;
import org.apache.batik.dom.svg.SVGOMRectElement;
import org.apache.batik.dom.svg.SVGOMSVGElement;
import org.apache.batik.dom.svg.SVGOMScriptElement;
import org.apache.batik.dom.svg.SVGOMStopElement;
import org.apache.batik.dom.svg.SVGOMStyleElement;
import org.apache.batik.dom.svg.SVGOMSwitchElement;
import org.apache.batik.dom.svg.SVGOMSymbolElement;
import org.apache.batik.dom.svg.SVGOMTRefElement;
import org.apache.batik.dom.svg.SVGOMTSpanElement;
import org.apache.batik.dom.svg.SVGOMTextElement;
import org.apache.batik.dom.svg.SVGOMTextPathElement;
import org.apache.batik.dom.svg.SVGOMTitleElement;
import org.apache.batik.dom.svg.SVGOMToBeImplementedElement;
import org.apache.batik.dom.svg.SVGOMUseElement;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.dom.util.HashTable;
import org.apache.batik.dom.util.OverrideStyleElement;
import org.apache.batik.dom.util.XMLSupport;
import org.apache.batik.i18n.LocalizableSupport;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.DocumentCSS;
import org.w3c.dom.stylesheets.LinkStyle;
import org.w3c.dom.stylesheets.StyleSheet;
import org.w3c.dom.stylesheets.StyleSheetList;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGLangSpace;
import org.w3c.dom.svg.SVGSVGElement;
import org.w3c.dom.views.AbstractView;
import org.w3c.dom.views.DocumentView;

public class SVGOMDocument
extends AbstractDocument
implements SVGDocument,
DocumentCSS,
DocumentView,
SVGConstants {
    protected static final String RESOURCES = "org.apache.batik.dom.svg.resources.Messages";
    protected LocalizableSupport localizableSupport = new LocalizableSupport("org.apache.batik.dom.svg.resources.Messages");
    protected static HashTable customFactories;
    protected URL url;
    protected boolean readonly;
    protected AbstractView defaultView;
    protected SVGContext context;
    protected HashTable factories = new HashTable();
    DOMStyleSheetList styleSheets;

    public static void registerCustomElementFactory(String string, String string2, CustomElementFactory customElementFactory) {
        HashTable hashTable;
        if (customFactories == null) {
            customFactories = new HashTable();
        }
        if ((hashTable = (HashTable)customFactories.get(string)) == null) {
            hashTable = new HashTable();
            customFactories.put(string, hashTable);
        }
        hashTable.put(string2, customElementFactory);
    }

    protected SVGOMDocument() {
        this.factories.put("a", new AElementFactory());
        this.factories.put("animate", new AnimateElementFactory());
        this.factories.put("circle", new CircleElementFactory());
        this.factories.put("clipPath", new ClipPathElementFactory());
        this.factories.put("color-profile", new ColorProfileElementFactory());
        this.factories.put("defs", new DefsElementFactory());
        this.factories.put("desc", new DescElementFactory());
        this.factories.put("ellipse", new EllipseElementFactory());
        this.factories.put("feBlend", new FeBlendElementFactory());
        this.factories.put("feColorMatrix", new FeColorMatrixElementFactory());
        this.factories.put("feComponentTransfer", new FeComponentTransferElementFactory());
        this.factories.put("feComposite", new FeCompositeElementFactory());
        this.factories.put("feConvolveMatrix", new FeConvolveMatrixElementFactory());
        this.factories.put("feDiffuseLighting", new FeDiffuseLightingElementFactory());
        this.factories.put("feDisplacementMap", new FeDisplacementMapElementFactory());
        this.factories.put("feDistantLight", new FeDistantLightElementFactory());
        this.factories.put("feFuncA", new FeFuncAElementFactory());
        this.factories.put("feFuncR", new FeFuncRElementFactory());
        this.factories.put("feFuncG", new FeFuncGElementFactory());
        this.factories.put("feFuncB", new FeFuncBElementFactory());
        this.factories.put("feFlood", new FeFloodElementFactory());
        this.factories.put("feGaussianBlur", new FeGaussianBlurElementFactory());
        this.factories.put("feImage", new FeImageElementFactory());
        this.factories.put("feMerge", new FeMergeElementFactory());
        this.factories.put("feMergeNode", new FeMergeNodeElementFactory());
        this.factories.put("feMorphology", new FeMorphologyElementFactory());
        this.factories.put("feOffset", new FeOffsetElementFactory());
        this.factories.put("fePointLight", new FePointLightElementFactory());
        this.factories.put("feSpecularLighting", new FeSpecularLightingElementFactory());
        this.factories.put("feSpotLight", new FeSpotLightElementFactory());
        this.factories.put("feTile", new FeTileElementFactory());
        this.factories.put("feTurbulence", new FeTurbulenceElementFactory());
        this.factories.put("filter", new FilterElementFactory());
        this.factories.put("g", new GElementFactory());
        this.factories.put("image", new ImageElementFactory());
        this.factories.put("line", new LineElementFactory());
        this.factories.put("linearGradient", new LinearGradientElementFactory());
        this.factories.put("mask", new MaskElementFactory());
        this.factories.put("marker", new MarkerElementFactory());
        this.factories.put("metadata", new MetadataElementFactory());
        this.factories.put("path", new PathElementFactory());
        this.factories.put("pattern", new PatternElementFactory());
        this.factories.put("polygon", new PolygonElementFactory());
        this.factories.put("polyline", new PolylineElementFactory());
        this.factories.put("radialGradient", new RadialGradientElementFactory());
        this.factories.put("rect", new RectElementFactory());
        this.factories.put("script", new ScriptElementFactory());
        this.factories.put("stop", new StopElementFactory());
        this.factories.put("style", new StyleElementFactory());
        this.factories.put("svg", new SvgElementFactory());
        this.factories.put("switch", new SwitchElementFactory());
        this.factories.put("symbol", new SymbolElementFactory());
        this.factories.put("text", new TextElementFactory());
        this.factories.put("textPath", new TextPathElementFactory());
        this.factories.put("title", new TitleElementFactory());
        this.factories.put("tref", new TrefElementFactory());
        this.factories.put("tspan", new TspanElementFactory());
        this.factories.put("use", new UseElementFactory());
    }

    public SVGOMDocument(DocumentType documentType, DOMImplementation dOMImplementation) {
        super(dOMImplementation);
        this.factories.put("a", new AElementFactory());
        this.factories.put("animate", new AnimateElementFactory());
        this.factories.put("circle", new CircleElementFactory());
        this.factories.put("clipPath", new ClipPathElementFactory());
        this.factories.put("color-profile", new ColorProfileElementFactory());
        this.factories.put("defs", new DefsElementFactory());
        this.factories.put("desc", new DescElementFactory());
        this.factories.put("ellipse", new EllipseElementFactory());
        this.factories.put("feBlend", new FeBlendElementFactory());
        this.factories.put("feColorMatrix", new FeColorMatrixElementFactory());
        this.factories.put("feComponentTransfer", new FeComponentTransferElementFactory());
        this.factories.put("feComposite", new FeCompositeElementFactory());
        this.factories.put("feConvolveMatrix", new FeConvolveMatrixElementFactory());
        this.factories.put("feDiffuseLighting", new FeDiffuseLightingElementFactory());
        this.factories.put("feDisplacementMap", new FeDisplacementMapElementFactory());
        this.factories.put("feDistantLight", new FeDistantLightElementFactory());
        this.factories.put("feFuncA", new FeFuncAElementFactory());
        this.factories.put("feFuncR", new FeFuncRElementFactory());
        this.factories.put("feFuncG", new FeFuncGElementFactory());
        this.factories.put("feFuncB", new FeFuncBElementFactory());
        this.factories.put("feFlood", new FeFloodElementFactory());
        this.factories.put("feGaussianBlur", new FeGaussianBlurElementFactory());
        this.factories.put("feImage", new FeImageElementFactory());
        this.factories.put("feMerge", new FeMergeElementFactory());
        this.factories.put("feMergeNode", new FeMergeNodeElementFactory());
        this.factories.put("feMorphology", new FeMorphologyElementFactory());
        this.factories.put("feOffset", new FeOffsetElementFactory());
        this.factories.put("fePointLight", new FePointLightElementFactory());
        this.factories.put("feSpecularLighting", new FeSpecularLightingElementFactory());
        this.factories.put("feSpotLight", new FeSpotLightElementFactory());
        this.factories.put("feTile", new FeTileElementFactory());
        this.factories.put("feTurbulence", new FeTurbulenceElementFactory());
        this.factories.put("filter", new FilterElementFactory());
        this.factories.put("g", new GElementFactory());
        this.factories.put("image", new ImageElementFactory());
        this.factories.put("line", new LineElementFactory());
        this.factories.put("linearGradient", new LinearGradientElementFactory());
        this.factories.put("mask", new MaskElementFactory());
        this.factories.put("marker", new MarkerElementFactory());
        this.factories.put("metadata", new MetadataElementFactory());
        this.factories.put("path", new PathElementFactory());
        this.factories.put("pattern", new PatternElementFactory());
        this.factories.put("polygon", new PolygonElementFactory());
        this.factories.put("polyline", new PolylineElementFactory());
        this.factories.put("radialGradient", new RadialGradientElementFactory());
        this.factories.put("rect", new RectElementFactory());
        this.factories.put("script", new ScriptElementFactory());
        this.factories.put("stop", new StopElementFactory());
        this.factories.put("style", new StyleElementFactory());
        this.factories.put("svg", new SvgElementFactory());
        this.factories.put("switch", new SwitchElementFactory());
        this.factories.put("symbol", new SymbolElementFactory());
        this.factories.put("text", new TextElementFactory());
        this.factories.put("textPath", new TextPathElementFactory());
        this.factories.put("title", new TitleElementFactory());
        this.factories.put("tref", new TrefElementFactory());
        this.factories.put("tspan", new TspanElementFactory());
        this.factories.put("use", new UseElementFactory());
        if (documentType != null) {
            this.appendChild(documentType);
        }
    }

    protected Node newNode() {
        return new SVGOMDocument();
    }

    public SVGContext getSVGContext() {
        return this.context;
    }

    public void setSVGContext(SVGContext sVGContext) {
        this.context = sVGContext;
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.localizableSupport.setLocale(locale);
    }

    public String formatMessage(String string, Object[] objectArray) throws MissingResourceException {
        try {
            return super.formatMessage(string, objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            return this.localizableSupport.formatMessage(string, objectArray);
        }
    }

    public String getTitle() {
        String string = "";
        SVGSVGElement sVGSVGElement = this.getRootElement();
        boolean bl = false;
        Node node = sVGSVGElement.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                String string2;
                String string3 = string2 = node.getPrefix() == null ? node.getNodeName() : node.getLocalName();
                if (string2.equals("title")) {
                    bl = ((SVGLangSpace)((Object)node)).getXMLspace().equals("preserve");
                    node = node.getFirstChild();
                    while (node != null) {
                        if (node.getNodeType() == 3) {
                            string = string + node.getNodeValue();
                        }
                        node = node.getNextSibling();
                    }
                    break;
                }
            }
            node = node.getNextSibling();
        }
        return bl ? XMLSupport.preserveXMLSpace(string) : XMLSupport.defaultXMLSpace(string);
    }

    public String getReferrer() {
        throw new RuntimeException(" !!! TODO: SVGOMDocument.getReferrer()");
    }

    public void setReferrer(String string) {
        throw new RuntimeException(" !!! TODO: SVGOMDocument.setReferrer(String)");
    }

    public String getDomain() {
        return this.url == null ? null : this.url.getHost();
    }

    public SVGSVGElement getRootElement() {
        return (SVGSVGElement)this.getDocumentElement();
    }

    public String getURL() {
        return this.url.toString();
    }

    public URL getURLObject() {
        return this.url;
    }

    public void setURLObject(URL uRL) {
        this.url = uRL;
    }

    public Element getElementById(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        Element element = this.getDocumentElement();
        if (element == null) {
            return null;
        }
        return SVGOMDocument.getById(string, element);
    }

    protected static Element getById(String string, Node node) {
        if (!(node instanceof ElementWithID)) {
            return null;
        }
        ElementWithID elementWithID = (ElementWithID)((Object)node);
        if (elementWithID.getID().equals(string)) {
            return (Element)((Object)elementWithID);
        }
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            Element element = SVGOMDocument.getById(string, node2);
            if (element != null) {
                return element;
            }
            node2 = node2.getNextSibling();
        }
        return null;
    }

    public Element createElement(String string) throws DOMException {
        return new GenericElement(string.intern(), this);
    }

    public DocumentFragment createDocumentFragment() {
        return new GenericDocumentFragment(this);
    }

    public Text createTextNode(String string) {
        return new GenericText(string, this);
    }

    public Comment createComment(String string) {
        return new GenericComment(string, this);
    }

    public CDATASection createCDATASection(String string) throws DOMException {
        return new GenericCDATASection(string, this);
    }

    public ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
        if ("xml-stylesheet".equals(string)) {
            return new StyleSheetProcessingInstruction(string2, this, (StyleSheetFactory)((Object)this.getImplementation()));
        }
        return new GenericProcessingInstruction(string, string2, this);
    }

    public Attr createAttribute(String string) throws DOMException {
        return new GenericAttr(string.intern(), this);
    }

    public EntityReference createEntityReference(String string) throws DOMException {
        return new GenericEntityReference(string, this);
    }

    public Attr createAttributeNS(String string, String string2) throws DOMException {
        if (string == null) {
            return new GenericAttr(string2.intern(), this);
        }
        return new GenericAttrNS(string.intern(), string2.intern(), this);
    }

    public Element createElementNS(String string, String string2) throws DOMException {
        if ("http://www.w3.org/2000/svg".equals(string)) {
            String string3 = DOMUtilities.getLocalName(string2);
            ElementFactory elementFactory = (ElementFactory)this.factories.get(string3);
            if (elementFactory == null) {
                throw this.createDOMException((short)8, "invalid.element", new Object[]{string, string2});
            }
            return elementFactory.create(DOMUtilities.getPrefix(string2));
        }
        if (string != null) {
            String string4;
            CustomElementFactory customElementFactory;
            HashTable hashTable;
            if (customFactories != null && (hashTable = (HashTable)customFactories.get(string)) != null && (customElementFactory = (CustomElementFactory)hashTable.get(string4 = DOMUtilities.getLocalName(string2))) != null) {
                return customElementFactory.create(DOMUtilities.getPrefix(string2), this);
            }
            return new GenericElementNS(string.intern(), string2.intern(), this);
        }
        return new GenericElement(string2.intern(), this);
    }

    public boolean getEventsEnabled() {
        return this.eventsEnabled;
    }

    public void setEventsEnabled(boolean bl) {
        this.eventsEnabled = bl;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean bl) {
        this.readonly = bl;
    }

    public StyleSheetList getStyleSheets() {
        if (this.styleSheets == null) {
            this.styleSheets = new DOMStyleSheetList();
            SVGOMDocument.getStyleSheets(this, this.styleSheets);
        }
        return this.styleSheets;
    }

    protected static void getStyleSheets(Node node, DOMStyleSheetList dOMStyleSheetList) {
        Object object;
        if (node instanceof LinkStyle && (object = ((LinkStyle)((Object)node)).getSheet()) != null) {
            dOMStyleSheetList.append((StyleSheet)object);
        }
        object = node.getFirstChild();
        while (object != null) {
            SVGOMDocument.getStyleSheets((Node)object, dOMStyleSheetList);
            object = object.getNextSibling();
        }
    }

    public AbstractView getDefaultView() {
        if (this.defaultView == null) {
            if (this.context == null) {
                this.context = new DefaultSVGContext();
            }
            this.defaultView = new SVGViewCSS((DocumentView)this, this.context);
            SVGDOMImplementation sVGDOMImplementation = (SVGDOMImplementation)this.getImplementation();
            ((SVGViewCSS)this.defaultView).setUserAgentStyleSheet(sVGDOMImplementation.getUserAgentStyleSheet());
        }
        return this.defaultView;
    }

    public CSSStyleDeclaration getOverrideStyle(Element element, String string) {
        if (element instanceof OverrideStyleElement) {
            OverrideStyleElement overrideStyleElement = (OverrideStyleElement)((Object)element);
            return overrideStyleElement.hasOverrideStyle(string) ? null : overrideStyleElement.getOverrideStyle(string);
        }
        return null;
    }

    protected class UseElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMUseElement(string, SVGOMDocument.this);
        }
    }

    protected class TspanElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMTSpanElement(string, SVGOMDocument.this);
        }
    }

    protected class TrefElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMTRefElement(string, SVGOMDocument.this);
        }
    }

    protected class TitleElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMTitleElement(string, SVGOMDocument.this);
        }
    }

    protected class TextPathElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMTextPathElement(string, SVGOMDocument.this);
        }
    }

    protected class TextElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMTextElement(string, SVGOMDocument.this);
        }
    }

    protected class SymbolElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMSymbolElement(string, SVGOMDocument.this);
        }
    }

    protected class SwitchElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMSwitchElement(string, SVGOMDocument.this);
        }
    }

    protected class SvgElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMSVGElement(string, SVGOMDocument.this);
        }
    }

    protected class StyleElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMStyleElement(string, SVGOMDocument.this);
        }
    }

    protected class StopElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMStopElement(string, SVGOMDocument.this);
        }
    }

    protected class ScriptElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMScriptElement(string, SVGOMDocument.this);
        }
    }

    protected class RectElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMRectElement(string, SVGOMDocument.this);
        }
    }

    protected class RadialGradientElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMRadialGradientElement(string, SVGOMDocument.this);
        }
    }

    protected class PolylineElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMPolylineElement(string, SVGOMDocument.this);
        }
    }

    protected class PolygonElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMPolygonElement(string, SVGOMDocument.this);
        }
    }

    protected class PatternElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMPatternElement(string, SVGOMDocument.this);
        }
    }

    protected class PathElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMPathElement(string, SVGOMDocument.this);
        }
    }

    protected class MetadataElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMMetadataElement(string, SVGOMDocument.this);
        }
    }

    protected class MarkerElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMToBeImplementedElement(string, SVGOMDocument.this, "marker");
        }
    }

    protected class MaskElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMMaskElement(string, SVGOMDocument.this);
        }
    }

    protected class LinearGradientElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMLinearGradientElement(string, SVGOMDocument.this);
        }
    }

    protected class LineElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMLineElement(string, SVGOMDocument.this);
        }
    }

    protected class ImageElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMImageElement(string, SVGOMDocument.this);
        }
    }

    protected class GElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMGElement(string, SVGOMDocument.this);
        }
    }

    protected class FilterElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMFilterElement(string, SVGOMDocument.this);
        }
    }

    protected class FeTurbulenceElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMFETurbulenceElement(string, SVGOMDocument.this);
        }
    }

    protected class FeTileElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMFETileElement(string, SVGOMDocument.this);
        }
    }

    protected class FeSpotLightElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMFESpotLightElement(string, SVGOMDocument.this);
        }
    }

    protected class FeSpecularLightingElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMFESpecularLightingElement(string, SVGOMDocument.this);
        }
    }

    protected class FePointLightElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMFEPointLightElement(string, SVGOMDocument.this);
        }
    }

    protected class FeOffsetElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMFEOffsetElement(string, SVGOMDocument.this);
        }
    }

    protected class FeMorphologyElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMFEMorphologyElement(string, SVGOMDocument.this);
        }
    }

    protected class FeMergeNodeElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMFEMergeNodeElement(string, SVGOMDocument.this);
        }
    }

    protected class FeMergeElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMFEMergeElement(string, SVGOMDocument.this);
        }
    }

    protected class FeImageElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMFEImageElement(string, SVGOMDocument.this);
        }
    }

    protected class FeGaussianBlurElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMFEGaussianBlurElement(string, SVGOMDocument.this);
        }
    }

    protected class FeFuncBElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMFEFuncBElement(string, SVGOMDocument.this);
        }
    }

    protected class FeFuncGElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMFEFuncGElement(string, SVGOMDocument.this);
        }
    }

    protected class FeFuncRElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMFEFuncRElement(string, SVGOMDocument.this);
        }
    }

    protected class FeFuncAElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMFEFuncAElement(string, SVGOMDocument.this);
        }
    }

    protected class FeFloodElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMFEFloodElement(string, SVGOMDocument.this);
        }
    }

    protected class FeDistantLightElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMFEDistantLightElement(string, SVGOMDocument.this);
        }
    }

    protected class FeDisplacementMapElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMFEDisplacementMapElement(string, SVGOMDocument.this);
        }
    }

    protected class FeDiffuseLightingElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMFEDiffuseLightingElement(string, SVGOMDocument.this);
        }
    }

    protected class FeCompositeElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMFECompositeElement(string, SVGOMDocument.this);
        }
    }

    protected class FeConvolveMatrixElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMFEConvolveMatrixElement(string, SVGOMDocument.this);
        }
    }

    protected class FeComponentTransferElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMFEComponentTransferElement(string, SVGOMDocument.this);
        }
    }

    protected class FeColorMatrixElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMFEColorMatrixElement(string, SVGOMDocument.this);
        }
    }

    protected class FeBlendElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMFEBlendElement(string, SVGOMDocument.this);
        }
    }

    protected class EllipseElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMEllipseElement(string, SVGOMDocument.this);
        }
    }

    protected class DescElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMDescElement(string, SVGOMDocument.this);
        }
    }

    protected class DefsElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMDefsElement(string, SVGOMDocument.this);
        }
    }

    protected class ColorProfileElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMToBeImplementedElement(string, SVGOMDocument.this, "color-profile");
        }
    }

    protected class ClipPathElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMClipPathElement(string, SVGOMDocument.this);
        }
    }

    protected class CircleElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMCircleElement(string, SVGOMDocument.this);
        }
    }

    protected class AnimateElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMToBeImplementedElement(string, SVGOMDocument.this, "animate");
        }
    }

    protected class AElementFactory
    implements ElementFactory {
        public Element create(String string) {
            return new SVGOMAElement(string, SVGOMDocument.this);
        }
    }

    protected static interface ElementFactory {
        public Element create(String var1);
    }

    public static interface CustomElementFactory {
        public Element create(String var1, Document var2);
    }
}

