/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.lang.ref.WeakReference;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.dom.util.OverrideStyleElementSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.svg.SVGAnimatedString;

public class SVGStylableSupport {
    public static final String STYLE = "style";
    public static final String CLASS = "class";
    protected WeakReference inlineStyle;
    protected OverrideStyleElementSupport overrideStyleSupport;

    public static boolean hasStyle(Element element) {
        return element.hasAttribute(STYLE);
    }

    public CSSStyleDeclaration getStyle(Element element) {
        CSSStyleDeclaration cSSStyleDeclaration;
        if (this.inlineStyle == null || (cSSStyleDeclaration = (CSSStyleDeclaration)this.inlineStyle.get()) == null) {
            SVGDOMImplementation sVGDOMImplementation = (SVGDOMImplementation)element.getOwnerDocument().getImplementation();
            cSSStyleDeclaration = sVGDOMImplementation.createCSSStyleDeclaration();
            cSSStyleDeclaration.setCssText(element.getAttribute(STYLE));
            this.inlineStyle = new WeakReference<CSSStyleDeclaration>(cSSStyleDeclaration);
        }
        return cSSStyleDeclaration;
    }

    public CSSValue getPresentationAttribute(String string, Element element) {
        throw new RuntimeException(" !!! TODO: SVGStylableSupport.getPresentationAttribute()");
    }

    public SVGAnimatedString getClassName(Element element) {
        throw new RuntimeException(" !!! TODO: SVGStylableSupport.getClassName()");
    }

    public boolean hasOverrideStyle(String string) {
        return this.overrideStyleSupport == null || this.overrideStyleSupport.hasOverrideStyle(string);
    }

    public CSSStyleDeclaration getOverrideStyle(String string, Element element) {
        if (this.overrideStyleSupport == null) {
            Document document = element.getOwnerDocument();
            SVGDOMImplementation sVGDOMImplementation = (SVGDOMImplementation)document.getImplementation();
            this.overrideStyleSupport = new OverrideStyleElementSupport(sVGDOMImplementation);
        }
        return this.overrideStyleSupport.getOverrideStyle(string);
    }
}

