/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.datasource;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.avalon.AbstractLoggable;
import org.apache.avalon.Disposable;
import org.apache.avalon.Initializable;
import org.apache.avalon.Poolable;
import org.apache.avalon.Recyclable;
import org.apache.avalon.util.Lock;
import org.apache.excalibur.datasource.JdbcConnection;
import org.apache.excalibur.pool.Pool;

public class JdbcConnectionPool
extends AbstractLoggable
implements Pool,
Runnable,
Disposable,
Initializable {
    private final String m_dburl;
    private final String m_username;
    private final String m_password;
    private final int m_max;
    private final boolean m_autoCommit;
    private List m_active = new ArrayList();
    private List m_ready = new ArrayList();
    private boolean m_initialized = false;
    private boolean m_disposed = false;
    private Lock m_mutex = new Lock();
    private Thread m_initThread;

    public void init() {
        this.m_initThread = new Thread(this);
        this.m_initThread.start();
    }

    private JdbcConnection createJdbcConnection() throws SQLException {
        JdbcConnection jdbcConnection = null;
        if (this.m_username == null) {
            jdbcConnection = new JdbcConnection(DriverManager.getConnection(this.m_dburl), this);
            jdbcConnection.setLogger(this.getLogger());
        } else {
            jdbcConnection = new JdbcConnection(DriverManager.getConnection(this.m_dburl, this.m_username, this.m_password), this);
            jdbcConnection.setLogger(this.getLogger());
        }
        this.getLogger().debug("JdbcConnection object created");
        return jdbcConnection;
    }

    private void recycle(Recyclable recyclable) {
        this.getLogger().debug("JdbcConnection object recycled");
        recyclable.recycle();
    }

    public Poolable get() throws Exception {
        if (!this.m_initialized) {
            if (this.m_initThread == null) {
                throw new IllegalStateException("You cannot get a Connection before the pool is initialized");
            }
            this.m_initThread.join();
        }
        if (this.m_disposed) {
            throw new IllegalStateException("You cannot get a Connection after the pool is disposed");
        }
        Poolable poolable = null;
        try {
            block10: {
                try {
                    this.m_mutex.lock();
                    if (this.m_ready.size() == 0) {
                        if (this.m_active.size() < this.m_max) {
                            poolable = this.createJdbcConnection();
                            this.m_active.add(poolable);
                            break block10;
                        }
                        throw new SQLException("There are no more Connections available");
                    }
                    poolable = (Poolable)this.m_ready.remove(0);
                    this.m_active.add(poolable);
                }
                catch (Exception exception) {
                    this.getLogger().debug("JdbcConnectionPool.get()", (Throwable)exception);
                    Object var3_3 = null;
                    this.m_mutex.unlock();
                }
            }
            Object var3_2 = null;
            this.m_mutex.unlock();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.m_mutex.unlock();
            throw throwable;
        }
        if (((Connection)((Object)poolable)).getAutoCommit() != this.m_autoCommit) {
            ((Connection)((Object)poolable)).setAutoCommit(this.m_autoCommit);
        }
        this.getLogger().debug("JdbcConnection '" + this.m_dburl + "' has been requested from pool.");
        return poolable;
    }

    public void put(Poolable poolable) {
        if (!this.m_initialized) {
            throw new IllegalStateException("You cannot return an object to an uninitialized pool");
        }
        try {
            block7: {
                try {
                    this.m_mutex.lock();
                    this.m_active.remove(poolable);
                    if (!this.m_disposed) {
                        JdbcConnection jdbcConnection = (JdbcConnection)poolable;
                        if (jdbcConnection.isClosed()) {
                            this.getLogger().warn("Connection was closed by server, attempting to create a new one in its stead.");
                            jdbcConnection.recycle();
                            jdbcConnection = this.createJdbcConnection();
                        }
                        this.m_ready.add(jdbcConnection);
                        break block7;
                    }
                    this.recycle((Recyclable)poolable);
                }
                catch (Exception exception) {
                    this.getLogger().warn("Error returning connection to pool", (Throwable)exception);
                    Object var3_5 = null;
                    this.m_mutex.unlock();
                }
            }
            Object var3_4 = null;
            this.m_mutex.unlock();
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            this.m_mutex.unlock();
            throw throwable;
        }
        this.getLogger().debug("JdbcConnection '" + this.m_dburl + "' has been returned to the pool.");
    }

    public void run() {
        try {
            block7: {
                try {
                    this.m_mutex.lock();
                    int n = 0;
                    while (n < this.m_max) {
                        try {
                            this.m_ready.add(this.createJdbcConnection());
                        }
                        catch (SQLException sQLException) {
                            this.getLogger().error("Could not create connection to database", (Throwable)sQLException);
                        }
                        ++n;
                    }
                    if (this.m_ready.size() <= 0) break block7;
                    this.m_initialized = true;
                }
                catch (Exception exception) {
                    this.getLogger().debug("JdbcConnectionPool.run()", (Throwable)exception);
                    Object var2_5 = null;
                    this.m_mutex.unlock();
                }
            }
            Object var2_4 = null;
            this.m_mutex.unlock();
        }
        catch (Throwable throwable) {
            Object var2_6 = null;
            this.m_mutex.unlock();
            throw throwable;
        }
    }

    public void dispose() {
        try {
            try {
                this.m_mutex.lock();
                this.m_disposed = true;
                while (!this.m_ready.isEmpty()) {
                    this.recycle((Recyclable)this.m_ready.remove(0));
                }
            }
            catch (Exception exception) {
                this.getLogger().debug("JdbcConnectionPool.dispose()", (Throwable)exception);
                Object var2_2 = null;
                this.m_mutex.unlock();
            }
            Object var2_1 = null;
            this.m_mutex.unlock();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.m_mutex.unlock();
            throw throwable;
        }
    }

    public JdbcConnectionPool(String string, String string2, String string3, int n, boolean bl) {
        this.m_dburl = string;
        this.m_username = string2;
        this.m_password = string3;
        if (n < 1) {
            this.getLogger().warn("Maximum number of connections specified must be at least 1 and must be greater than the minumum number of connections");
            this.m_max = 1;
        } else {
            this.m_max = n;
        }
        this.m_autoCommit = bl;
    }
}

