/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.vss;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.vss.MSVSS;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;

public class MSVSSGET
extends MSVSS {
    private String m_LocalPath = null;
    private boolean m_Recursive = false;
    private boolean m_Writable = false;
    private String m_Version = null;
    private String m_Date = null;
    private String m_Label = null;
    private String m_AutoResponse = null;

    public void execute() throws BuildException {
        Commandline commandline = new Commandline();
        int n = 0;
        if (this.getVsspath() == null) {
            String string = "vsspath attribute must be set!";
            throw new BuildException(string, this.location);
        }
        commandline.setExecutable(this.getSSCommand());
        commandline.createArgument().setValue("Get");
        commandline.createArgument().setValue(this.getVsspath());
        this.getLocalpathCommand(commandline);
        this.getAutoresponse(commandline);
        this.getRecursiveCommand(commandline);
        this.getVersionCommand(commandline);
        this.getWritableCommand(commandline);
        this.getLoginCommand(commandline);
        n = this.run(commandline);
        if (n != 0) {
            String string = "Failed executing: " + commandline.toString();
            throw new BuildException(string, this.location);
        }
    }

    public void setLocalpath(Path path) {
        this.m_LocalPath = path.toString();
    }

    public void getLocalpathCommand(Commandline commandline) {
        if (this.m_LocalPath == null) {
            return;
        }
        File file = this.project.resolveFile(this.m_LocalPath);
        if (!file.exists()) {
            boolean bl = file.mkdirs();
            if (!bl) {
                String string = "Directory " + this.m_LocalPath + " creation was not " + "succesful for an unknown reason";
                throw new BuildException(string, this.location);
            }
            this.project.log("Created dir: " + file.getAbsolutePath());
        }
        commandline.createArgument().setValue("-GL" + this.m_LocalPath);
    }

    public void setRecursive(boolean bl) {
        this.m_Recursive = bl;
    }

    public void getRecursiveCommand(Commandline commandline) {
        if (!this.m_Recursive) {
            return;
        }
        commandline.createArgument().setValue("-R");
    }

    public final void setWritable(boolean bl) {
        this.m_Writable = bl;
    }

    public void getWritableCommand(Commandline commandline) {
        if (!this.m_Writable) {
            return;
        }
        commandline.createArgument().setValue("-W");
    }

    public void setVersion(String string) {
        this.m_Version = string.equals("") || string.equals("null") ? null : string;
    }

    public void setDate(String string) {
        this.m_Date = string.equals("") || string.equals("null") ? null : string;
    }

    public void setLabel(String string) {
        this.m_Label = string.equals("") || string.equals("null") ? null : string;
    }

    public void getVersionCommand(Commandline commandline) {
        if (this.m_Version != null) {
            commandline.createArgument().setValue("-V" + this.m_Version);
        } else if (this.m_Date != null) {
            commandline.createArgument().setValue("-Vd" + this.m_Date);
        } else if (this.m_Label != null) {
            commandline.createArgument().setValue("-VL" + this.m_Label);
        }
    }

    public void setAutoresponse(String string) {
        this.m_AutoResponse = string.equals("") || string.equals("null") ? null : string;
    }

    public void getAutoresponse(Commandline commandline) {
        if (this.m_AutoResponse == null) {
            commandline.createArgument().setValue("-I-");
        } else if (this.m_AutoResponse.equalsIgnoreCase("Y")) {
            commandline.createArgument().setValue("-I-Y");
        } else if (this.m_AutoResponse.equalsIgnoreCase("N")) {
            commandline.createArgument().setValue("-I-N");
        } else {
            commandline.createArgument().setValue("-I-");
        }
    }
}

