/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.SQLException;
import org.hsqldb.Column;
import org.hsqldb.Node;
import org.hsqldb.Trace;

class Index {
    private String sName;
    private int iFields;
    private int[] iColumn;
    private int[] iType;
    private boolean bUnique;
    private Node root;
    private int iColumn_0;
    private int iType_0;
    private static int iNeedCleanUp;

    Index(String string, int[] nArray, int[] nArray2, boolean bl) {
        this.sName = string;
        this.iFields = nArray.length;
        this.iColumn = nArray;
        this.iType = nArray2;
        this.bUnique = bl;
        this.iColumn_0 = this.iColumn[0];
        this.iType_0 = this.iType[0];
    }

    private Node child(Node node, boolean bl) throws SQLException {
        return bl ? node.getLeft() : node.getRight();
    }

    private int compareRow(Object[] objectArray, Object[] objectArray2) throws SQLException {
        int n = Column.compare(objectArray[this.iColumn_0], objectArray2[this.iColumn_0], this.iType_0);
        if (n != 0) {
            return n;
        }
        int n2 = 1;
        while (n2 < this.iFields) {
            n = Column.compare(objectArray[this.iColumn[n2]], objectArray2[this.iColumn[n2]], this.iType[n2]);
            if (n != 0) {
                return n;
            }
            ++n2;
        }
        return 0;
    }

    private int compareRowNonUnique(Object[] objectArray, Object[] objectArray2) throws SQLException {
        int n = Column.compare(objectArray[this.iColumn_0], objectArray2[this.iColumn_0], this.iType_0);
        if (n != 0) {
            return n;
        }
        int n2 = 1;
        while (n2 < this.iFields - (this.bUnique ? 0 : 1)) {
            n = Column.compare(objectArray[this.iColumn[n2]], objectArray2[this.iColumn[n2]], this.iType[n2]);
            if (n != 0) {
                return n;
            }
            ++n2;
        }
        return 0;
    }

    private int compareValue(Object object, Object object2) throws SQLException {
        return Column.compare(object, object2, this.iType_0);
    }

    void delete(Object[] objectArray, boolean bl) throws SQLException {
        Node node;
        int n;
        Node node2;
        Node node3 = this.search(objectArray);
        if (node3 == null) {
            return;
        }
        if (node3.getLeft() == null) {
            node2 = node3.getRight();
        } else if (node3.getRight() == null) {
            node2 = node3.getLeft();
        } else {
            Node node4 = node3;
            node3 = node3.getLeft();
            while (node3.getRight() != null) {
                node3 = node3.getRight();
            }
            node2 = node3.getLeft();
            n = node3.getBalance();
            node3.setBalance(node4.getBalance());
            node4.setBalance(n);
            node = node3.getParent();
            Node node5 = node4.getParent();
            if (node4 == this.root) {
                this.root = node3;
            }
            node3.setParent(node5);
            if (node5 != null) {
                if (node5.getRight().equals(node4)) {
                    node5.setRight(node3);
                } else {
                    node5.setLeft(node3);
                }
            }
            if (node == node4) {
                node4.setParent(node3);
                if (node4.getLeft().equals(node3)) {
                    node3.setLeft(node4);
                    node3.setRight(node4.getRight());
                } else {
                    node3.setRight(node4);
                    node3.setLeft(node4.getLeft());
                }
            } else {
                node4.setParent(node);
                node.setRight(node4);
                node3.setRight(node4.getRight());
                node3.setLeft(node4.getLeft());
            }
            node3.getRight().setParent(node3);
            node3.getLeft().setParent(node3);
            node4.setLeft(node2);
            if (node2 != null) {
                node2.setParent(node4);
            }
            node4.setRight(null);
            node3 = node4;
        }
        boolean bl2 = this.from(node3);
        this.replace(node3, node2);
        node2 = node3.getParent();
        node3.delete();
        if (bl) {
            node3.rData.delete();
        }
        while (node2 != null) {
            node3 = node2;
            n = bl2 ? 1 : -1;
            switch (node3.getBalance() * n) {
                case -1: {
                    node3.setBalance(0);
                    break;
                }
                case 0: {
                    node3.setBalance(n);
                    return;
                }
                case 1: {
                    node = this.child(node3, bl2 ^ true);
                    int n2 = node.getBalance();
                    if (n2 * n >= 0) {
                        this.replace(node3, node);
                        this.set(node3, bl2 ^ true, this.child(node, bl2));
                        this.set(node, bl2, node3);
                        if (n2 == 0) {
                            node3.setBalance(n);
                            node.setBalance(-n);
                            return;
                        }
                        node3.setBalance(0);
                        node.setBalance(0);
                        node3 = node;
                        break;
                    }
                    Node node6 = this.child(node, bl2);
                    this.replace(node3, node6);
                    n2 = node6.getBalance();
                    this.set(node, bl2, this.child(node6, bl2 ^ true));
                    this.set(node6, bl2 ^ true, node);
                    this.set(node3, bl2 ^ true, this.child(node6, bl2));
                    this.set(node6, bl2, node3);
                    node3.setBalance(n2 == n ? -n : 0);
                    node.setBalance(n2 == -n ? n : 0);
                    node6.setBalance(0);
                    node3 = node6;
                }
            }
            bl2 = this.from(node3);
            node2 = node3.getParent();
        }
    }

    Node find(Object[] objectArray) throws SQLException {
        Node node = this.root;
        while (node != null) {
            int n = this.compareRowNonUnique(objectArray, node.getData());
            if (n == 0) {
                return node;
            }
            Node node2 = n > 0 ? node.getRight() : node.getLeft();
            if (node2 == null) {
                return null;
            }
            node = node2;
        }
        return null;
    }

    Node findFirst(Object object, int n) throws SQLException {
        Trace.assert(n == 23 || n == 21 || n == 22, "Index.findFirst");
        Node node = this.root;
        int n2 = 1;
        if (n == 23) {
            n2 = 0;
        }
        while (node != null) {
            Node node2;
            boolean bl;
            boolean bl2 = bl = this.compareValue(object, node.getData()[this.iColumn_0]) >= n2;
            if (bl) {
                node2 = node.getRight();
                if (node2 == null) break;
                node = node2;
                continue;
            }
            node2 = node.getLeft();
            if (node2 == null) break;
            node = node2;
        }
        while (node != null && this.compareValue(object, node.getData()[this.iColumn_0]) >= n2) {
            node = this.next(node);
        }
        return node;
    }

    Node first() throws SQLException {
        Node node;
        Node node2 = node = this.root;
        while (node2 != null) {
            node = node2;
            node2 = node.getLeft();
        }
        return node;
    }

    private boolean from(Node node) throws SQLException {
        if (node.equals(this.root)) {
            return true;
        }
        return node.equals(node.getParent().getLeft());
    }

    int[] getColumns() {
        return this.iColumn;
    }

    String getName() {
        return this.sName;
    }

    Node getRoot() {
        return this.root;
    }

    void insert(Node node) throws SQLException {
        Node node2;
        Object[] objectArray = node.getData();
        Node node3 = node2 = this.root;
        boolean bl = true;
        int n = -1;
        while (true) {
            if (node2 == null) {
                if (node3 == null) {
                    this.root = node;
                    return;
                }
                break;
            }
            node3 = node2;
            n = this.compareRow(objectArray, node3.getData());
            Trace.check(n != 0, 8);
            bl = n < 0;
            node2 = this.child(node3, bl);
        }
        this.set(node3, bl, node);
        while (true) {
            int n2 = bl ? 1 : -1;
            switch (node3.getBalance() * n2) {
                case 1: {
                    node3.setBalance(0);
                    return;
                }
                case 0: {
                    node3.setBalance(-n2);
                    break;
                }
                case -1: {
                    Node node4 = this.child(node3, bl);
                    if (node4.getBalance() == -n2) {
                        this.replace(node3, node4);
                        this.set(node3, bl, this.child(node4, bl ^ true));
                        this.set(node4, bl ^ true, node3);
                        node3.setBalance(0);
                        node4.setBalance(0);
                    } else {
                        Node node5 = this.child(node4, bl ^ true);
                        this.replace(node3, node5);
                        this.set(node4, bl ^ true, this.child(node5, bl));
                        this.set(node5, bl, node4);
                        this.set(node3, bl, this.child(node5, bl ^ true));
                        this.set(node5, bl ^ true, node3);
                        int n3 = node5.getBalance();
                        node3.setBalance(n3 == -n2 ? n2 : 0);
                        node4.setBalance(n3 == n2 ? -n2 : 0);
                        node5.setBalance(0);
                    }
                    return;
                }
            }
            if (node3.equals(this.root)) {
                return;
            }
            bl = this.from(node3);
            node3 = node3.getParent();
        }
    }

    boolean isUnique() {
        return this.bUnique;
    }

    Node next(Node node) throws SQLException {
        Node node2;
        if ((++iNeedCleanUp & 0x7F) == 0) {
            node.rData.cleanUpCache();
        }
        if ((node2 = node.getRight()) != null) {
            node = node2;
            Node node3 = node.getLeft();
            while (node3 != null) {
                node = node3;
                node3 = node.getLeft();
            }
            return node;
        }
        Node node4 = node;
        node = node.getParent();
        while (node != null && node4.equals(node.getRight())) {
            node4 = node;
            node = node.getParent();
        }
        return node;
    }

    private void replace(Node node, Node node2) throws SQLException {
        if (node.equals(this.root)) {
            this.root = node2;
            if (node2 != null) {
                node2.setParent(null);
            }
        } else {
            this.set(node.getParent(), this.from(node), node2);
        }
    }

    private Node search(Object[] objectArray) throws SQLException {
        Node node = this.root;
        while (node != null) {
            int n = this.compareRow(objectArray, node.getData());
            if (n == 0) {
                return node;
            }
            node = n < 0 ? node.getLeft() : node.getRight();
        }
        return null;
    }

    private void set(Node node, boolean bl, Node node2) throws SQLException {
        if (bl) {
            node.setLeft(node2);
        } else {
            node.setRight(node2);
        }
        if (node2 != null) {
            node2.setParent(node);
        }
    }

    void setRoot(Node node) {
        this.root = node;
    }
}

