/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.log.LogKit;
import org.apache.log.format.PatternFormatter;
import org.apache.log.output.AbstractOutputTarget;

public class DefaultOutputLogTarget
extends AbstractOutputTarget {
    protected Writer m_output;

    protected void initPattern() {
        PatternFormatter formatter = new PatternFormatter();
        formatter.setFormat("%7.7{priority} %5.5{time}   [%8.8{category}] (%{context}): %{message}\\n%{throwable}");
        this.m_formatter = formatter;
    }

    public DefaultOutputLogTarget() {
        this.m_output = new OutputStreamWriter(System.out);
        this.initPattern();
    }

    public DefaultOutputLogTarget(OutputStream output) {
        this.m_output = new OutputStreamWriter(output);
        this.initPattern();
    }

    public DefaultOutputLogTarget(Writer writer) {
        this.m_output = writer;
        this.initPattern();
    }

    protected void output(String data) {
        try {
            this.m_output.write(data);
            this.m_output.flush();
        }
        catch (IOException ioe) {
            LogKit.log("IOException in DefaultOutputLogTarget", ioe);
        }
    }

    public void setFormat(String format) {
        ((PatternFormatter)this.m_formatter).setFormat(format);
    }
}

