
import java.sql.*;


/**
 * test inserting and retrieving 255 character long strings
 *
 */
public class t0040
{
   static String longString(char ch) 
   {
      int                 i;
      String              str255 = "";

      for(i=0; i<255; i++)
      {
         str255 = str255 + ch;
      }
      return str255;
   }

   static public void main(String args[])
      throws SQLException, java.lang.ClassNotFoundException 
   {
      boolean    passed = true;

      System.out.println("test inserting and retrieving 255 character long strings");

      // open the database
      Class.forName("com.internetcds.jdbc.tds.Driver");
      

      int           i;
      int           count    = 0;
      Connection    cx       = Common.getConnection();
      Statement     stmt     = cx.createStatement();


         
      
      try
      {
         stmt.executeUpdate("drop table t0040");
      }
      catch (SQLException e)
      {
         if (! (e.getMessage().startsWith("Cannot drop the table 't0040', because it does")))
         {
            System.out.println("|" + e.getMessage() + "|");
            throw e;
         }
      }
      
      count = stmt.executeUpdate(""
                                 + "create table t0040 (                "
                                 + "   c255 char(255)     not null,     "
                                 + "   v255 varchar(255)  not null)     ");
      System.out.println("Creating table affected " + count + " rows");
      

      PreparedStatement   pStmt1   = cx.prepareStatement(
         "insert into t0040 values (?, ?)");
      PreparedStatement   pStmt2   = cx.prepareStatement(
         "select c255, v255 from t0040 order by c255");
      
      
      pStmt1.setString(1, longString('a'));
      pStmt1.setString(2, longString('a'));
      count = pStmt1.executeUpdate();
      System.out.println("Added " + count + " rows");

      count = stmt.executeUpdate("" 
                                 + "insert into t0040 values ( "
                                 + "'" + longString('b') + "', "
                                 + "'" + longString('b') + "')");
      System.out.println("Added " + count + " rows");


      ResultSet  rs = pStmt2.executeQuery();
      
      passed = passed && rs.next();
      passed = passed && rs.getString("c255").equals(longString('a'));
      passed = passed && rs.getString("v255").equals(longString('a'));
      
      passed = passed && rs.next();
      passed = passed && rs.getString("c255").equals(longString('b'));
      passed = passed && rs.getString("v255").equals(longString('b'));

      rs = stmt.executeQuery("select c255, v255 from t0040 order by c255");
      passed = passed && rs.next();
      passed = passed && rs.getString("c255").equals(longString('a'));
      passed = passed && rs.getString("v255").equals(longString('a'));
      
      passed = passed && rs.next();
      passed = passed && rs.getString("c255").equals(longString('b'));
      passed = passed && rs.getString("v255").equals(longString('b'));


      System.out.println("\n" + (passed ? "Passed" : "Failed") 
                         + " t0040.\n");
      System.exit(passed ? 0 : 1);
   }
}

