import java.sql.*;
import java.io.*;


/**
 * test 7.0 features
 */
public class t0053
{
    static public void main(String args[])
        throws SQLException, java.lang.ClassNotFoundException,
        java.lang.Exception
    {
        boolean passed = true;

        int         count    = 0;
        Connection  cx       = Common.getConnection();
        Statement   stmt     = cx.createStatement();

        try
            {
                stmt.executeUpdate("drop table t0053");
            }
        catch (SQLException e)
            {
            }

        try
            {
                String sql =
                    "create table t0053 (                                  " +
                    " myvarchar                varchar(2000)  not null,    " +
                    " mynchar                  nchar(2000)    not null,    " +
                    " mynvarchar               nvarchar(2000) not null,    " +
                    " myntext                  ntext          not null     " +
                    " )   ";

                stmt.executeUpdate(sql);

                sql =
                    "insert into t0053               " +
                    "  (myvarchar,                   " +
                    "   mynchar,                     " +
                    "   mynvarchar,                  " +
                    "   myntext)                     " +
                    " values                         " +
                    "  (\'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA\',     " +
                    "   \'\',                  " +
                    "   \'\',                  " +
                    "   \'\'                   " +
                    "  )";
                stmt.executeUpdate(sql);

                sql = "select * from t0053";
                ResultSet rs = stmt.executeQuery(sql);
                if (!rs.next())
                    {
                        passed = false;
                    }
                else
                    {
                        System.err.print("Testing varchars > 255 chars: ");
                        String test = rs.getString(1);
                        if (test.length() == 270) {
                            System.err.println("passed");
                        } else {
                            System.err.println("failed");
                            passed = false;
                        }
                  
                        System.err.print("Testing nchar: ");
                        test = rs.getString(2);
                        if (test.length() == 2000 && "".equals(test.trim())) {
                            System.err.println("passed");
                        } else {
                            System.err.print("failed, got \'");
                            System.err.print(test.trim());
                            System.err.println("\' instead of \'\'");
                            passed = false;
                        }

                        System.err.print("Testing nvarchar: ");
                        test = rs.getString(3);
                        if (test.length() == 6 && "".equals(test)) {
                            System.err.println("passed");
                        } else {
                            System.err.print("failed, got \'");
                            System.err.print(test);
                            System.err.println("\' instead of \'\'");
                            passed = false;
                        }

                        System.err.print("Testing ntext: ");
                        test = rs.getString(4);
                        if (test.length() == 6 && "".equals(test)) {
                            System.err.println("passed");
                        } else {
                            System.err.print("failed, got \'");
                            System.err.print(test);
                            System.err.println("\' instead of \'\'");
                            passed = false;
                        }
                    }
            }
        catch(java.sql.SQLException e)
            {
                passed = false;
                System.out.println("Exception caught.  " + e.getMessage());
                e.printStackTrace();
            }

        System.out.println("\n" + (passed ? "Passed" : "Failed") 
                           + " t0053.\n");
        System.exit(passed ? 0 : 1);
    }
}

