//  Gant -- A Groovy build framework based on scripting Ant tasks.
//
//  Copyright © 2008 Russel Winder
//
//  Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in
//  compliance with the License. You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software distributed under the License is
//  distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
//  implied. See the License for the specific language governing permissions and limitations under the
//  License.

package org.codehaus.gant.ant.tests ;

import java.io.File ;

import org.apache.tools.ant.BuildException ;
import org.apache.tools.ant.Project ;
import org.apache.tools.ant.ProjectHelper ;

import junit.framework.TestCase ;

/**
 *  Unit tests for the Gant Ant task.  In order to test things appropriately this test must be initiated
 *  without any of the Groovy, Gant or related jars in the class path.  Also of course it must be a JUnit
 *  test with no connection to Groovy or Gant.
 *
 *  @author Russel Winder
 */
public class Gant_Test extends TestCase {
  private final File antFile = new File ( "src/test/groovy/org/codehaus/gant/ant/tests/gantTest.xml" ) ;
  private Project project ;

  //  This variable is assigned in the Gant script hence the public static.
  public static String returnValue ;
  
  protected void setUp ( ) throws Exception {
    super.setUp ( ) ;
    project = new Project ( ) ;
    //  The Ant jar is not on the classpath of the class loader :-(
    project.init ( ) ;
    ProjectHelper.getProjectHelper ( ).parse ( project , antFile ) ;
    returnValue = "" ;
  }
  
  public void testDefaultTarget ( ) {
    project.executeTarget ( "gantTestDefaultTarget" ) ;
    assertEquals ( "A test target in the default file." , returnValue ) ;
  }
  
  public void testNamedTarget ( ) {
    project.executeTarget ( "gantTestNamedTarget" ) ;
    assertEquals ( "Another target in the default file." , returnValue ) ;
  }

  public void testMissingGantfile ( ) {
    try { project.executeTarget ( "missingGantfile" ) ; }
    catch ( final BuildException be ) {
      assertEquals ( "Gantfile does not exist." , be.getMessage ( ) ) ;
      return ;
    }
    fail ( "Should have got a BuildException." ) ;
  }
  /**
   *  Test the behaviour of a missing target in the Ant XML file.
   */
  public void testUnknownTarget ( ) {
    try { project.executeTarget ( "blahBlahBlahBlah" ) ; }
    catch ( final BuildException be ) {
      assertEquals ( "Target \"blahBlahBlahBlah\" does not exist in the project \"Gant Ant Task Test\". " , be.getMessage ( ) ) ;
      return ;
    }
    fail ( "Should have got a BuildException." ) ;
  }
  /**
   *  Test for the taskdef-related verify error problem.  Whatever iot was supposed to do it passes now,
   *  2008-04-14.
   */
  public void testTaskdef ( ) {
    project.executeTarget ( "gantTaskdef" ) ;
    assertEquals ( "OK." , returnValue ) ;
  }
}
