/* GSnes9x -- confiles.h
 * Copyright (C) 1999 Canek Pelez Valds <canek@abulafia.fciencias.unam.mx>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef GSNES9X_CONFILES_H
#define GSNES9X_CONFILES_H

GlobalPrefs*        read_conf_file              ();
ROMInfo*            read_rom_info_file          (const gchar *rom_name);

void                assign_global_boolean_value (GlobalPrefs *prefs, gint key, gboolean val);
void                assign_global_string_value  (GlobalPrefs *prefs, gint key, gchar *val);
void                assign_global_number_value  (GlobalPrefs *prefs, gint key, gfloat val);
void                assign_rom_boolean_value    (ROMInfo *rom_info, gint key, gboolean val);
void                assign_rom_string_value     (ROMInfo *rom_info, gint key, gchar *val);
void                assign_rom_number_value     (ROMInfo *rom_info, gint key, gfloat val);

gint                keyword_key                 (const gchar* keyword, GSnes9xKeywordTypes type);
GSnes9xKeywordTypes keyword_type                (const gchar* lval);
gboolean            is_comment_line             (const gchar* str);

void                save_global_prefs           (GlobalPrefs *gp);
void                save_rom                    (ROMInfo *rom_info);

void                create_conf_file            ();

#endif

/* confiles.h ends here. */
