/* GSnes9x -- defs.h: Structs, enums and defines.
 *
 * Copyright (C) 1999 Canek Pelez Valds <canek@abulafia.fciencias.unam.mx>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef GSNES9X_GSNES9X_DEFS_H
#define GSNES9X_GSNES9X_DEFS_H

#ifdef __DEBUG__
# define F_NAME() g_print ("----- %s -----\n", G_GNUC_FUNCTION)
#else
# define F_NAME() ;
#endif

/* Default png. */
#define DEFAULT_IMAGE PIXMAPDIR "/gsnesdefault.png"
/* Configuration files directory. */
#define CONF_DIR      "gsnes9x.d"
/* ROMs titles file. */
#define ROMS_FILE     CONF_DIR "/ROMS"
/* Global preferences file. */
#define CONF_FILE     CONF_DIR "/GSnes9x.conf"

/* Max. length of each line in the configuration files. */
#define CONF_STR_LEN    512

/* Snes9X "constants". */
#define MAX_CODES        10
#define NUM_OF_JOYS       4
#define NUM_OF_BUTTONS    8

/* 256x239 is the default size of Snes9X in X. */
#define IMAGE_WIDTH     256
#define IMAGE_HEIGHT    239

#define MIX_BOOL_PREFS   28
#define ROM_BOOL_PREFS   16
#define GLOB_BOOL_PREFS   2

#define MIX_STR_PREFS     0
#define ROM_STR_PREFS     5
#define GLOB_STR_PREFS    4

#define MIX_NUM_PREFS     7
#define ROM_NUM_PREFS     0
#define GLOB_NUM_PREFS    0

#define CODES             3

typedef struct _GSnes9xData      GSnes9xData;
typedef struct _GlobalPrefs      GlobalPrefs;
typedef struct _GlobalPrefsData  GlobalPrefsData;
typedef struct _ROMInfo          ROMInfo;
typedef struct _ROMPrefsData     ROMPrefsData;
typedef struct _BrowseStruct     BrowseStruct;
typedef struct _AddROMInfo       AddROMInfo;
typedef struct _CheatCode        CheatCode;
typedef struct _CodesListStruct  CodesListStruct;
typedef struct _AddCodeStruct    AddCodeStruct;

typedef enum {
	/* Mixed prefs. */
	TRANSPARENCY      =  0, /* Graphics options */
	SIXTEEN           =  1,
	HIRES             =  2,
	NOMODESWITCH      =  3,
	FULLSCREEN        =  4,
	SCALE             =  5,
	DISPLAYFRAMERATE  =  6,
	NOSOUND           =  7, /* Sound options. */
	SOUNDSKIP         =  8,
	STEREO            =  9,
	SOUNDQUALITY      = 10,
	ENVX              = 11,
	SOUNDSYNC         = 12,
	ALTSAMPLEDECODE   = 13,
	INTERPOLATEDSOUND = 14,
	BUFFERSIZE        = 15,
	NOSAMPLECACHING   = 16,
	NOECHO            = 17,
	NOMASTERVOLUME    = 18, /* Speed up/slow options. */
	FRAMESKIP         = 19,
	FRAMETIME         = 20,
	CYCLES            = 21, /* Joystick options. */
	NOJOY             = 22,
	SWAP              = 23,
	JOYMAP0           = 24,
	JOYMAP1           = 25,
	JOYMAP2           = 26,
	JOYMAP3           = 27,
	/* ROM only prefs. */
	GAMEGENIE         = 28, /* Cheat options */
	ACTIONREPLAY      = 29,
	GOLDFINGER        = 30,
	INTERLEAVED       = 31, /* ROM image format options */
	INTERLEAVED2      = 32,
	HIROM             = 33,
	LOROM             = 34,
	HEADER            = 35,
	NOHEADER          = 36,
	PAL               = 37,
	NTSC              = 38,
	LAYERING          = 39,
	LOADSNAPSHOT      = 40,
	NOHDMA            = 41,
	NOSPEEDHACKS      = 42,
	NOWINDOWS         = 43,
	/* Global only prefs. */
	WITH_ESD          = 44, /* System options. */
	NETPLAY           = 45
} GSnes9xBoolPrefs;

typedef enum {
	/* Mix. prefs. */
	/* empty */
	/* ROM only prefs. */
	ROM_FILE       = 0,
	NAME           = 1,
	COMPANY        = 2,
	IMAGE_FILE     = 3,
	SNAPSHOT_FILE  = 4,
	/* Global only prefs. */
	SNES9X_COMMAND = 5,
	ROMS_DIR       = 6,
	SERVER         = 7,
	NETPORT        = 8
} GSnes9xStringPrefs;

typedef enum {
	SOUNDSKIP_NUMBER    = 0,
	SOUNDQUALITY_NUMBER = 1,
	BUFFERSIZE_NUMBER   = 2,
	FRAMESKIP_NUMBER    = 3,
	FRAMETIME_NUMBER    = 4,
	CYCLES_NUMBER       = 5,
	FILTER_NUMBER       = 6
} GSnes9xNumberPrefs;

typedef enum {
	GG_CODE = 0,
	AR_CODE = 1,
	GF_CODE = 2
} GSnes9xCheatCodes;

typedef enum {
	BOOLEAN_KEYWORD = 0,
	NUMBER_KEYWORD  = 1,
	STRING_KEYWORD  = 2,
	UNKNOW_KEYWORD  = 3
} GSnes9xKeywordTypes;

/* General Preferences */
struct _GlobalPrefs {
	/* Bools. */
	gboolean   bool_prefs[MIX_BOOL_PREFS+GLOB_BOOL_PREFS];
	/* Strings. */
	gchar     *string_prefs[MIX_STR_PREFS+GLOB_STR_PREFS];
	/* Numbers. */
	gfloat     number_prefs[MIX_NUM_PREFS+GLOB_NUM_PREFS];
	gshort     buttons[NUM_OF_JOYS][NUM_OF_BUTTONS];
};

/* Each ROM*/
struct _ROMInfo {
	/* Bools. */
	gboolean  bool_prefs[MIX_BOOL_PREFS+ROM_BOOL_PREFS];
	/* Strings. */
	gchar    *string_prefs[MIX_STR_PREFS+ROM_STR_PREFS];
	/* Numbers. */
	gfloat    number_prefs[MIX_NUM_PREFS+ROM_NUM_PREFS];
	gshort    buttons[NUM_OF_JOYS][NUM_OF_BUTTONS];
	/* Particular only. */
	gchar    *gamegenie_code[MAX_CODES];
	gchar    *actionreplay_code[MAX_CODES];
	gchar    *goldfinger_code[MAX_CODES];
};

struct _GSnes9xData {
	GtkWidget   *app;            /* Main Window. */
	GtkWidget   *popmenu;        /* Pop Up menu. */
	GtkWidget   *paned;          /* ROM list/Image. */
	GtkWidget   *image_w;        /* Image window. */
	GtkWidget   *roms_w;         /* ROM list window. */
	GtkWidget   *pixmap;         /* Image. */
	GtkWidget   *clist;          /* ROM list. */
	GtkWidget   *status;         /* Label of status. */
	GlobalPrefs *prefs;          /* Global Prefs. */
	GList       *roms_list;      /* List of ROMs info */
	gint         current_rom;    /* The selected ROM */
	gboolean     dialog_open;    /* Some dialog is open. */
	gboolean     about_open;     /* The about window is open. */
	gboolean     help_open;      /* The help window is open. */
	gint         width, height;  /* Width & length of the pixmap window. */
};

struct _BrowseStruct {
	GtkWidget *file_selection;
	GtkWidget *entry;
};

struct _CodesListStruct {
	GSnes9xCheatCodes  cc;
	GtkWidget         *dialog;
	GtkWidget         *clist;
	GtkWidget         *window;
	GList             *selection;
	GList             *list;
	ROMPrefsData      *rpd;
};

struct _AddROMInfo {
	GtkWidget   *entry[ROM_STR_PREFS-1];
	GtkWidget   *dialog;
	GSnes9xData *data;
};	

struct _AddCodeStruct {
	GtkWidget       *entry[3];
	GtkWidget       *dialog;
	CodesListStruct *cls;
};

struct _GlobalPrefsData {
	gboolean   changed;
	gboolean   nodata;
	
	GtkWidget *global_prefs_dialog;

	/* ----- Check buttons -----. */
	GtkWidget *check[MIX_BOOL_PREFS+GLOB_BOOL_PREFS];
	GtkWidget *code_add[CODES];
	GtkWidget *code_quit[CODES];
	GtkWidget *mono;
	/* ----- Text Entries ----- */
	GtkWidget *entry[GLOB_STR_PREFS];
	/* ----- Spin Buttons ----- */
	GtkWidget *spin[MIX_NUM_PREFS+GLOB_NUM_PREFS];
	GtkWidget *buttons[NUM_OF_JOYS][NUM_OF_BUTTONS]; /* Spin */
	/* ----- Buttons ----- */
	/* ----- Labels ----- */
	GtkWidget *code[CODES][MAX_CODES];
	
	GSnes9xData *data;
};

struct _ROMPrefsData {
	gboolean   changed;
	gboolean   nodata;
	
	GtkWidget *rom_prefs_dialog;

	/* ----- Check buttons. ----- */
	GtkWidget *check[MIX_BOOL_PREFS+ROM_BOOL_PREFS];
	GtkWidget *mono;
	/* ----- Text Entries ----- */
	GtkWidget *entry[MIX_STR_PREFS+ROM_STR_PREFS];
	/* ----- Spin Buttons ----- */
	GtkWidget *spin[MIX_NUM_PREFS+ROM_NUM_PREFS];
	GtkWidget *buttons[NUM_OF_JOYS][NUM_OF_BUTTONS]; /* Spin */

	/* ----- Buttons ----- */
	GtkWidget *load_defaults;	
	GtkWidget *browse_snapfile;
	GtkWidget *code_change[CODES];
	GtkWidget *code_clean[CODES];
	/* Labels */
	GtkWidget *code[CODES][MAX_CODES];

	GSnes9xData  *data;
	ROMInfo      *rom_info;
};

struct _CheatCode {
	gchar *code;
	gchar *name;
	gchar *descr;
};

#endif

/* defs.h ends here. */
