/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * This file is part of J11.                                       *
 * See the file "J11-LICENSE" for Copyright information and the    *
 * terms and conditions for copying, distribution and              *
 * modification of J11.                                            *
 *                                                                 *
 * Copied verbatim from the SableCC grammars Java 1.1 sample,      *
 * licensed under the Library General Public License.              *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

package com.bluemarsh.jswat.parser;

import com.bluemarsh.jswat.parser.unicodepreprocessor.lexer.*;
import com.bluemarsh.jswat.parser.unicodepreprocessor.node.*;
import com.bluemarsh.jswat.parser.unicodepreprocessor.analysis.*;
import com.bluemarsh.jswat.parser.unicodepreprocessor.*;
import java.io.*;

public class UnicodePreprocessor extends Reader
{
    private UnicodeLexer lexer;
    private ProcessToken processor = new ProcessToken();

    public UnicodePreprocessor(PushbackReader in)
    {
        lexer = new UnicodeLexer(in);
    }

    public int read() throws IOException
    {
        if(available == 0)
        {
            try
            {
                lexer.next().apply(processor);
            }
            catch(LexerException e)
            {
                throw new RuntimeException(e.toString());
            }
        }

        if(available == 0)
        {
            return -1;
        }

        char c = buffer[0];
        buffer[0] = buffer[1];
        available--;

//        System.out.print((char) c);
        return c;
    }

    public int read(
        char cbuf[],
        int off,
        int len) throws IOException
    {
        for(int i = 0; i <len; i++)
        {
            int c = read();

            if(c == -1)
            {
                if(i == 0)
                {
                    return -1;
                }
                else
                {
                    return i;
                }
            }

            cbuf[off + i] = (char) c;
        }

        return len;
    }

    int available;
    char[] buffer = new char[2];

    private class ProcessToken extends AnalysisAdapter
    {
        public void caseTEvenBackslash(TEvenBackslash node)
        {
            buffer[0] = '\\';
            buffer[1] = '\\';
            available = 2;
        }

        public void caseTUnicodeEscape(TUnicodeEscape node)
        {
            String text = node.getText();
            buffer[0] = (char) Integer.parseInt(text.substring(text.length() - 4), 16);
            available = 1;
        }

        public void caseTErroneousEscape(TErroneousEscape node)
        {
            throw new RuntimeException("Erroneous escape: " + node);
        }

        public void caseTSub(TSub node)
        {
            buffer[0] = node.getText().charAt(0);
            available = 1;
        }

        public void caseTRawInputCharacter(TRawInputCharacter node)
        {
            buffer[0] = node.getText().charAt(0);
            available = 1;
        }

        public void caseEOF(EOF node)
        {
            available = 0;
        }
    }

    public void close()
    {
    }
}
